/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.config.configtypes;

import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;

public class BuiltInFilePropertyResolver
implements PropertyResolver {
    private static final String SAMEDIR_LOC = "samedir";
    private static final String CONFIG_LOC = "config_loc";
    private final String mBuiltInConfigLocation;

    public BuiltInFilePropertyResolver(String builtInConfigLocation) {
        this.mBuiltInConfigLocation = builtInConfigLocation;
    }

    public String resolve(String property) throws CheckstyleException {
        int lastSlash;
        String value = null;
        if ((SAMEDIR_LOC.equals(property) || CONFIG_LOC.equals(property)) && this.mBuiltInConfigLocation != null && (lastSlash = this.mBuiltInConfigLocation.lastIndexOf("/")) > -1) {
            value = this.mBuiltInConfigLocation.substring(0, lastSlash + 1);
        }
        if (value != null) {
            try {
                URL bundleLocatedURL = new URL(value);
                URL fileURL = FileLocator.toFileURL((URL)bundleLocatedURL);
                value = FileUtils.toFile((URL)fileURL).toString();
            }
            catch (IOException e) {
                throw new CheckstyleException(e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }
}

