/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager;

import java.io.File;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.UIThreadDownloadDisallowed;

public class DownloadableItem {
    private final URL url;
    protected final DownloadManager downloader;
    private String name;
    protected IStatus downloadStatus = Status.OK_STATUS;

    public DownloadableItem(URL url, DownloadManager downloader) {
        this.url = url;
        this.downloader = downloader;
    }

    public void setFileName(String n) {
        this.name = n;
    }

    public URL getURL() {
        return this.url;
    }

    public File getFile() throws Exception {
        try {
            final File[] fileBox = new File[1];
            this.downloader.doWithDownload(this, new DownloadManager.DownloadRequestor(){

                @Override
                public void exec(File downloadedFile) throws Exception {
                    fileBox[0] = downloadedFile;
                }
            });
            this.downloadStatus = Status.OK_STATUS;
            return fileBox[0];
        }
        catch (UIThreadDownloadDisallowed e) {
            throw e;
        }
        catch (Exception e) {
            this.downloadStatus = this.error(ExceptionUtil.getMessage(e));
            throw e;
        }
    }

    protected IStatus error(String message) {
        return new Status(4, "org.springsource.ide.eclipse.commons.frameworks.core", message);
    }

    protected String getFileName() {
        if (this.name == null) {
            try {
                MessageDigest sha1encoder = MessageDigest.getInstance("sha1");
                byte[] bytes = sha1encoder.digest(("" + this.getURL()).getBytes());
                this.name = new String(Base64.encodeBase64((byte[])bytes));
                this.name = this.name.replace('/', '_');
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error(e);
            }
        }
        return this.name;
    }

    public String toString() {
        return this.url.toString();
    }

    public boolean isDownloaded() {
        return this.downloader != null && this.downloader.isDownloaded(this);
    }

    public IStatus getDownloadStatus() {
        return this.downloadStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.url != null && !"file".equals(this.url.getProtocol())) {
            DownloadManager downloadManager = this.downloader;
            synchronized (downloadManager) {
                File localFile = this.downloader.getLocalLocation(this);
                FileUtils.deleteQuietly((File)localFile);
            }
        }
    }

    public File getUnzipDir() {
        String fileName = this.getFileName();
        Assert.isTrue((boolean)fileName.endsWith(".zip"));
        File unzipLocation = new File(this.downloader.getCacheDir(), fileName.substring(0, fileName.length() - 4));
        return unzipLocation;
    }
}

