/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.search.internal.queries;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchMessages;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchScope;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.AbstractBeansQuery;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class BeanNameQuery
extends AbstractBeansQuery {
    public BeanNameQuery(BeansSearchScope scope, String pattern, boolean isCaseSensitive, boolean isRegexSearch) {
        super(scope, pattern, isCaseSensitive, isRegexSearch);
    }

    public String getLabel() {
        Object[] args = new Object[]{this.getPattern(), this.getScope().getDescription()};
        return MessageUtils.format((String)BeansSearchMessages.SearchQuery_searchFor_name, (Object[])args);
    }

    @Override
    protected boolean doesMatch(IModelElement element, Pattern pattern, IProgressMonitor monitor) {
        if (element instanceof IBean) {
            Bean bean = (Bean)element;
            if (pattern.matcher(bean.getElementName()).matches()) {
                return true;
            }
            String[] aliases = bean.getAliases();
            if (aliases != null) {
                String[] stringArray = aliases;
                int n = aliases.length;
                int n2 = 0;
                while (n2 < n) {
                    String alias = stringArray[n2];
                    if (pattern.matcher(alias).matches()) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }
}

