/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.search.internal.queries;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchMessages;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchResult;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchScope;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.PatternUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;

public abstract class AbstractBeansQuery
implements ISearchQuery {
    private BeansSearchScope scope;
    private String pattern;
    private Pattern compiledPattern;
    private ISearchResult result;

    public AbstractBeansQuery(BeansSearchScope scope, String pattern, boolean isCaseSensitive, boolean isRegexSearch) {
        Assert.isNotNull((Object)scope);
        this.scope = scope;
        this.pattern = pattern;
        this.compiledPattern = PatternUtils.createPattern((String)pattern, (boolean)isCaseSensitive, (boolean)isRegexSearch);
    }

    public BeansSearchScope getScope() {
        return this.scope;
    }

    public String getPattern() {
        return this.pattern;
    }

    public final ISearchResult getSearchResult() {
        if (this.result == null) {
            this.result = new BeansSearchResult(this);
        }
        return this.result;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public final IStatus run(IProgressMonitor monitor) {
        final BeansSearchResult result = (BeansSearchResult)this.getSearchResult();
        result.removeAll();
        IModelElement[] iModelElementArray = this.scope.getModelElements();
        int n = iModelElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement element = iModelElementArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IModelElementVisitor visitor = new IModelElementVisitor(){

                public boolean visit(IModelElement element, IProgressMonitor monitor) {
                    if (AbstractBeansQuery.this.doesMatch(element, AbstractBeansQuery.this.compiledPattern, monitor)) {
                        int lines;
                        int startLine;
                        if (element instanceof ISourceModelElement) {
                            ISourceModelElement sourceElement = (ISourceModelElement)element;
                            startLine = sourceElement.getElementStartLine();
                            lines = sourceElement.getElementEndLine() - startLine + 1;
                        } else {
                            startLine = -1;
                            lines = -1;
                        }
                        Match match = new Match((Object)element, 1, startLine, lines);
                        result.addMatch(match);
                    }
                    return true;
                }
            };
            element.accept(visitor, monitor);
            ++n2;
        }
        Object[] args = new Object[]{new Integer(result.getMatchCount())};
        String message = MessageUtils.format((String)BeansSearchMessages.SearchQuery_status, (Object[])args);
        return new Status(0, "org.springframework.ide.eclipse.beans.ui.search", 0, message, null);
    }

    protected abstract boolean doesMatch(IModelElement var1, Pattern var2, IProgressMonitor var3);
}

