/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation.rules;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.core.io.Resource;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanProperty;
import org.springframework.ide.eclipse.beans.core.internal.model.BeanReference;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.ValidationRuleUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansList;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansValueHolder;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.AbstractSourceModelElement;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.core.model.xml.XmlSourceLocation;
import org.springframework.util.StringUtils;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

public class BeanReferenceRule
implements IValidationRule<IBeansModelElement, IBeansValidationContext> {
    private List<String> ignorableBeans = new ArrayList<String>();

    public void setIgnorableBeans(String beanNames) {
        if (StringUtils.hasText((String)beanNames)) {
            this.ignorableBeans = Arrays.asList(StringUtils.delimitedListToStringArray((String)beanNames, (String)",", (String)"\r\n\f "));
        }
    }

    public boolean supports(IModelElement element, IValidationContext context) {
        IBean parentBean = BeansModelUtils.getParentOfClass(element, IBean.class);
        return (element instanceof Bean || element instanceof IBeansValueHolder || element instanceof IBeansList || element instanceof IBeansSet) && (element instanceof IBean && !((IBean)element).isInfrastructure() || parentBean != null && !parentBean.isInfrastructure());
    }

    public void validate(IBeansModelElement element, IBeansValidationContext context, IProgressMonitor monitor) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (!(element instanceof Bean)) break block2;
                        this.validateBean((Bean)element, context);
                        break block3;
                    }
                    if (!(element instanceof IBeansValueHolder)) break block4;
                    IBeansValueHolder holder = (IBeansValueHolder)element;
                    this.validateValue((IResourceModelElement)holder, holder.getValue(), context);
                    break block3;
                }
                if (!(element instanceof IBeansList)) break block5;
                IBeansList list = (IBeansList)element;
                for (Object entry : list.getList()) {
                    this.validateValue((IResourceModelElement)list, entry, context);
                }
                break block3;
            }
            if (!(element instanceof IBeansSet)) break block3;
            IBeansSet set = (IBeansSet)element;
            for (Object entry : set.getSet()) {
                this.validateValue((IResourceModelElement)set, entry, context);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void validateBean(Bean bean, IBeansValidationContext context) {
        block9: {
            bd = (AbstractBeanDefinition)bean.getBeanDefinition();
            if (bean.isChildBean() && (parentName = bean.getParentName()) != null && !SpringCoreUtils.hasPlaceHolder((String)parentName) && !this.ignorableBeans.contains(parentName)) {
                try {
                    context.getCompleteRegistry().getBeanDefinition(parentName);
                    break block9;
                }
                catch (NoSuchBeanDefinitionException v0) {
                    context.warning((IResourceModelElement)bean, "UNDEFINED_PARENT_BEAN", "Parent bean '" + parentName + "' not found", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)parentName), new ValidationProblemAttribute("BEAN_NAME", (Object)bean.getElementName())});
                    break block9;
                }
                catch (BeanDefinitionStoreException e) {
                    exp = e;
                    placeHolderFound = false;
                    ** while (exp != null && exp.getCause() != null)
                }
lbl-1000:
                // 1 sources

                {
                    msg = exp.getCause().getMessage();
                    if (msg.contains("${") && msg.contains("}")) {
                        placeHolderFound = true;
                        break;
                    }
                    exp = exp.getCause();
                    continue;
                }
lbl20:
                // 2 sources

                if (!placeHolderFound) {
                    context.warning((IResourceModelElement)bean, "UNDEFINED_PARENT_BEAN", "Parent bean '" + parentName + "' not found", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)parentName), new ValidationProblemAttribute("BEAN_NAME", (Object)bean.getElementName())});
                }
            }
        }
        if (bd.getDependsOn() != null) {
            var7_10 = bd.getDependsOn();
            var6_8 = var7_10.length;
            var5_6 = 0;
            while (var5_6 < var6_8) {
                beanName = var7_10[var5_6];
                this.validateDependsOnBean(bean, beanName, context);
                ++var5_6;
            }
        }
    }

    private void validateDependsOnBean(IBean bean, String beanName, IBeansValidationContext context) {
        block4: {
            if (beanName != null && !SpringCoreUtils.hasPlaceHolder((String)beanName) && !this.ignorableBeans.contains(beanName)) {
                try {
                    BeanDefinition dependsBd = context.getCompleteRegistry().getBeanDefinition(beanName);
                    if (dependsBd.isAbstract() || dependsBd.getBeanClassName() == null && dependsBd.getFactoryBeanName() == null) {
                        context.error((IResourceModelElement)bean, "INVALID_DEPENDS_ON_BEAN", "Referenced depends-on bean '" + beanName + "' is invalid (abstract or no bean class and no " + "factory bean)", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)beanName), new ValidationProblemAttribute("BEAN_NAME", (Object)bean.getElementName())});
                    }
                }
                catch (NoSuchBeanDefinitionException e) {
                    if (e.getBeanName().equals(bean.getElementName())) break block4;
                    context.warning((IResourceModelElement)bean, "UNDEFINED_DEPENDS_ON_BEAN", "Depends-on bean '" + beanName + "' not found", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)beanName), new ValidationProblemAttribute("BEAN_NAME", (Object)bean.getElementName())});
                }
            }
        }
    }

    private void validateValue(IResourceModelElement element, Object value, IBeansValidationContext context) {
        String beanName = null;
        if (value instanceof RuntimeBeanReference) {
            beanName = ((RuntimeBeanReference)value).getBeanName();
        } else if (value instanceof BeanReference) {
            beanName = ((BeanReference)value).getBeanName();
        } else if (value instanceof String) {
            beanName = (String)value;
        }
        this.validateBeanReference(element, context, beanName);
    }

    private URI getLocation(IResourceModelElement element) {
        if (element instanceof AbstractSourceModelElement) {
            AbstractSourceModelElement sourceElement = (AbstractSourceModelElement)element;
            IModelSourceLocation sourceLocation = sourceElement.getElementSourceLocation();
            if (sourceLocation instanceof XmlSourceLocation) {
                XmlSourceLocation xmlSourceLocation = (XmlSourceLocation)sourceLocation;
                Resource resource = xmlSourceLocation.getResource();
                try {
                    File file = resource.getFile();
                    if (file != null) {
                        return file.toURI();
                    }
                }
                catch (IOException iOException) {}
            }
        } else {
            return element.getElementResource().getLocationURI();
        }
        return null;
    }

    private void validateBeanReference(IResourceModelElement element, IBeansValidationContext context, String beanName) {
        block14: {
            URI elementURI = this.getLocation(element);
            URI rootURI = this.getLocation(context.getRootElement());
            if (elementURI != null && rootURI != null && !elementURI.equals(rootURI)) {
                return;
            }
            if (beanName != null && !SpringCoreUtils.hasPlaceHolder((String)beanName) && !this.ignorableBeans.contains(beanName)) {
                try {
                    BeanDefinition refBd = context.getCompleteRegistry().getBeanDefinition(beanName);
                    if (refBd.isAbstract() || refBd.getBeanClassName() == null && refBd.getFactoryBeanName() == null) {
                        context.error(element, "INVALID_REFERENCED_BEAN", "Referenced bean '" + beanName + "' is invalid " + "(abstract or no bean class and " + "no factory bean)", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)beanName), new ValidationProblemAttribute("BEAN_NAME", (Object)ValidationRuleUtils.getBeanName((IModelElement)element))});
                    }
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    if (ValidationRuleUtils.isFactoryBeanReference(beanName)) {
                        String tempBeanName = beanName.replaceFirst("[&]", "");
                        try {
                            BeanDefinition def = context.getCompleteRegistry().getBeanDefinition(tempBeanName);
                            String beanClassName = def.getBeanClassName();
                            if (beanClassName == null) break block14;
                            IType type = JdtUtils.getJavaType((IProject)BeansModelUtils.getProject((IModelElement)element).getProject(), (String)beanClassName);
                            if (type != null) {
                                if (!JdtUtils.doesImplement((IResource)context.getRootElementResource(), (IType)type, (String)FactoryBean.class.getName())) {
                                    context.error(element, "INVALID_FACTORY_BEAN", "Referenced factory bean '" + tempBeanName + "' does not implement the " + "interface 'FactoryBean'", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)tempBeanName), new ValidationProblemAttribute("BEAN_NAME", (Object)ValidationRuleUtils.getBeanName((IModelElement)element))});
                                }
                                break block14;
                            }
                            context.warning(element, "INVALID_REFERENCED_BEAN", "Referenced factory bean '" + tempBeanName + "' implementation class not found", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)tempBeanName), new ValidationProblemAttribute("BEAN_NAME", (Object)ValidationRuleUtils.getBeanName((IModelElement)element))});
                        }
                        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException2) {
                            context.warning(element, "UNDEFINED_FACTORY_BEAN", "Referenced factory bean '" + tempBeanName + "' not found", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)tempBeanName), new ValidationProblemAttribute("BEAN_NAME", (Object)ValidationRuleUtils.getBeanName((IModelElement)element))});
                        }
                        catch (BeanDefinitionStoreException beanDefinitionStoreException) {}
                        break block14;
                    }
                    if (element instanceof BeanProperty) {
                        context.warning(element, "UNDEFINED_REFERENCED_BEAN", "Referenced bean '" + beanName + "' not found", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)beanName), new ValidationProblemAttribute("BEAN_NAME", (Object)ValidationRuleUtils.getBeanName((IModelElement)element))});
                    } else {
                        context.warning(element, "UNDEFINED_REFERENCED_BEAN", "Referenced bean '" + beanName + "' not found", new ValidationProblemAttribute[]{new ValidationProblemAttribute("BEAN", (Object)beanName), new ValidationProblemAttribute("BEAN_NAME", (Object)ValidationRuleUtils.getBeanName((IModelElement)element))});
                    }
                }
                catch (BeanDefinitionStoreException beanDefinitionStoreException) {}
            }
        }
    }
}

