/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.SimpleBeanDefinitionRegistry;

public class BeanRegistrationContextTracker {
    private Stack<CompositeComponentDefinition> contexts;
    private Map<CompositeComponentDefinition, BeanDefinitionRegistry> registries;

    public BeanRegistrationContextTracker() {
        this.clear();
    }

    public void enter(CompositeComponentDefinition context) {
        this.contexts.push(context);
    }

    public void exit(CompositeComponentDefinition context) {
        Assert.isTrue((context == this.contexts.pop() ? 1 : 0) != 0);
    }

    public void registerBean(String beanName, BeanDefinition def) {
        BeanDefinitionRegistry registry = this.getRegistry();
        if (registry != null) {
            registry.registerBeanDefinition(beanName, def);
        }
    }

    protected BeanDefinitionRegistry getRegistry() {
        if (!this.contexts.isEmpty()) {
            CompositeComponentDefinition currentContext = this.contexts.peek();
            BeanDefinitionRegistry r = this.registries.get(currentContext);
            if (r == null) {
                r = this.createRegistry();
                this.registries.put(currentContext, r);
            }
            return r;
        }
        return null;
    }

    protected SimpleBeanDefinitionRegistry createRegistry() {
        SimpleBeanDefinitionRegistry r = new SimpleBeanDefinitionRegistry();
        return r;
    }

    public void clear() {
        this.contexts = new Stack();
        this.registries = new HashMap<CompositeComponentDefinition, BeanDefinitionRegistry>();
    }

    public CompositeComponentDefinition currentContext() {
        if (!this.contexts.isEmpty()) {
            return this.contexts.peek();
        }
        return null;
    }

    public BeanDefinitionRegistry getRegistry(CompositeComponentDefinition context) {
        if (this.registries != null) {
            return this.registries.get(context);
        }
        return null;
    }
}

