/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.internal.BufferedResourceNode;
import org.tigris.subversion.subclipse.ui.compare.internal.Utilities;

public class ConflictsCompareInput
extends CompareEditorInput {
    private Object fRoot;
    private BufferedResourceNode fAncestor;
    private BufferedResourceNode fLeft;
    private BufferedResourceNode fRight;
    private IFile fAncestorResource;
    private IFile fMineResource;
    private IFile fTheirsResource;
    private IFile fDestinationResource;
    private boolean neverSaved = true;
    private boolean isSaving = false;

    public ConflictsCompareInput(CompareConfiguration config) {
        super(config);
    }

    public void setResources(IFile ancestor, IFile mine, IFile theirs, IFile destination) {
        this.fAncestorResource = ancestor;
        this.fMineResource = mine;
        this.fTheirsResource = theirs;
        this.fDestinationResource = destination;
        this.initializeCompareConfiguration();
    }

    private String getType() {
        String s = this.fDestinationResource.getFileExtension();
        if (s != null) {
            return s;
        }
        return "???";
    }

    private void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        String leftLabel = "Merged - " + this.fDestinationResource.getName();
        String rightLabel = "Theirs - " + this.fTheirsResource.getName();
        String ancestorLabel = "Ancestor -" + this.fAncestorResource.getName();
        cc.setLeftLabel(leftLabel);
        cc.setRightLabel(rightLabel);
        cc.setAncestorLabel(ancestorLabel);
    }

    protected Object prepareInput(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
        try {
            byte[] contents;
            pm.beginTask(Utilities.getString("ResourceCompare.taskName"), -1);
            if (this.fMineResource != null) {
                this.fMineResource.refreshLocal(0, Policy.subMonitorFor(pm, -1));
            }
            if (this.fTheirsResource != null) {
                this.fTheirsResource.refreshLocal(0, Policy.subMonitorFor(pm, -1));
            }
            if (this.fAncestorResource != null) {
                this.fAncestorResource.refreshLocal(0, Policy.subMonitorFor(pm, -1));
            }
            if (this.fDestinationResource != null) {
                this.fDestinationResource.refreshLocal(0, Policy.subMonitorFor(pm, -1));
            }
            this.fAncestor = new BufferedResourceNode((IResource)this.fAncestorResource){

                public String getType() {
                    return ConflictsCompareInput.this.getType();
                }

                public boolean isEditable() {
                    return false;
                }

                public String getCharset() {
                    try {
                        return ConflictsCompareInput.this.fDestinationResource.getCharset();
                    }
                    catch (CoreException coreException) {
                        return null;
                    }
                }
            };
            this.fLeft = new BufferedResourceNode((IResource)this.fDestinationResource){

                public String getType() {
                    return ConflictsCompareInput.this.getType();
                }

                public String getCharset() {
                    try {
                        return ConflictsCompareInput.this.fDestinationResource.getCharset();
                    }
                    catch (CoreException coreException) {
                        return null;
                    }
                }
            };
            IFile resource = this.fMineResource != null ? this.fMineResource : this.fDestinationResource;
            InputStream mineContents = resource.getContents();
            try {
                contents = new byte[mineContents.available()];
                mineContents.read(contents);
            }
            finally {
                mineContents.close();
            }
            this.fLeft.setContent(contents);
            this.fLeft.addContentChangeListener(new IContentChangeListener(){

                public void contentChanged(IContentChangeNotifier source) {
                    if (!ConflictsCompareInput.this.isSaving) {
                        try {
                            ConflictsCompareInput.this.saveChanges((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            SVNUIPlugin.log(4, e.getMessage(), e);
                        }
                    }
                }
            });
            this.fRight = new BufferedResourceNode((IResource)this.fTheirsResource){

                public String getType() {
                    return ConflictsCompareInput.this.getType();
                }

                public boolean isEditable() {
                    return false;
                }

                public String getCharset() {
                    try {
                        return ConflictsCompareInput.this.fDestinationResource.getCharset();
                    }
                    catch (CoreException coreException) {
                        return null;
                    }
                }
            };
            String title = "Conflicts on " + this.fDestinationResource.getName();
            this.setTitle(title);
            Differencer d = new Differencer(){

                protected Object visit(Object data, int result, Object ancestor, Object left, Object right) {
                    return new MyDiffNode((IDiffContainer)data, result, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                }
            };
            Object object = this.fRoot = d.findDifferences(true, pm, null, (Object)this.fAncestor, (Object)this.fLeft, (Object)this.fRight);
            return object;
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            pm.done();
        }
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        try {
            this.isSaving = true;
            super.saveChanges(pm);
            this.fLeft.commit(pm);
            this.neverSaved = false;
            ((MyDiffNode)((Object)this.fRoot)).fireChange();
        }
        finally {
            this.isSaving = false;
        }
    }

    public boolean isSaveNeeded() {
        if (this.neverSaved) {
            return true;
        }
        return super.isSaveNeeded();
    }

    public static class MyDiffNode
    extends DiffNode {
        public MyDiffNode(IDiffContainer parent, int kind, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, kind, ancestor, left, right);
        }

        public void fireChange() {
            super.fireChange();
        }
    }
}

