/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNLogMessageCallback;

public class CancelableSVNLogMessageCallback
extends SVNLogMessageCallback {
    private IProgressMonitor monitor;
    private ISVNClientAdapter svnClient;
    private boolean canceled;

    public CancelableSVNLogMessageCallback(IProgressMonitor monitor, ISVNClientAdapter svnClient) {
        this.monitor = monitor;
        this.svnClient = svnClient;
    }

    public void singleMessage(ISVNLogMessage msg) {
        super.singleMessage(msg);
        if (this.monitor != null && this.monitor.isCanceled() && !this.canceled) {
            try {
                this.svnClient.cancelOperation();
                this.canceled = true;
            }
            catch (SVNClientException e) {
                SVNUIPlugin.log(4, e.getMessage(), e);
            }
        }
    }
}

