/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.util;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.EnumValueParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.ArrayUtils;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.boot.util.StringUtil;

public class TypeUtil {
    private static final String STRING_TYPE_NAME = String.class.getName();
    private static final String INET_ADDRESS_TYPE_NAME = InetAddress.class.getName();
    private IJavaProject javaProject;
    private static final Map<String, String> PRIMITIVE_TYPE_NAMES = new HashMap<String, String>();
    private static final Map<String, Type> PRIMITIVE_TO_BOX_TYPE = new HashMap<String, Type>();
    public static final Type INTEGER_TYPE;
    private static final Set<String> ASSIGNABLE_TYPES;
    private static final Set<String> ATOMIC_TYPES;
    private static final Map<String, String[]> TYPE_VALUES;
    private static final Map<String, ValueParser> VALUE_PARSERS;
    private static final String[] NO_PARAMS;

    static {
        PRIMITIVE_TYPE_NAMES.put("java.lang.Boolean", "boolean");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Byte", "byte");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Short", "short");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Integer", "int");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Long", "long");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Double", "double");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Float", "float");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Character", "char");
        for (Map.Entry<String, String> e : PRIMITIVE_TYPE_NAMES.entrySet()) {
            PRIMITIVE_TO_BOX_TYPE.put(e.getValue(), new Type(e.getKey(), null));
        }
        INTEGER_TYPE = new Type("java.lang.Integer", null);
        ASSIGNABLE_TYPES = new HashSet<String>(Arrays.asList("java.lang.Boolean", "java.lang.String", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.Character", "java.lang.Byte", INET_ADDRESS_TYPE_NAME, "java.lang.String[]"));
        ATOMIC_TYPES = new HashSet<String>(PRIMITIVE_TYPE_NAMES.keySet());
        ATOMIC_TYPES.add(INET_ADDRESS_TYPE_NAME);
        ATOMIC_TYPES.add(STRING_TYPE_NAME);
        TYPE_VALUES = new HashMap<String, String[]>();
        TYPE_VALUES.put("java.lang.Boolean", new String[]{"true", "false"});
        VALUE_PARSERS = new HashMap<String, ValueParser>();
        VALUE_PARSERS.put(Byte.class.getName(), new RadixableParser(){

            @Override
            public Object parse(String str, int radix) {
                return Byte.parseByte(str, radix);
            }
        });
        VALUE_PARSERS.put(Integer.class.getName(), new RadixableParser(){

            @Override
            public Object parse(String str, int radix) {
                return Integer.parseInt(str, radix);
            }
        });
        VALUE_PARSERS.put(Long.class.getName(), new RadixableParser(){

            @Override
            public Object parse(String str, int radix) {
                return Long.parseLong(str, radix);
            }
        });
        VALUE_PARSERS.put(Short.class.getName(), new RadixableParser(){

            @Override
            public Object parse(String str, int radix) {
                return Short.parseShort(str, radix);
            }
        });
        VALUE_PARSERS.put(Double.class.getName(), new ValueParser(){

            @Override
            public Object parse(String str) {
                return Double.parseDouble(str);
            }
        });
        VALUE_PARSERS.put(Float.class.getName(), new ValueParser(){

            @Override
            public Object parse(String str) {
                return Float.valueOf(Float.parseFloat(str));
            }
        });
        VALUE_PARSERS.put(Boolean.class.getName(), new ValueParser(){

            @Override
            public Object parse(String str) {
                if ((str = str.toLowerCase()).equals("true")) {
                    return true;
                }
                if (str.equals("false")) {
                    return false;
                }
                throw new IllegalArgumentException("Value should be 'true' or 'false'");
            }
        });
        NO_PARAMS = new String[0];
    }

    public TypeUtil(IJavaProject jp) {
        this.javaProject = jp;
    }

    public ValueParser getValueParser(Type type) {
        ValueParser simpleParser = VALUE_PARSERS.get(type.getErasure());
        if (simpleParser != null) {
            return simpleParser;
        }
        String[] enumValues = this.getAllowedValues(type, EnumCaseMode.ALIASED);
        if (enumValues != null) {
            return new EnumValueParser(this.niceTypeName(type), enumValues);
        }
        return null;
    }

    public String[] getAllowedValues(Type enumType, EnumCaseMode caseMode) {
        if (enumType != null) {
            try {
                IField[] fields;
                String[] values = TYPE_VALUES.get(enumType.getErasure());
                if (values != null) {
                    if (caseMode == EnumCaseMode.ALIASED) {
                        String[] aliased = Arrays.copyOf(values, values.length * 2);
                        int i = 0;
                        while (i < values.length) {
                            aliased[i + values.length] = values[i].toUpperCase();
                            ++i;
                        }
                        return aliased;
                    }
                    return values;
                }
                IType type = this.findType(enumType.getErasure());
                if (type != null && type.isEnum() && (fields = type.getFields()) != null) {
                    ArrayList<String> enums = new ArrayList<String>(fields.length);
                    boolean addOriginal = caseMode == EnumCaseMode.ORIGNAL || caseMode == EnumCaseMode.ALIASED;
                    boolean addLowerCased = caseMode == EnumCaseMode.LOWER_CASE || caseMode == EnumCaseMode.ALIASED;
                    int i = 0;
                    while (i < fields.length) {
                        IField f = fields[i];
                        if (f.isEnumConstant()) {
                            String rawName = f.getElementName();
                            if (addOriginal) {
                                enums.add(rawName);
                            }
                            if (addLowerCased) {
                                enums.add(StringUtil.upperCaseToHyphens((String)rawName));
                            }
                        }
                        ++i;
                    }
                    return enums.toArray(new String[enums.size()]);
                }
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
            }
        }
        return null;
    }

    public String niceTypeName(Type _type) {
        StringBuilder buf = new StringBuilder();
        this.niceTypeName(_type, buf);
        return buf.toString();
    }

    public void niceTypeName(Type type, StringBuilder buf) {
        String typeStr = type.getErasure();
        String primTypeName = PRIMITIVE_TYPE_NAMES.get(typeStr);
        if (primTypeName != null) {
            buf.append(primTypeName);
        } else if (typeStr.startsWith("java.lang.")) {
            buf.append(typeStr.substring("java.lang.".length()));
        } else if (typeStr.startsWith("java.util.")) {
            buf.append(typeStr.substring("java.util.".length()));
        } else {
            buf.append(typeStr);
        }
        if (this.isEnum(type)) {
            String[] values = this.getAllowedValues(type, EnumCaseMode.ORIGNAL);
            if (values != null && values.length > 0) {
                buf.append("[");
                int max = Math.min(4, values.length);
                int i = 0;
                while (i < max) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(values[i]);
                    ++i;
                }
                if (max != values.length) {
                    buf.append(", ...");
                }
                buf.append("]");
            }
        } else if (type.isGeneric()) {
            Type[] params = type.getParams();
            buf.append("<");
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                this.niceTypeName(params[i], buf);
                ++i;
            }
            buf.append(">");
        }
    }

    public boolean isDotable(Type type) {
        String typeName = type.getErasure();
        if (typeName.equals("java.lang.Object")) {
            return false;
        }
        return !this.isAtomic(type);
    }

    public boolean isAtomic(Type type) {
        String typeName = type.getErasure();
        return ATOMIC_TYPES.contains(typeName) || this.isEnum(type);
    }

    public static boolean isBracketable(Type type) {
        return TypeUtil.isList(type);
    }

    public static boolean isList(Type type) {
        String erasure = type.getErasure();
        try {
            Class<?> erasureClass = Class.forName(erasure);
            return List.class.isAssignableFrom(erasureClass);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isSequencable(Type type) {
        return TypeUtil.isList(type) || TypeUtil.isArray(type);
    }

    public static boolean isArray(Type type) {
        return type.getErasure().endsWith("[]");
    }

    public static boolean isMap(Type type) {
        String erasure = type.getErasure();
        try {
            Class<?> erasureClass = Class.forName(erasure);
            return Map.class.isAssignableFrom(erasureClass);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Type getDomainType(Type type) {
        if (TypeUtil.isArray(type)) {
            return TypeUtil.getArrayDomainType(type);
        }
        return ArrayUtils.lastElement(type.getParams());
    }

    private static Type getArrayDomainType(Type type) {
        if (type != null) {
            String fullName = type.getErasure();
            Assert.isLegal((boolean)fullName.endsWith("[]"));
            String elName = fullName.substring(0, fullName.length() - 2);
            return TypeUtil.normalizePrimitiveType(new Type(elName, null));
        }
        return null;
    }

    private static Type normalizePrimitiveType(Type type) {
        String name;
        Type boxType;
        if (type != null && (boxType = PRIMITIVE_TO_BOX_TYPE.get(name = type.getErasure())) != null) {
            return boxType;
        }
        return null;
    }

    public static Type getKeyType(Type mapOrArrayType) {
        if (TypeUtil.isBracketable(mapOrArrayType)) {
            return INTEGER_TYPE;
        }
        return ArrayUtils.firstElement(mapOrArrayType.getParams());
    }

    public boolean isAssignableType(Type type) {
        return ASSIGNABLE_TYPES.contains(type.getErasure()) || this.isEnum(type) || this.isAssignableList(type);
    }

    private boolean isAssignableList(Type type) {
        if (TypeUtil.isBracketable(type)) {
            Type domainType = TypeUtil.getDomainType(type);
            return this.isAtomic(domainType);
        }
        return false;
    }

    public boolean isEnum(Type type) {
        try {
            IType eclipseType = this.findType(type.getErasure());
            if (eclipseType != null) {
                return eclipseType.isEnum();
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return false;
    }

    private IType findType(String typeName) {
        try {
            if (this.javaProject != null) {
                return this.javaProject.findType(typeName);
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return null;
    }

    private IType findType(Type beanType) {
        return this.findType(beanType.getErasure());
    }

    public List<TypedProperty> getProperties(Type type, EnumCaseMode mode) {
        if (type == null) {
            return null;
        }
        if (!this.isDotable(type)) {
            return Collections.emptyList();
        }
        if (TypeUtil.isMap(type)) {
            String[] keyValues;
            Type keyType = TypeUtil.getKeyType(type);
            if (keyType != null && ArrayUtils.hasElements(keyValues = this.getAllowedValues(keyType, mode))) {
                Type valueType = TypeUtil.getDomainType(type);
                ArrayList<TypedProperty> properties = new ArrayList<TypedProperty>(keyValues.length);
                String[] stringArray = keyValues;
                int n = keyValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String propName = stringArray[n2];
                    properties.add(new TypedProperty(propName, valueType));
                    ++n2;
                }
                return properties;
            }
        } else {
            List<IMethod> setters;
            String typename = type.getErasure();
            IType eclipseType = this.findType(typename);
            if (eclipseType != null && (setters = this.getSetterMethods(eclipseType)) != null && !setters.isEmpty()) {
                ArrayList<TypedProperty> properties = new ArrayList<TypedProperty>(setters.size());
                for (IMethod m : setters) {
                    Type propType = Type.fromSignature(m.getParameterTypes()[0], eclipseType);
                    properties.add(new TypedProperty(this.setterNameToProperty(m.getElementName()), propType));
                }
                return properties;
            }
        }
        return null;
    }

    private String setterNameToProperty(String name) {
        Assert.isLegal((boolean)name.startsWith("set"));
        String camelName = String.valueOf(Character.toLowerCase(name.charAt(3))) + name.substring(4);
        return StringUtil.camelCaseToHyphens((String)camelName);
    }

    private List<IMethod> getSetterMethods(IType eclipseType) {
        try {
            IMethod[] allMethods;
            if (eclipseType != null && eclipseType.isClass() && ArrayUtils.hasElements(allMethods = eclipseType.getMethods())) {
                ArrayList<IMethod> setters = new ArrayList<IMethod>();
                IMethod[] iMethodArray = allMethods;
                int n = allMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    String sig;
                    int numParams;
                    IMethod m = iMethodArray[n2];
                    String mname = m.getElementName();
                    if (mname.startsWith("set") && mname.length() >= 4 && (numParams = Signature.getParameterCount((String)(sig = m.getSignature()))) == 1) {
                        setters.add(m);
                    }
                    ++n2;
                }
                return setters;
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return null;
    }

    public Map<String, Type> getPropertiesMap(Type type, EnumCaseMode mode) {
        List<TypedProperty> list = this.getProperties(type, mode);
        if (list != null) {
            HashMap<String, Type> map = new HashMap<String, Type>();
            for (TypedProperty p : list) {
                map.put(p.getName(), p.getType());
            }
            return map;
        }
        return null;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IField getField(Type beanType, String propName) {
        IType type = this.findType(beanType);
        IField f = type.getField(StringUtil.hyphensToCamelCase((String)propName, (boolean)false));
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public IMethod getSetter(Type beanType, String propName) {
        try {
            String setterName = "set" + StringUtil.hyphensToCamelCase((String)propName, (boolean)true);
            IType type = this.findType(beanType);
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                if (setterName.equals(m.getElementName())) {
                    return m;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return null;
    }

    public IJavaElement getGetter(Type beanType, String propName) {
        String getterName = "get" + StringUtil.hyphensToCamelCase((String)propName, (boolean)true);
        IType type = this.findType(beanType);
        IMethod m = type.getMethod(getterName, NO_PARAMS);
        if (m.exists()) {
            return m;
        }
        return null;
    }

    public static enum EnumCaseMode {
        LOWER_CASE,
        ORIGNAL,
        ALIASED;

    }

    private static abstract class RadixableParser
    implements ValueParser {
        private RadixableParser() {
        }

        protected abstract Object parse(String var1, int var2);

        @Override
        public Object parse(String str) {
            if (str.startsWith("0")) {
                if (str.startsWith("0x") || str.startsWith("0X")) {
                    return this.parse(str.substring(2), 16);
                }
                if (str.startsWith("0b") || str.startsWith("0B")) {
                    return this.parse(str.substring(2), 2);
                }
                return this.parse(str, 8);
            }
            return this.parse(str, 10);
        }
    }

    public static interface ValueParser {
        public Object parse(String var1);
    }
}

