/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.configurationmetadata.ConfigurationMetadataGroup;
import org.springframework.configurationmetadata.ConfigurationMetadataProperty;
import org.springframework.configurationmetadata.ConfigurationMetadataRepository;
import org.springframework.configurationmetadata.ConfigurationMetadataSource;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.StsConfigMetadataRepositoryJsonLoader;

public class SpringPropertyIndex
extends FuzzyMap<PropertyInfo> {
    public SpringPropertyIndex(IJavaProject jp) {
        try {
            StsConfigMetadataRepositoryJsonLoader loader = new StsConfigMetadataRepositoryJsonLoader();
            ConfigurationMetadataRepository metadata = loader.load(jp);
            Collection<ConfigurationMetadataProperty> allEntries = metadata.getAllProperties().values();
            for (ConfigurationMetadataProperty item : allEntries) {
                this.add(new PropertyInfo(item));
            }
            for (ConfigurationMetadataGroup group : metadata.getAllGroups().values()) {
                for (ConfigurationMetadataSource source : group.getSources().values()) {
                    for (ConfigurationMetadataProperty prop : source.getProperties().values()) {
                        PropertyInfo info = (PropertyInfo)this.get(prop.getId());
                        info.addSource(source);
                    }
                }
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
    }

    public void dumpAsTestData() {
        List allData = this.find("");
        for (FuzzyMap.Match match : allData) {
            PropertyInfo d = (PropertyInfo)match.data;
            System.out.println("data(" + this.dumpString(d.getId()) + ", " + this.dumpString(d.getType()) + ", " + this.dumpString(d.getDefaultValue()) + ", " + this.dumpString(d.getDescription()) + ");");
        }
    }

    private String dumpString(Object v) {
        if (v == null) {
            return "null";
        }
        return this.dumpString("" + v);
    }

    private String dumpString(String s) {
        if (s == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder("\"");
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++n2;
        }
        buf.append("\"");
        return buf.toString();
    }

    public SpringPropertyIndex() {
    }

    @Override
    protected String getKey(PropertyInfo entry) {
        return entry.getId();
    }
}

