/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.ICompletionEngine;
import org.springframework.ide.eclipse.boot.properties.editor.IPropertyHoverInfoProvider;
import org.springframework.ide.eclipse.boot.properties.editor.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertyHoverInfo;
import org.springframework.ide.eclipse.boot.properties.editor.completions.DocumentEdits;
import org.springframework.ide.eclipse.boot.properties.editor.completions.LazyProposalApplier;
import org.springframework.ide.eclipse.boot.properties.editor.completions.PropertyCompletionFactory;
import org.springframework.ide.eclipse.boot.properties.editor.completions.ProposalApplier;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.PropertyNavigator;
import org.springframework.ide.eclipse.boot.properties.editor.util.FuzzyMatcher;
import org.springframework.ide.eclipse.boot.properties.editor.util.PrefixFinder;
import org.springframework.ide.eclipse.boot.properties.editor.util.Provider;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.boot.util.StringUtil;

public class SpringPropertiesCompletionEngine
implements IPropertyHoverInfoProvider,
ICompletionEngine {
    private boolean preferLowerCaseEnums = true;
    private static final boolean DEBUG = false;
    public static final boolean DEFAULT_VALUE_INCLUDED = false;
    private static final PrefixFinder fuzzySearchPrefix = new PrefixFinder(){

        @Override
        protected boolean isPrefixChar(char c) {
            return !Character.isWhitespace(c);
        }
    };
    private static final PrefixFinder navigationPrefixFinder = new PrefixFinder(){

        @Override
        public String getPrefix(IDocument doc, int offset) {
            String prefix = super.getPrefix(doc, offset);
            char charBefore = this.getCharBefore(doc, prefix, offset);
            if (charBefore == '.' || charBefore == ']') {
                return prefix;
            }
            return null;
        }

        private char getCharBefore(IDocument doc, String prefix, int offset) {
            try {
                int offsetBefore;
                if (prefix != null && (offsetBefore = offset - prefix.length() - 1) >= 0) {
                    return doc.getChar(offsetBefore);
                }
            }
            catch (BadLocationException badLocationException) {}
            return '\u0000';
        }

        @Override
        protected boolean isPrefixChar(char c) {
            return !Character.isWhitespace(c) && c != ']' && c != ']' && c != '.';
        }
    };
    private static final IContentProposal[] NO_CONTENT_PROPOSALS = new IContentProposal[0];
    private DocumentContextFinder documentContextFinder = null;
    private Provider<FuzzyMap<PropertyInfo>> indexProvider = null;
    private TypeUtil typeUtil = null;
    private PropertyCompletionFactory completionFactory = null;

    public static void debug(String msg) {
    }

    public SpringPropertiesCompletionEngine() {
    }

    public SpringPropertiesCompletionEngine(final IJavaProject jp) throws Exception {
        this.indexProvider = new Provider<FuzzyMap<PropertyInfo>>(){

            @Override
            public FuzzyMap<PropertyInfo> get() {
                return SpringPropertiesEditorPlugin.getIndexManager().get(jp);
            }
        };
        this.setDocumentContextFinder(DocumentContextFinder.DEFAULT);
        this.typeUtil = new TypeUtil(jp);
    }

    @Override
    public Collection<ICompletionProposal> getCompletions(IDocument doc, int offset) throws BadLocationException {
        ITypedRegion partition = this.getPartition(doc, offset);
        String type = partition.getType();
        if (type.equals("__dftl_partition_content_type")) {
            return this.getPropertyCompletions(doc, offset);
        }
        if (type.equals("__pf_roperty_value")) {
            return this.getValueCompletions(doc, offset, partition);
        }
        return Collections.emptyList();
    }

    private Collection<ICompletionProposal> getNavigationProposals(IDocument doc, int offset) {
        String navPrefix = navigationPrefixFinder.getPrefix(doc, offset);
        try {
            int regionStart;
            PropertyNavigator navigator;
            Type type;
            PropertyInfo prop;
            int navOffset;
            if (navPrefix != null && (navPrefix = fuzzySearchPrefix.getPrefix(doc, navOffset = offset - navPrefix.length() - 1)) != null && !navPrefix.isEmpty() && (prop = SpringPropertiesCompletionEngine.findLongestValidProperty(this.getIndex(), navPrefix)) != null && (type = (navigator = new PropertyNavigator(doc, null, this.typeUtil, this.region(regionStart = navOffset - navPrefix.length(), navOffset))).navigate(regionStart + prop.getId().length(), TypeParser.parse(prop.getType()))) != null) {
                return this.getNavigationProposals(doc, type, navOffset, offset);
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return Collections.emptyList();
    }

    private IRegion region(int start, int end) {
        return new Region(start, end - start);
    }

    private Collection<ICompletionProposal> getNavigationProposals(IDocument doc, Type type, int navOffset, int offset) {
        try {
            String prefix;
            TypeUtil.EnumCaseMode caseMode;
            List<TypedProperty> objectProperties;
            char navOp = doc.getChar(navOffset);
            if (navOp == '.' && (objectProperties = this.typeUtil.getProperties(type, caseMode = this.caseMode(prefix = doc.get(navOffset + 1, offset - (navOffset + 1))))) != null && !objectProperties.isEmpty()) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                for (TypedProperty prop : objectProperties) {
                    double score = FuzzyMatcher.matchScore(prefix, prop.getName());
                    if (score == 0.0) continue;
                    Type valueType = prop.getType();
                    String postFix = this.propertyCompletionPostfix(valueType);
                    DocumentEdits edits = new DocumentEdits(doc);
                    edits.delete(navOffset + 1, offset);
                    edits.insert(offset, String.valueOf(prop.getName()) + postFix);
                    proposals.add(this.completionFactory.simpleProposal(prop.getName(), score, (ProposalApplier)edits));
                }
                return proposals;
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return Collections.emptyList();
    }

    protected TypeUtil.EnumCaseMode caseMode(String prefix) {
        TypeUtil.EnumCaseMode caseMode = "".equals(prefix) ? (this.preferLowerCaseEnums ? TypeUtil.EnumCaseMode.LOWER_CASE : TypeUtil.EnumCaseMode.ORIGNAL) : (Character.isLowerCase(prefix.charAt(0)) ? TypeUtil.EnumCaseMode.LOWER_CASE : TypeUtil.EnumCaseMode.ORIGNAL);
        return caseMode;
    }

    protected String propertyCompletionPostfix(Type type) {
        String postfix = "";
        if (type != null) {
            if (this.typeUtil.isAssignableType(type)) {
                postfix = "=";
            } else if (TypeUtil.isBracketable(type)) {
                postfix = "[";
            } else if (this.typeUtil.isDotable(type)) {
                postfix = ".";
            }
        }
        return postfix;
    }

    public static boolean isAssign(char assign) {
        return assign == ':' || assign == '=';
    }

    private ITypedRegion getPartition(IDocument doc, int offset) throws BadLocationException {
        ITypedRegion part = TextUtilities.getPartition((IDocument)doc, (String)"___pf_partitioning", (int)offset, (boolean)true);
        if (part.getType() == "__dftl_partition_content_type" && part.getLength() == 0 && offset == doc.getLength() && offset > 0) {
            char assign = doc.getChar(offset - 1);
            if (SpringPropertiesCompletionEngine.isAssign(assign)) {
                return new TypedRegion(offset - 1, 1, "__pf_roperty_value");
            }
            ITypedRegion previousPart = TextUtilities.getPartition((IDocument)doc, (String)"___pf_partitioning", (int)(offset - 1), (boolean)true);
            int previousEnd = previousPart.getOffset() + previousPart.getLength();
            if (previousEnd == offset) {
                return previousPart;
            }
        }
        return part;
    }

    private Collection<ICompletionProposal> getValueCompletions(IDocument doc, int offset, ITypedRegion valuePartition) {
        int regionStart = valuePartition.getOffset();
        int startOfValue = this.findValueStart(doc, regionStart);
        try {
            Type type;
            String[] valueCompletions;
            String valuePrefix;
            if (startOfValue >= 0 && startOfValue < offset) {
                valuePrefix = doc.get(startOfValue, offset - startOfValue);
            } else {
                startOfValue = offset;
                valuePrefix = "";
            }
            TypeUtil.EnumCaseMode caseMode = this.caseMode(valuePrefix);
            String propertyName = fuzzySearchPrefix.getPrefix(doc, regionStart);
            if (propertyName != null && (valueCompletions = this.typeUtil.getAllowedValues(type = this.getValueType(propertyName), caseMode)) != null && valueCompletions.length > 0) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                int i = 0;
                while (i < valueCompletions.length) {
                    String valueCandidate = valueCompletions[i];
                    double score = FuzzyMatcher.matchScore(valuePrefix, valueCandidate);
                    if (score != 0.0) {
                        DocumentEdits edits = new DocumentEdits(doc);
                        edits.delete(startOfValue, offset);
                        edits.insert(offset, valueCandidate);
                        proposals.add(this.completionFactory.valueProposal(valueCandidate, type, score, (ProposalApplier)edits));
                    }
                    ++i;
                }
                return proposals;
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return Collections.emptyList();
    }

    protected Type getValueType(String propertyName) {
        try {
            PropertyInfo prop = this.getIndex().get(propertyName);
            if (prop != null) {
                return TypeParser.parse(prop.getType());
            }
            prop = SpringPropertiesCompletionEngine.findLongestValidProperty(this.getIndex(), propertyName);
            if (prop != null) {
                Document doc = new Document(propertyName);
                PropertyNavigator navigator = new PropertyNavigator((IDocument)doc, null, this.typeUtil, (IRegion)new Region(0, doc.getLength()));
                return navigator.navigate(prop.getId().length(), TypeParser.parse(prop.getType()));
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return null;
    }

    private int findValueStart(IDocument doc, int pos) {
        try {
            pos = SpringPropertiesCompletionEngine.skipWhiteSpace(doc, pos);
            if (pos >= 0) {
                char assign = doc.getChar(pos);
                if (!SpringPropertiesCompletionEngine.isAssign(assign)) {
                    return pos;
                }
                if ((pos = SpringPropertiesCompletionEngine.skipWhiteSpace(doc, pos + 1)) >= 0) {
                    return pos;
                }
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return -1;
    }

    private List<FuzzyMap.Match<PropertyInfo>> findMatches(String prefix) {
        List<FuzzyMap.Match<PropertyInfo>> matches = this.getIndex().find(StringUtil.camelCaseToHyphens((String)prefix));
        return matches;
    }

    private Collection<ICompletionProposal> getPropertyCompletions(IDocument doc, int offset) throws BadLocationException {
        Collection<ICompletionProposal> navProposals = this.getNavigationProposals(doc, offset);
        if (!navProposals.isEmpty()) {
            return navProposals;
        }
        return this.getFuzzyCompletions(doc, offset);
    }

    protected Collection<ICompletionProposal> getFuzzyCompletions(final IDocument doc, final int offset) {
        List<FuzzyMap.Match<PropertyInfo>> matches;
        final String prefix = fuzzySearchPrefix.getPrefix(doc, offset);
        if (prefix != null && (matches = this.findMatches(prefix)) != null && !matches.isEmpty()) {
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(matches.size());
            for (final FuzzyMap.Match match : matches) {
                LazyProposalApplier edits = new LazyProposalApplier(){

                    @Override
                    protected ProposalApplier create() throws Exception {
                        Type type = TypeParser.parse(((PropertyInfo)match.data).getType());
                        DocumentEdits edits = new DocumentEdits(doc);
                        edits.delete(offset - prefix.length(), offset);
                        edits.insert(offset, String.valueOf(((PropertyInfo)match.data).getId()) + SpringPropertiesCompletionEngine.this.propertyCompletionPostfix(type));
                        return edits;
                    }
                };
                proposals.add(this.completionFactory.property(doc, edits, match, this.typeUtil));
            }
            return proposals;
        }
        return Collections.emptyList();
    }

    public IContentProposal[] getPropertyFieldProposals(String contents, int position) {
        List<FuzzyMap.Match<PropertyInfo>> matches;
        String prefix = contents.substring(0, position);
        if (StringUtil.hasText((String)prefix) && (matches = this.findMatches(prefix)) != null && !matches.isEmpty()) {
            IContentProposal[] proposals = new IContentProposal[matches.size()];
            Collections.sort(matches, new Comparator<FuzzyMap.Match<PropertyInfo>>(){

                @Override
                public int compare(FuzzyMap.Match<PropertyInfo> o1, FuzzyMap.Match<PropertyInfo> o2) {
                    int scoreCompare = Double.compare(o2.score, o1.score);
                    if (scoreCompare != 0) {
                        return scoreCompare;
                    }
                    return ((PropertyInfo)o1.data).getId().compareTo(((PropertyInfo)o2.data).getId());
                }
            });
            int i = 0;
            for (FuzzyMap.Match<PropertyInfo> m : matches) {
                proposals[i++] = new ContentProposal(((PropertyInfo)m.data).getId(), ((PropertyInfo)m.data).getDescription());
            }
            return proposals;
        }
        return NO_CONTENT_PROPOSALS;
    }

    @Override
    public SpringPropertyHoverInfo getHoverInfo(IDocument doc, IRegion region) {
        SpringPropertiesCompletionEngine.debug("getHoverInfo(" + region + ")");
        region = this.getHoverRegion(doc, region.getOffset());
        if (region != null) {
            try {
                SpringPropertiesCompletionEngine.debug("hoverRegion = " + region);
                PropertyInfo best = this.findBestHoverMatch(doc.get(region.getOffset(), region.getLength()).trim());
                if (best != null) {
                    return new SpringPropertyHoverInfo(this.documentContextFinder.getJavaProject(doc), best);
                }
            }
            catch (Exception e) {
                SpringPropertiesEditorPlugin.log(e);
            }
        }
        return null;
    }

    @Override
    public IRegion getHoverRegion(IDocument document, int offset) {
        try {
            ITypedRegion candidate = this.getPartition(document, offset);
            if (candidate != null && candidate.getType() == "__dftl_partition_content_type") {
                return candidate;
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return null;
    }

    private PropertyInfo findBestHoverMatch(String propName) {
        SpringPropertiesCompletionEngine.debug(">> findBestHoverMatch(" + propName + ")");
        SpringPropertiesCompletionEngine.debug("index size: " + this.getIndex().size());
        PropertyInfo best = null;
        int bestCommonPrefixLen = 0;
        int bestExtraLen = Integer.MAX_VALUE;
        for (PropertyInfo candidate : this.getIndex()) {
            int commonPrefixLen = StringUtil.commonPrefixLength((String)propName, (String)candidate.getId());
            int extraLen = candidate.getId().length() - commonPrefixLen;
            if (commonPrefixLen == propName.length() && extraLen == 0) {
                return candidate;
            }
            if (commonPrefixLen <= bestCommonPrefixLen && (commonPrefixLen != bestCommonPrefixLen || extraLen >= bestExtraLen)) continue;
            bestCommonPrefixLen = commonPrefixLen;
            bestExtraLen = extraLen;
            best = candidate;
        }
        SpringPropertiesCompletionEngine.debug("<< findBestHoverMatch(" + propName + "): " + best);
        return best;
    }

    public FuzzyMap<PropertyInfo> getIndex() {
        return this.indexProvider.get();
    }

    public Provider<FuzzyMap<PropertyInfo>> getIndexProvider() {
        return this.indexProvider;
    }

    public static int skipWhiteSpace(IDocument doc, int pos) {
        try {
            int end = doc.getLength();
            while (pos < end && Character.isWhitespace(doc.getChar(pos))) {
                ++pos;
            }
            if (pos < end) {
                return pos;
            }
        }
        catch (Exception e) {
            SpringPropertiesEditorPlugin.log(e);
        }
        return -1;
    }

    public void setDocumentContextFinder(DocumentContextFinder it) {
        this.documentContextFinder = it;
        this.completionFactory = new PropertyCompletionFactory(it);
    }

    public void setIndexProvider(Provider<FuzzyMap<PropertyInfo>> it) {
        this.indexProvider = it;
    }

    public void setTypeUtil(TypeUtil it) {
        this.typeUtil = it;
    }

    public TypeUtil getTypeUtil() {
        return this.typeUtil;
    }

    public boolean getPreferLowerCaseEnums() {
        return this.preferLowerCaseEnums;
    }

    public void setPreferLowerCaseEnums(boolean preferLowerCaseEnums) {
        this.preferLowerCaseEnums = preferLowerCaseEnums;
    }

    public static PropertyInfo findLongestValidProperty(FuzzyMap<PropertyInfo> index, String name) {
        int bracketPos = name.indexOf(91);
        int endPos = bracketPos >= 0 ? bracketPos : name.length();
        PropertyInfo prop = null;
        String prefix = null;
        while (endPos > 0 && prop == null) {
            prefix = name.substring(0, endPos);
            String canonicalPrefix = StringUtil.camelCaseToHyphens((String)prefix);
            prop = index.get(canonicalPrefix);
            if (prop != null) continue;
            endPos = name.lastIndexOf(46, endPos - 1);
        }
        if (prop != null) {
            return prop.withId(prefix);
        }
        return null;
    }
}

