/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.configurationmetadata;

import java.util.ArrayList;
import java.util.List;
import org.springframework.configurationmetadata.ConfigurationMetadataItem;
import org.springframework.configurationmetadata.ConfigurationMetadataSource;

class RawConfigurationMetadata {
    private final List<ConfigurationMetadataSource> sources;
    private final List<ConfigurationMetadataItem> items;

    RawConfigurationMetadata(List<ConfigurationMetadataSource> sources, List<ConfigurationMetadataItem> items) {
        this.sources = new ArrayList<ConfigurationMetadataSource>(sources);
        this.items = new ArrayList<ConfigurationMetadataItem>(items);
        for (ConfigurationMetadataItem item : this.items) {
            this.resolveName(item);
        }
    }

    public List<ConfigurationMetadataSource> getSources() {
        return this.sources;
    }

    public ConfigurationMetadataSource getSource(String type) {
        for (ConfigurationMetadataSource source : this.sources) {
            if (!type.equals(source.getType())) continue;
            return source;
        }
        return null;
    }

    public List<ConfigurationMetadataItem> getItems() {
        return this.items;
    }

    private void resolveName(ConfigurationMetadataItem item) {
        item.setName(item.getId());
        if (item.getSourceType() == null) {
            return;
        }
        ConfigurationMetadataSource source = this.getSource(item.getSourceType());
        if (source != null) {
            String groupId = source.getGroupId();
            String id = item.getId();
            if (id.startsWith(groupId)) {
                String name = id.substring(groupId.length() + 1, id.length());
                item.setName(name);
            }
        }
    }
}

