/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.internal.bestpractices.quickfix;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.internal.bestpractices.quickfix.XmlQuickFixUtil;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Element;

public class CreateNewClassMarkerResolution
implements IMarkerResolution2 {
    private static final String MESSAGE_ATTRIBUTE_KEY = "message";
    private String descriptionClassName = "";

    public CreateNewClassMarkerResolution(IMarker marker) {
        String markerMessage = marker.getAttribute(MESSAGE_ATTRIBUTE_KEY, "");
        this.descriptionClassName = this.extractQualifiedClassName(markerMessage);
    }

    private String extractClassNameFromMessage(String message) {
        String qualifiedClassName = this.extractQualifiedClassName(message);
        return qualifiedClassName.substring(qualifiedClassName.lastIndexOf(".") + 1, qualifiedClassName.length());
    }

    private String extractPackageNameFromMessage(String message) {
        if (message.length() == 0) {
            return "";
        }
        String qualifiedClassName = this.extractQualifiedClassName(message);
        int endPos = qualifiedClassName.lastIndexOf(".");
        if (endPos < 0) {
            return "";
        }
        return qualifiedClassName.substring(0, endPos);
    }

    private String extractQualifiedClassName(String message) {
        int startPos = message.indexOf("class '") + "class '".length() + 1;
        int endPos = message.indexOf("'", startPos);
        return message.substring(startPos, endPos);
    }

    public String getDescription() {
        return "Create class " + this.descriptionClassName + " declared in the bean definition";
    }

    public Image getImage() {
        return null;
    }

    public String getLabel() {
        return "Create class " + this.descriptionClassName;
    }

    private IPackageFragmentRoot inferPackageFragmentRoot(IJavaProject javaProject, String packageName) throws CoreException {
        try {
            IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
            int i = 0;
            while (i < packageFragmentRoots.length) {
                if (!(packageFragmentRoots[i] instanceof JarPackageFragmentRoot)) {
                    return packageFragmentRoots[i];
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            throw new CoreException(e.getStatus());
        }
        return null;
    }

    public void run(IMarker marker) {
        NewClassCreationWizard wizard = new NewClassCreationWizard();
        wizard.init(JavaPlugin.getDefault().getWorkbench(), null);
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText("New");
        IWizardPage[] pages = wizard.getPages();
        NewTypeWizardPage page = (NewTypeWizardPage)pages[0];
        String markerMessage = marker.getAttribute(MESSAGE_ATTRIBUTE_KEY, "");
        IJavaProject javaProject = JdtUtils.getJavaProject((IResource)marker.getResource());
        IPackageFragmentRoot sourcePackageFragmentRoot = null;
        String packageName = this.extractPackageNameFromMessage(markerMessage);
        try {
            sourcePackageFragmentRoot = this.inferPackageFragmentRoot(javaProject, packageName);
            if (sourcePackageFragmentRoot != null) {
                page.setPackageFragmentRoot(sourcePackageFragmentRoot, true);
                IPackageFragment packageFragment = sourcePackageFragmentRoot.getPackageFragment(packageName);
                if (packageFragment != null) {
                    page.setPackageFragment(packageFragment, true);
                }
            }
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)e.getStatus());
        }
        page.setTypeName(this.extractClassNameFromMessage(markerMessage), true);
        if (dialog.open() == 0) {
            IType createdType = (IType)wizard.getCreatedElement();
            String fullyQualifiedClassName = createdType.getFullyQualifiedName();
            this.updateXmlBeanClass(marker, fullyQualifiedClassName);
        }
    }

    private void updateXmlBeanClass(IMarker marker, String fullyQualifiedClassName) {
        IStructuredModel model = null;
        try {
            try {
                model = XmlQuickFixUtil.getModel(marker);
                Element beanElement = XmlQuickFixUtil.getMarkerElement(model, marker);
                beanElement.setAttribute("class", fullyQualifiedClassName);
                XmlQuickFixUtil.saveMarkedFile(marker);
            }
            catch (CoreException e) {
                StatusHandler.log((IStatus)e.getStatus());
                if (model != null) {
                    model.releaseFromEdit();
                    model = null;
                }
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
                model = null;
            }
        }
    }
}

