/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.wizards;

import com.atlassian.connector.eclipse.internal.jira.core.JiraClientFactory;
import com.atlassian.connector.eclipse.internal.jira.core.JiraCorePlugin;
import com.atlassian.connector.eclipse.internal.jira.core.model.Component;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueType;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.Priority;
import com.atlassian.connector.eclipse.internal.jira.core.model.Project;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.Version;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ComponentFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ContentFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.CurrentUserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.DateFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.DateRangeFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.FilterDefinition;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.IssueTypeFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.NobodyFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.PriorityFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ProjectFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.ResolutionFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.SpecificUserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.StatusFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.UserFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.UserInGroupFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.filter.VersionFilter;
import com.atlassian.connector.eclipse.internal.jira.core.service.FilterDefinitionConverter;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClient;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.util.JiraUtil;
import com.atlassian.connector.eclipse.internal.jira.ui.JiraUiPlugin;
import com.atlassian.connector.eclipse.internal.jira.ui.WdhmUtil;
import com.atlassian.connector.eclipse.internal.jira.ui.wizards.Messages;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.mylyn.commons.core.ICoreRunnable;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.commons.workbench.forms.DatePicker;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class JiraFilterDefinitionPage
extends AbstractRepositoryQueryPage {
    private static final String JIRA_STATUS_CLOSED = "6";
    private static final String JIRA_STATUS_RESOLVED = "5";
    private static final int DATE_CONTROL_WIDTH_HINT = 350;
    private static final String PAGE_NAME = "JiraSearchPage";
    private static final String SEARCH_URL_ID = "JiraSearchPage.SEARCHURL";
    private static final Project[] NO_PROJECTS = new Project[0];
    private static final int HEIGHT_HINT = 50;
    private static final int WIDTH_HINT = 150;
    final Placeholder ALL_PROJECTS = new Placeholder(Messages.JiraFilterDefinitionPage_All_Projects);
    final Placeholder ANY_ASSIGNEE = new Placeholder(Messages.JiraFilterDefinitionPage_Any);
    final Placeholder ANY_COMPONENT = new Placeholder(Messages.JiraFilterDefinitionPage_Any);
    final Placeholder ANY_FIX_VERSION = new Placeholder(Messages.JiraFilterDefinitionPage_Any);
    final Placeholder ANY_ISSUE_TYPE = new Placeholder(Messages.JiraFilterDefinitionPage_Any);
    final Placeholder ANY_PRIORITY = new Placeholder(Messages.JiraFilterDefinitionPage_Any);
    final Placeholder ANY_REPORTED_VERSION = new Placeholder(Messages.JiraFilterDefinitionPage_Any);
    final Placeholder ANY_REPORTER = new Placeholder(Messages.JiraFilterDefinitionPage_Any);
    final Placeholder ANY_RESOLUTION = new Placeholder(Messages.JiraFilterDefinitionPage_Any);
    final Placeholder ANY_STATUS = new Placeholder(Messages.JiraFilterDefinitionPage_Any);
    private Text assignee;
    private ComboViewer assigneeType;
    private final JiraClient client;
    private ListViewer components;
    private DatePicker createdEndDatePicker;
    private DatePicker createdStartDatePicker;
    final Placeholder CURRENT_USER_ASSIGNEE = new Placeholder(Messages.JiraFilterDefinitionPage_Current_User);
    final Placeholder CURRENT_USER_REPORTER = new Placeholder(Messages.JiraFilterDefinitionPage_Current_User);
    private DatePicker dueEndDatePicker;
    private DatePicker dueStartDatePicker;
    private boolean firstTime = true;
    private ListViewer fixFor;
    private ListViewer issueType;
    final Placeholder NO_COMPONENT = new Placeholder(Messages.JiraFilterDefinitionPage_No_Component);
    final Placeholder NO_FIX_VERSION = new Placeholder(Messages.JiraFilterDefinitionPage_No_Fix_Version);
    final Placeholder NO_PROJECT = new Placeholder(Messages.JiraFilterDefinitionPage_No_Project);
    final Placeholder NO_REPORTED_VERSION = new Placeholder(Messages.JiraFilterDefinitionPage_No_Version);
    final Placeholder NO_REPORTER = new Placeholder(Messages.JiraFilterDefinitionPage_No_Reporter);
    private ListViewer priority;
    private ListViewer project;
    private Text queryString;
    final Placeholder RELEASED_VERSION = new Placeholder(Messages.JiraFilterDefinitionPage_Released_Versions);
    private ListViewer reportedIn;
    private Text reporter;
    private ComboViewer reporterType;
    private ListViewer resolution;
    private Button searchComments;
    private Button searchDescription;
    private Button searchEnvironment;
    private Button searchSummary;
    final Placeholder SPECIFIC_GROUP_ASSIGNEE = new Placeholder(Messages.JiraFilterDefinitionPage_Specified_Group);
    final Placeholder SPECIFIC_GROUP_REPORTER = new Placeholder(Messages.JiraFilterDefinitionPage_Specified_Group);
    final Placeholder SPECIFIC_USER_ASSIGNEE = new Placeholder(Messages.JiraFilterDefinitionPage_Specified_User);
    final Placeholder SPECIFIC_USER_REPORTER = new Placeholder(Messages.JiraFilterDefinitionPage_Specified_User);
    private ListViewer status;
    private Text titleText;
    final Placeholder UNASSIGNED = new Placeholder(Messages.JiraFilterDefinitionPage_Unassigned);
    final Placeholder UNRELEASED_VERSION = new Placeholder(Messages.JiraFilterDefinitionPage_Unreleased_Versions);
    final Placeholder UNRESOLVED = new Placeholder(Messages.JiraFilterDefinitionPage_Unresolved);
    private DatePicker updatedEndDatePicker;
    private DatePicker updatedStartDatePicker;
    private FilterDefinition workingCopy;
    private Text createdFrom;
    private Text createdTo;
    private String title;
    private Text updatedFrom;
    private Text updatedTo;
    private Text dueDateFrom;
    private Text dueDateTo;
    private boolean isPageComplete = true;

    public JiraFilterDefinitionPage(TaskRepository repository) {
        this(repository, null);
    }

    public JiraFilterDefinitionPage(TaskRepository repository, IRepositoryQuery query) {
        super(Messages.JiraFilterDefinitionPage_JIRA_Query, repository, query);
        this.client = JiraClientFactory.getDefault().getJiraClient(repository);
        this.workingCopy = query != null ? (FilterDefinition)JiraUtil.getQuery((TaskRepository)repository, (JiraClient)this.client, (IRepositoryQuery)query, (boolean)false) : new FilterDefinition();
        this.setDescription(Messages.JiraFilterDefinitionPage_Add_search_filters_to_define_query);
        this.setPageComplete(false);
    }

    void applyChanges() {
        if (this.queryString.getText().length() > 0 || this.searchSummary.getSelection() || this.searchDescription.getSelection() || this.searchEnvironment.getSelection() || this.searchComments.getSelection()) {
            this.workingCopy.setContentFilter(new ContentFilter(this.queryString.getText(), this.searchSummary.getSelection(), this.searchDescription.getSelection(), this.searchEnvironment.getSelection(), this.searchComments.getSelection()));
        } else {
            this.workingCopy.setContentFilter(null);
        }
        IStructuredSelection projectSelection = (IStructuredSelection)this.project.getSelection();
        if (projectSelection.isEmpty()) {
            this.workingCopy.setProjectFilter(null);
        } else {
            boolean selectionContainsAll = false;
            boolean selectionContainsNone = false;
            ArrayList<Project> selectedProjects = new ArrayList<Project>();
            for (Object selection : projectSelection) {
                if (this.ALL_PROJECTS.equals(selection)) {
                    selectionContainsAll = true;
                    continue;
                }
                if (this.NO_PROJECT.equals(selection)) {
                    selectionContainsNone = true;
                    continue;
                }
                if (!(selection instanceof Project)) continue;
                selectedProjects.add((Project)selection);
            }
            if (selectionContainsAll) {
                this.workingCopy.setProjectFilter(null);
            } else if (selectedProjects.size() > 0) {
                this.workingCopy.setProjectFilter(new ProjectFilter(selectedProjects.toArray(new Project[selectedProjects.size()])));
            } else if (selectionContainsNone) {
                this.workingCopy.setProjectFilter(new ProjectFilter(new Project[0]));
            } else {
                this.workingCopy.setProjectFilter(null);
            }
        }
        IStructuredSelection reportedInSelection = (IStructuredSelection)this.reportedIn.getSelection();
        if (reportedInSelection.isEmpty()) {
            this.workingCopy.setReportedInVersionFilter(null);
        } else {
            boolean selectionContainsReleased = false;
            boolean selectionContainsUnreleased = false;
            boolean selectionContainsAll = false;
            boolean selectionContainsNone = false;
            ArrayList<Version> selectedVersions = new ArrayList<Version>();
            for (Object selection : reportedInSelection) {
                if (this.ANY_REPORTED_VERSION.equals(selection)) {
                    selectionContainsAll = true;
                    continue;
                }
                if (this.NO_REPORTED_VERSION.equals(selection)) {
                    selectionContainsNone = true;
                    continue;
                }
                if (this.RELEASED_VERSION.equals(selection)) {
                    selectionContainsReleased = true;
                    continue;
                }
                if (this.UNRELEASED_VERSION.equals(selection)) {
                    selectionContainsUnreleased = true;
                    continue;
                }
                if (!(selection instanceof Version)) continue;
                selectedVersions.add((Version)selection);
            }
            if (selectionContainsAll) {
                this.workingCopy.setReportedInVersionFilter(null);
            } else {
                this.workingCopy.setReportedInVersionFilter(new VersionFilter(selectedVersions.toArray(new Version[selectedVersions.size()]), selectionContainsNone, selectionContainsReleased, selectionContainsUnreleased));
            }
        }
        IStructuredSelection fixForSelection = (IStructuredSelection)this.fixFor.getSelection();
        if (fixForSelection.isEmpty()) {
            this.workingCopy.setFixForVersionFilter(null);
        } else {
            boolean selectionContainsReleased = false;
            boolean selectionContainsUnreleased = false;
            boolean selectionContainsAll = false;
            boolean selectionContainsNone = false;
            ArrayList<Version> selectedVersions = new ArrayList<Version>();
            for (Object selection : fixForSelection) {
                if (this.ANY_FIX_VERSION.equals(selection)) {
                    selectionContainsAll = true;
                    continue;
                }
                if (this.NO_FIX_VERSION.equals(selection)) {
                    selectionContainsNone = true;
                    continue;
                }
                if (this.RELEASED_VERSION.equals(selection)) {
                    selectionContainsReleased = true;
                    continue;
                }
                if (this.UNRELEASED_VERSION.equals(selection)) {
                    selectionContainsUnreleased = true;
                    continue;
                }
                if (!(selection instanceof Version)) continue;
                selectedVersions.add((Version)selection);
            }
            if (selectionContainsAll) {
                this.workingCopy.setFixForVersionFilter(null);
            } else {
                this.workingCopy.setFixForVersionFilter(new VersionFilter(selectedVersions.toArray(new Version[selectedVersions.size()]), selectionContainsNone, selectionContainsReleased, selectionContainsUnreleased));
            }
        }
        IStructuredSelection componentsSelection = (IStructuredSelection)this.components.getSelection();
        if (componentsSelection.isEmpty()) {
            this.workingCopy.setComponentFilter(null);
        } else {
            boolean selectionContainsAll = false;
            boolean selectionContainsNone = false;
            ArrayList<Component> selectedComponents = new ArrayList<Component>();
            for (Object selection : componentsSelection) {
                if (this.ANY_COMPONENT.equals(selection)) {
                    selectionContainsAll = true;
                    continue;
                }
                if (this.NO_COMPONENT.equals(selection)) {
                    selectionContainsNone = true;
                    continue;
                }
                if (!(selection instanceof Component)) continue;
                selectedComponents.add((Component)selection);
            }
            if (selectionContainsAll) {
                this.workingCopy.setComponentFilter(null);
            } else {
                this.workingCopy.setComponentFilter(new ComponentFilter(selectedComponents.toArray(new Component[selectedComponents.size()]), selectionContainsNone));
            }
        }
        IStructuredSelection issueTypeSelection = (IStructuredSelection)this.issueType.getSelection();
        if (issueTypeSelection.isEmpty()) {
            this.workingCopy.setIssueTypeFilter(null);
        } else {
            boolean isAnyIssueTypeSelected = false;
            ArrayList<IssueType> selectedIssueTypes = new ArrayList<IssueType>();
            for (Object selection : issueTypeSelection) {
                if (this.ANY_ISSUE_TYPE.equals(selection)) {
                    isAnyIssueTypeSelected = true;
                    continue;
                }
                if (!(selection instanceof IssueType)) continue;
                selectedIssueTypes.add((IssueType)selection);
            }
            if (isAnyIssueTypeSelected) {
                this.workingCopy.setIssueTypeFilter(null);
            } else {
                this.workingCopy.setIssueTypeFilter(new IssueTypeFilter(selectedIssueTypes.toArray(new IssueType[selectedIssueTypes.size()])));
            }
        }
        IStructuredSelection reporterSelection = (IStructuredSelection)this.reporterType.getSelection();
        if (reporterSelection.isEmpty()) {
            this.workingCopy.setReportedByFilter(null);
        } else if (this.ANY_REPORTER.equals(reporterSelection.getFirstElement())) {
            this.workingCopy.setReportedByFilter(null);
        } else if (this.NO_REPORTER.equals(reporterSelection.getFirstElement())) {
            this.workingCopy.setReportedByFilter((UserFilter)new NobodyFilter());
        } else if (this.CURRENT_USER_REPORTER.equals(reporterSelection.getFirstElement())) {
            this.workingCopy.setReportedByFilter((UserFilter)new CurrentUserFilter());
        } else if (this.SPECIFIC_GROUP_REPORTER.equals(reporterSelection.getFirstElement())) {
            this.workingCopy.setReportedByFilter((UserFilter)new UserInGroupFilter(this.reporter.getText()));
        } else if (this.SPECIFIC_USER_REPORTER.equals(reporterSelection.getFirstElement())) {
            this.workingCopy.setReportedByFilter((UserFilter)new SpecificUserFilter(this.reporter.getText()));
        } else {
            this.workingCopy.setReportedByFilter(null);
        }
        IStructuredSelection assigneeSelection = (IStructuredSelection)this.assigneeType.getSelection();
        if (assigneeSelection.isEmpty()) {
            this.workingCopy.setAssignedToFilter(null);
        } else if (this.ANY_ASSIGNEE.equals(assigneeSelection.getFirstElement())) {
            this.workingCopy.setAssignedToFilter(null);
        } else if (this.UNASSIGNED.equals(assigneeSelection.getFirstElement())) {
            this.workingCopy.setAssignedToFilter((UserFilter)new NobodyFilter());
        } else if (this.CURRENT_USER_ASSIGNEE.equals(assigneeSelection.getFirstElement())) {
            this.workingCopy.setAssignedToFilter((UserFilter)new CurrentUserFilter());
        } else if (this.SPECIFIC_GROUP_ASSIGNEE.equals(assigneeSelection.getFirstElement())) {
            this.workingCopy.setAssignedToFilter((UserFilter)new UserInGroupFilter(this.assignee.getText()));
        } else if (this.SPECIFIC_USER_ASSIGNEE.equals(assigneeSelection.getFirstElement())) {
            this.workingCopy.setAssignedToFilter((UserFilter)new SpecificUserFilter(this.assignee.getText()));
        } else {
            this.workingCopy.setAssignedToFilter(null);
        }
        IStructuredSelection statusSelection = (IStructuredSelection)this.status.getSelection();
        if (statusSelection.isEmpty()) {
            this.workingCopy.setStatusFilter(null);
        } else {
            boolean isAnyStatusSelected = false;
            ArrayList<JiraStatus> selectedStatuses = new ArrayList<JiraStatus>();
            for (Object selection : statusSelection) {
                if (this.ANY_STATUS.equals(selection)) {
                    isAnyStatusSelected = true;
                    continue;
                }
                if (!(selection instanceof JiraStatus)) continue;
                selectedStatuses.add((JiraStatus)selection);
            }
            if (isAnyStatusSelected) {
                this.workingCopy.setStatusFilter(null);
            } else {
                this.workingCopy.setStatusFilter(new StatusFilter(selectedStatuses.toArray(new JiraStatus[selectedStatuses.size()])));
            }
        }
        IStructuredSelection resolutionSelection = (IStructuredSelection)this.resolution.getSelection();
        if (resolutionSelection.isEmpty()) {
            this.workingCopy.setResolutionFilter(null);
        } else {
            boolean isAnyResolutionSelected = false;
            ArrayList<Resolution> selectedResolutions = new ArrayList<Resolution>();
            for (Object selection : resolutionSelection) {
                if (this.ANY_RESOLUTION.equals(selection)) {
                    isAnyResolutionSelected = true;
                    continue;
                }
                if (!(selection instanceof Resolution)) continue;
                selectedResolutions.add((Resolution)selection);
            }
            if (isAnyResolutionSelected) {
                this.workingCopy.setResolutionFilter(null);
            } else {
                this.workingCopy.setResolutionFilter(new ResolutionFilter(selectedResolutions.toArray(new Resolution[selectedResolutions.size()])));
            }
        }
        IStructuredSelection prioritySelection = (IStructuredSelection)this.priority.getSelection();
        if (prioritySelection.isEmpty()) {
            this.workingCopy.setPriorityFilter(null);
        } else {
            boolean isAnyPrioritiesSelected = false;
            ArrayList<Priority> selectedPriorities = new ArrayList<Priority>();
            for (Object selection : prioritySelection) {
                if (this.ANY_PRIORITY.equals(selection)) {
                    isAnyPrioritiesSelected = true;
                    continue;
                }
                if (!(selection instanceof Priority)) continue;
                selectedPriorities.add((Priority)selection);
            }
            if (isAnyPrioritiesSelected) {
                this.workingCopy.setPriorityFilter(null);
            } else {
                this.workingCopy.setPriorityFilter(new PriorityFilter(selectedPriorities.toArray(new Priority[selectedPriorities.size()])));
            }
        }
        this.workingCopy.setDueDateFilter((DateFilter)this.getRangeFilter(this.dueStartDatePicker, this.dueEndDatePicker, this.dueDateFrom, this.dueDateTo));
        this.workingCopy.setCreatedDateFilter((DateFilter)this.getRangeFilter(this.createdStartDatePicker, this.createdEndDatePicker, this.createdFrom, this.createdTo));
        this.workingCopy.setUpdatedDateFilter((DateFilter)this.getRangeFilter(this.updatedStartDatePicker, this.updatedEndDatePicker, this.updatedFrom, this.updatedTo));
    }

    public void applyTo(IRepositoryQuery query) {
        this.applyChanges();
        if (this.titleText != null) {
            query.setSummary(this.titleText.getText());
        }
        JiraUtil.setQuery((TaskRepository)this.getTaskRepository(), (IRepositoryQuery)query, (JiraFilter)this.workingCopy);
    }

    private void createComponentsViewer(Composite c) {
        this.components = new ListViewer(c, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 150;
        this.components.getControl().setLayoutData((Object)gridData);
        this.components.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Object[] currentElements;

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return this.currentElements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                Project[] projects = (Project[])newInput;
                if (projects == null || projects.length == 0 || projects.length > 1) {
                    this.currentElements = new Object[]{JiraFilterDefinitionPage.this.ANY_COMPONENT};
                } else {
                    LinkedHashSet<Placeholder> elements = new LinkedHashSet<Placeholder>();
                    elements.add(JiraFilterDefinitionPage.this.ANY_COMPONENT);
                    elements.add(JiraFilterDefinitionPage.this.NO_COMPONENT);
                    Project[] projectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Project project = projectArray[n2];
                        if (project != null && project.hasDetails()) {
                            elements.addAll(Arrays.asList(project.getComponents()));
                        }
                        ++n2;
                    }
                    this.currentElements = elements.toArray(new Object[elements.size()]);
                }
            }
        });
        this.components.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider());
        this.components.setInput((Object)NO_PROJECTS);
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        this.setControl((Control)c);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(c);
        if (!this.inSearchContainer()) {
            GridDataFactory.fillDefaults().hint(800, -1).minSize(800, -1).grab(true, true).applyTo((Control)c);
            Label lblName = new Label(c, 0);
            GridData gridData = new GridData();
            lblName.setLayoutData((Object)gridData);
            lblName.setText(Messages.JiraFilterDefinitionPage_Query_Title);
            this.titleText = new Text(c, 2048);
            this.titleText.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
            this.titleText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    JiraFilterDefinitionPage.this.setPageComplete(JiraFilterDefinitionPage.this.isPageComplete());
                }
            });
        } else {
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)c);
        }
        Composite cc = new Composite(c, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(650, 130).span(3, 1).applyTo((Control)cc);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(cc);
        Label label = new Label(cc, 0);
        label.setText(Messages.JiraFilterDefinitionPage_Project);
        Label typeLabel = new Label(cc, 0);
        typeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        typeLabel.setText(Messages.JiraFilterDefinitionPage_Type);
        this.createProjectsViewer(cc);
        this.createIssueTypesViewer(cc);
        this.createUpdateButton(c);
        ExpandableComposite textSection = this.createExpandableComposite(c, "Text Search", false);
        Composite textComposite = new Composite((Composite)textSection, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(0, 5).applyTo(textComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textComposite);
        textSection.setClient((Control)textComposite);
        this.createTextSearchContents(textComposite);
        textSection.setExpanded(this.inSearchContainer());
        ExpandableComposite issueDetailsSection = this.createExpandableComposite(c, "Issue Details", true);
        Composite detailsComposite = new Composite((Composite)issueDetailsSection, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(0, 5).applyTo(detailsComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)detailsComposite);
        issueDetailsSection.setClient((Control)detailsComposite);
        this.createIssueDetailsContents(detailsComposite);
        issueDetailsSection.setExpanded(!this.inSearchContainer());
        ExpandableComposite projectDetailsSection = this.createExpandableComposite(c, "Components / Versions", true);
        this.createProjectDetailsContents(projectDetailsSection);
        projectDetailsSection.setExpanded(!this.inSearchContainer());
        ExpandableComposite datesSection = this.createExpandableComposite(c, "Dates and Times", false);
        Composite datesComposite = new Composite((Composite)datesSection, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(0, 5).applyTo(datesComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)datesComposite);
        datesSection.setClient((Control)datesComposite);
        this.createDatesContent(datesComposite);
        this.loadDefaults();
        Dialog.applyDialogFont((Control)parent);
    }

    private void createProjectDetailsContents(ExpandableComposite projectDetailsComposite) {
        SashForm cc = new SashForm((Composite)projectDetailsComposite, 256);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).applyTo((Control)cc);
        Composite comp = new Composite((Composite)cc, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0).setText(Messages.JiraFilterDefinitionPage_Fix_For);
        this.createFixForViewer(comp);
        comp = new Composite((Composite)cc, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        new Label(comp, 0).setText(Messages.JiraFilterDefinitionPage_In_Components);
        this.createComponentsViewer(comp);
        comp = new Composite((Composite)cc, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        Label label = new Label(comp, 0);
        label.setText(Messages.JiraFilterDefinitionPage_Reported_In);
        this.createReportedInViewer(comp);
        cc.setWeights(new int[]{1, 1, 1});
        projectDetailsComposite.setClient((Control)cc);
    }

    private void createTextSearchContents(Composite c) {
        Label lblQuery = new Label(c, 0);
        GridData gd_lblQuery = new GridData();
        gd_lblQuery.verticalIndent = 7;
        lblQuery.setLayoutData((Object)gd_lblQuery);
        lblQuery.setText(Messages.JiraFilterDefinitionPage_Query);
        this.queryString = new Text(c, 2048);
        GridData gd_queryString = new GridData(4, 4, true, false, 2, 1);
        gd_queryString.verticalIndent = 7;
        this.queryString.setLayoutData((Object)gd_queryString);
        this.queryString.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        Label lblFields = new Label(c, 0);
        lblFields.setText(Messages.JiraFilterDefinitionPage_FILEDS);
        lblFields.setLayoutData((Object)new GridData());
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        };
        Composite comp = new Composite(c, 0);
        comp.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        comp.setLayout((Layout)new FillLayout());
        this.searchSummary = new Button(comp, 32);
        this.searchSummary.setText(Messages.JiraFilterDefinitionPage_Summary);
        this.searchSummary.addSelectionListener((SelectionListener)selectionAdapter);
        this.searchDescription = new Button(comp, 32);
        this.searchDescription.setText(Messages.JiraFilterDefinitionPage_Description);
        this.searchDescription.addSelectionListener((SelectionListener)selectionAdapter);
        this.searchComments = new Button(comp, 32);
        this.searchComments.setText(Messages.JiraFilterDefinitionPage_Comments);
        this.searchComments.addSelectionListener((SelectionListener)selectionAdapter);
        this.searchEnvironment = new Button(comp, 32);
        this.searchEnvironment.setText(Messages.JiraFilterDefinitionPage_Environment);
        this.searchEnvironment.addSelectionListener((SelectionListener)selectionAdapter);
    }

    private void createIssueDetailsContents(Composite c) {
        Label reportedByLabel = new Label(c, 0);
        reportedByLabel.setText(Messages.JiraFilterDefinitionPage_Reported_By);
        this.reporterType = new ComboViewer(c, 2056);
        GridData gridData_1 = new GridData(4, 0x1000000, false, false);
        gridData_1.widthHint = 133;
        this.reporterType.getControl().setLayoutData((Object)gridData_1);
        this.reporterType.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return new Object[]{JiraFilterDefinitionPage.this.ANY_REPORTER, JiraFilterDefinitionPage.this.NO_REPORTER, JiraFilterDefinitionPage.this.CURRENT_USER_REPORTER, JiraFilterDefinitionPage.this.SPECIFIC_USER_REPORTER, JiraFilterDefinitionPage.this.SPECIFIC_GROUP_REPORTER};
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.reporterType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Placeholder)element).getText();
            }
        });
        this.reporterType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (JiraFilterDefinitionPage.this.SPECIFIC_USER_REPORTER.equals(selection) || JiraFilterDefinitionPage.this.SPECIFIC_GROUP_REPORTER.equals(selection)) {
                    JiraFilterDefinitionPage.this.reporter.setEnabled(true);
                } else {
                    JiraFilterDefinitionPage.this.reporter.setEnabled(false);
                    JiraFilterDefinitionPage.this.reporter.setText("");
                }
            }
        });
        this.reporterType.setInput((Object)this.client);
        this.reporter = new Text(c, 2048);
        this.reporter.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.reporter.setEnabled(false);
        this.reporter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        Label assignedToLabel = new Label(c, 0);
        assignedToLabel.setText(Messages.JiraFilterDefinitionPage_Assigned_To);
        this.assigneeType = new ComboViewer(c, 2056);
        GridData gridData_2 = new GridData(4, 0x1000000, false, false);
        gridData_2.widthHint = 133;
        this.assigneeType.getCombo().setLayoutData((Object)gridData_2);
        this.assigneeType.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return new Object[]{JiraFilterDefinitionPage.this.ANY_ASSIGNEE, JiraFilterDefinitionPage.this.UNASSIGNED, JiraFilterDefinitionPage.this.CURRENT_USER_ASSIGNEE, JiraFilterDefinitionPage.this.SPECIFIC_USER_ASSIGNEE, JiraFilterDefinitionPage.this.SPECIFIC_GROUP_ASSIGNEE};
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.assigneeType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Placeholder)element).getText();
            }
        });
        this.assigneeType.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selection = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (JiraFilterDefinitionPage.this.SPECIFIC_USER_ASSIGNEE.equals(selection) || JiraFilterDefinitionPage.this.SPECIFIC_GROUP_ASSIGNEE.equals(selection)) {
                    JiraFilterDefinitionPage.this.assignee.setEnabled(true);
                } else {
                    JiraFilterDefinitionPage.this.assignee.setEnabled(false);
                    JiraFilterDefinitionPage.this.assignee.setText("");
                }
            }
        });
        this.assigneeType.setInput((Object)this.client);
        this.assignee = new Text(c, 2048);
        this.assignee.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.assignee.setEnabled(false);
        this.assignee.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        SashForm cc = new SashForm(c, 0);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).applyTo((Control)cc);
        Composite comp = new Composite((Composite)cc, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        Label statusLabel = new Label(comp, 0);
        statusLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        statusLabel.setText(Messages.JiraFilterDefinitionPage_Status);
        this.status = new ListViewer(comp, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 150;
        this.status.getList().setLayoutData((Object)gridData);
        this.status.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Placeholder) {
                    return ((Placeholder)element).getText();
                }
                return ((JiraStatus)element).getName();
            }
        });
        comp = new Composite((Composite)cc, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        Label resolutionLabel = new Label(comp, 0);
        resolutionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        resolutionLabel.setText(Messages.JiraFilterDefinitionPage_Resolution);
        this.resolution = new ListViewer(comp, 2818);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 150;
        this.resolution.getList().setLayoutData((Object)gridData);
        this.resolution.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Placeholder) {
                    return ((Placeholder)element).getText();
                }
                return ((Resolution)element).getName();
            }
        });
        comp = new Composite((Composite)cc, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comp.setLayout((Layout)gridLayout);
        Label priorityLabel = new Label(comp, 0);
        priorityLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        priorityLabel.setText(Messages.JiraFilterDefinitionPage_Priority);
        this.priority = new ListViewer(comp, 2818);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 150;
        this.priority.getList().setLayoutData((Object)gridData);
        this.priority.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Placeholder) {
                    return ((Placeholder)element).getText();
                }
                return ((Priority)element).getName();
            }
        });
        cc.setWeights(new int[]{1, 1, 1});
    }

    private void createDatesContent(Composite c) {
        ModifyListener wdhmLocalListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JiraFilterDefinitionPage.this.validatePage();
            }
        };
        DateFormat currentJiraDateTimeFormat = this.client.getLocalConfiguration().getDateTimeFormat();
        Label createdLabel = new Label(c, 0);
        createdLabel.setText(String.valueOf(Messages.JiraFilterDefinitionPage_Created) + ":");
        Composite composite = new Composite(c, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(16384, 128, false, false, 2, 2);
        layoutData.widthHint = 350;
        composite.setLayoutData((Object)layoutData);
        this.createdStartDatePicker = new DatePicker(composite, 2048, Messages.JiraFilterDefinitionPage__start_date_, true, 0);
        this.createdStartDatePicker.setDateFormat(currentJiraDateTimeFormat);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.createdStartDatePicker);
        this.createdEndDatePicker = new DatePicker(composite, 2048, Messages.JiraFilterDefinitionPage__end_date_, true, 0);
        this.createdEndDatePicker.setDateFormat(currentJiraDateTimeFormat);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.createdEndDatePicker);
        new Label(c, 0);
        Composite c1 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)c1);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c1.setLayout((Layout)gl);
        Label from = new Label(c1, 0);
        from.setText(String.valueOf(Messages.JiraFilterDefinitionPage_From) + ":");
        this.createdFrom = new Text(c1, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.createdFrom);
        this.createdFrom.addModifyListener(wdhmLocalListener);
        Composite c2 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)c2);
        GridLayout g2 = new GridLayout(2, false);
        g2.marginHeight = 0;
        g2.marginWidth = 0;
        c2.setLayout((Layout)g2);
        Label to = new Label(c2, 0);
        to.setText(String.valueOf(Messages.JiraFilterDefinitionPage_To) + ":");
        this.createdTo = new Text(c2, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.createdTo);
        this.createdTo.addModifyListener(wdhmLocalListener);
        Label updatedLabel = new Label(c, 0);
        updatedLabel.setText(String.valueOf(Messages.JiraFilterDefinitionPage_Updated) + ":");
        composite = new Composite(c, 0);
        layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        layoutData = new GridData(16384, 0x1000000, false, false, 2, 2);
        layoutData.widthHint = 350;
        composite.setLayoutData((Object)layoutData);
        this.updatedStartDatePicker = new DatePicker(composite, 2048, Messages.JiraFilterDefinitionPage__start_date_, true, 0);
        this.updatedStartDatePicker.setDateFormat(currentJiraDateTimeFormat);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.updatedStartDatePicker);
        this.updatedEndDatePicker = new DatePicker(composite, 2048, Messages.JiraFilterDefinitionPage__end_date_, true, 0);
        this.updatedEndDatePicker.setDateFormat(currentJiraDateTimeFormat);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.updatedEndDatePicker);
        new Label(c, 0);
        c1 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)c1);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c1.setLayout((Layout)gl);
        from = new Label(c1, 0);
        from.setText(String.valueOf(Messages.JiraFilterDefinitionPage_From) + ":");
        this.updatedFrom = new Text(c1, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.updatedFrom);
        this.updatedFrom.addModifyListener(wdhmLocalListener);
        c2 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)c2);
        g2 = new GridLayout(2, false);
        g2.marginHeight = 0;
        g2.marginWidth = 0;
        c2.setLayout((Layout)g2);
        to = new Label(c2, 0);
        to.setText(String.valueOf(Messages.JiraFilterDefinitionPage_To) + ":");
        this.updatedTo = new Text(c2, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.updatedTo);
        this.updatedTo.addModifyListener(wdhmLocalListener);
        Label dueDateLabel = new Label(c, 0);
        dueDateLabel.setText(String.valueOf(Messages.JiraFilterDefinitionPage_Due_Date) + ":");
        composite = new Composite(c, 0);
        layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        layoutData = new GridData(16384, 0x1000000, false, false, 2, 2);
        layoutData.widthHint = 350;
        composite.setLayoutData((Object)layoutData);
        this.dueStartDatePicker = new DatePicker(composite, 2048, Messages.JiraFilterDefinitionPage__start_date_, false, 0);
        this.dueStartDatePicker.setDateFormat(currentJiraDateTimeFormat);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.dueStartDatePicker);
        this.dueEndDatePicker = new DatePicker(composite, 2048, Messages.JiraFilterDefinitionPage__end_date_, false, 0);
        this.dueEndDatePicker.setDateFormat(currentJiraDateTimeFormat);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.dueEndDatePicker);
        new Label(c, 0);
        c1 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)c1);
        gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        c1.setLayout((Layout)gl);
        from = new Label(c1, 0);
        from.setText(String.valueOf(Messages.JiraFilterDefinitionPage_From) + ":");
        this.dueDateFrom = new Text(c1, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.dueDateFrom);
        this.dueDateFrom.addModifyListener(wdhmLocalListener);
        c2 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)c2);
        g2 = new GridLayout(2, false);
        g2.marginHeight = 0;
        g2.marginWidth = 0;
        c2.setLayout((Layout)g2);
        to = new Label(c2, 0);
        to.setText(String.valueOf(Messages.JiraFilterDefinitionPage_To) + ":");
        this.dueDateTo = new Text(c2, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.dueDateTo);
        this.dueDateTo.addModifyListener(wdhmLocalListener);
        new Label(c, 0);
        Composite cc = new Composite(c, 0);
        GridLayout gl2 = new GridLayout();
        gl2.marginWidth = 0;
        gl2.marginHeight = 20;
        cc.setLayout((Layout)gl2);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)cc);
        Label explanation = new Label(cc, 0);
        explanation.setText(NLS.bind((String)Messages.JiraWdhmExplanation, (Object)("'" + Messages.JiraFilterDefinitionPage_From + "' " + Messages.JiraFilterDefinitionPage_And + " '" + Messages.JiraFilterDefinitionPage_To + "'")));
    }

    private void adjustLayoutData(Control control, boolean shouldGrabVertical) {
        GridDataFactory.fillDefaults().indent(0, 5).grab(true, shouldGrabVertical).span(3, -1).applyTo(control);
    }

    private ExpandableComposite createExpandableComposite(final Composite parentControl, String title, final boolean shouldGrabVertical) {
        final ExpandableComposite section = new ExpandableComposite(parentControl, 50){

            public void setExpanded(boolean expanded) {
                JiraFilterDefinitionPage.this.adjustLayoutData((Control)this, expanded && shouldGrabVertical);
                super.setExpanded(expanded);
            }
        };
        section.clientVerticalSpacing = 0;
        section.setBackground(parentControl.getBackground());
        section.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (shouldGrabVertical) {
                    JiraFilterDefinitionPage.this.adjustLayoutData((Control)section, e.getState());
                }
                parentControl.layout(true);
                JiraFilterDefinitionPage.this.getControl().getShell().pack();
            }
        });
        section.setText(title);
        this.adjustLayoutData((Control)section, false);
        return section;
    }

    private void createIssueTypesViewer(Composite comp) {
        this.issueType = new ListViewer(comp, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 150;
        this.issueType.getList().setLayoutData((Object)gridData);
        this.issueType.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Object[] currentElements;

            public Object[] getElements(Object inputElement) {
                return this.currentElements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                Project[] projects = (Project[])newInput;
                IssueType[] types = null;
                if (projects == null || projects.length == 0 || projects.length > 1) {
                    types = JiraFilterDefinitionPage.this.client.getCache().getIssueTypes();
                } else if (projects[0].hasDetails()) {
                    types = projects[0].getIssueTypes();
                }
                if (types != null) {
                    Object[] elements = new Object[types.length + 1];
                    System.arraycopy(types, 0, elements, 1, types.length);
                    elements[0] = JiraFilterDefinitionPage.this.ANY_ISSUE_TYPE;
                    this.currentElements = elements;
                }
            }

            public void dispose() {
            }
        });
        this.issueType.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Placeholder) {
                    return ((Placeholder)element).getText();
                }
                return ((IssueType)element).getName();
            }
        });
        this.issueType.setInput((Object)NO_PROJECTS);
    }

    private void createFixForViewer(Composite c) {
        this.fixFor = new ListViewer(c, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 150;
        this.fixFor.getControl().setLayoutData((Object)gridData);
        this.fixFor.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Object[] currentElements;

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return this.currentElements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                Project[] projects = (Project[])newInput;
                if (projects == null || projects.length == 0 || projects.length > 1) {
                    this.currentElements = new Object[]{JiraFilterDefinitionPage.this.ANY_FIX_VERSION};
                } else {
                    ArrayList<Placeholder> elements = new ArrayList<Placeholder>();
                    elements.add(JiraFilterDefinitionPage.this.ANY_FIX_VERSION);
                    elements.add(JiraFilterDefinitionPage.this.NO_FIX_VERSION);
                    LinkedHashSet<Version> releasedVersions = new LinkedHashSet<Version>();
                    LinkedHashSet<Version> unreleasedVersions = new LinkedHashSet<Version>();
                    Project[] projectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Project project = projectArray[n2];
                        if (project != null && project.hasDetails()) {
                            releasedVersions.addAll(Arrays.asList(project.getReleasedVersions(false)));
                            unreleasedVersions.addAll(Arrays.asList(project.getUnreleasedVersions(false)));
                        }
                        ++n2;
                    }
                    elements.add(JiraFilterDefinitionPage.this.RELEASED_VERSION);
                    elements.addAll(releasedVersions);
                    elements.add(JiraFilterDefinitionPage.this.UNRELEASED_VERSION);
                    elements.addAll(unreleasedVersions);
                    this.currentElements = elements.toArray(new Object[elements.size()]);
                }
            }
        });
        this.fixFor.setLabelProvider((IBaseLabelProvider)new VersionLabelProvider());
        this.fixFor.setInput((Object)NO_PROJECTS);
    }

    private void createProjectsViewer(Composite c) {
        this.project = new ListViewer(c, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 150;
        this.project.getControl().setLayoutData((Object)gridData);
        this.project.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Placeholder) {
                    return ((Placeholder)element).getText();
                }
                return ((Project)element).getName();
            }
        });
        this.project.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ArrayList<Project> selectedProjects = new ArrayList<Project>();
                if (!selection.isEmpty()) {
                    for (Object sel : selection) {
                        if (sel instanceof Placeholder) continue;
                        selectedProjects.add((Project)sel);
                    }
                }
                JiraFilterDefinitionPage.this.updateCurrentProjects(selectedProjects.toArray(new Project[selectedProjects.size()]));
            }
        });
    }

    private void createReportedInViewer(Composite c) {
        this.reportedIn = new ListViewer(c, 2818);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 150;
        this.reportedIn.getControl().setLayoutData((Object)gridData);
        this.reportedIn.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private Object[] currentElements;

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return this.currentElements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                Project[] projects = (Project[])newInput;
                if (projects == null || projects.length == 0 || projects.length > 1) {
                    this.currentElements = new Object[]{JiraFilterDefinitionPage.this.ANY_REPORTED_VERSION};
                } else {
                    ArrayList<Placeholder> elements = new ArrayList<Placeholder>();
                    elements.add(JiraFilterDefinitionPage.this.ANY_REPORTED_VERSION);
                    elements.add(JiraFilterDefinitionPage.this.NO_REPORTED_VERSION);
                    LinkedHashSet<Version> releasedVersions = new LinkedHashSet<Version>();
                    LinkedHashSet<Version> unreleasedVersions = new LinkedHashSet<Version>();
                    Project[] projectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Project project = projectArray[n2];
                        if (project != null && project.hasDetails()) {
                            releasedVersions.addAll(Arrays.asList(project.getReleasedVersions(false)));
                            unreleasedVersions.addAll(Arrays.asList(project.getUnreleasedVersions(false)));
                        }
                        ++n2;
                    }
                    elements.add(JiraFilterDefinitionPage.this.RELEASED_VERSION);
                    elements.addAll(releasedVersions);
                    elements.add(JiraFilterDefinitionPage.this.UNRELEASED_VERSION);
                    elements.addAll(unreleasedVersions);
                    this.currentElements = elements.toArray(new Object[elements.size()]);
                }
            }
        });
        this.reportedIn.setLabelProvider((IBaseLabelProvider)new VersionLabelProvider());
        this.reportedIn.setInput((Object)NO_PROJECTS);
    }

    protected void createUpdateButton(Composite control) {
        Button updateButton = new Button(control, 8);
        updateButton.setText(Messages.JiraFilterDefinitionPage_Update_Attributes_from_Repository);
        updateButton.setLayoutData((Object)new GridData(131072, 4, false, false, 3, 1));
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraFilterDefinitionPage.this.applyChanges();
                JiraFilterDefinitionPage.this.updateAttributesFromRepository(true);
                JiraFilterDefinitionPage.this.loadFromWorkingCopy();
            }
        });
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings settings = JiraUiPlugin.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = settings.getSection(PAGE_NAME);
        if (dialogSettings == null) {
            dialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return dialogSettings;
    }

    public String getQueryTitle() {
        return this.titleText != null ? this.titleText.getText() : "";
    }

    private DateRangeFilter getRangeFilter(DatePicker startDatePicker, DatePicker endDatePicker, Text fromField, Text toField) {
        Calendar startDate = startDatePicker.getDate();
        Calendar endDate = endDatePicker.getDate();
        return new DateRangeFilter(startDate == null ? null : startDate.getTime(), endDate == null ? null : endDate.getTime(), fromField.getText(), toField.getText());
    }

    private void initializeContentProviders() {
        this.project.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                JiraClient server = (JiraClient)inputElement;
                Object[] elements = new Object[server.getCache().getProjects().length + 1];
                elements[0] = JiraFilterDefinitionPage.this.ALL_PROJECTS;
                System.arraycopy(server.getCache().getProjects(), 0, elements, 1, server.getCache().getProjects().length);
                return elements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.project.setInput((Object)this.client);
        this.status.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                JiraClient server = (JiraClient)inputElement;
                Object[] elements = new Object[server.getCache().getStatuses().length + 1];
                elements[0] = JiraFilterDefinitionPage.this.ANY_STATUS;
                System.arraycopy(server.getCache().getStatuses(), 0, elements, 1, server.getCache().getStatuses().length);
                return elements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.status.setInput((Object)this.client);
        this.resolution.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                JiraClient server = (JiraClient)inputElement;
                Object[] elements = new Object[server.getCache().getResolutions().length + 2];
                elements[0] = JiraFilterDefinitionPage.this.ANY_RESOLUTION;
                elements[1] = JiraFilterDefinitionPage.this.UNRESOLVED;
                System.arraycopy(server.getCache().getResolutions(), 0, elements, 2, server.getCache().getResolutions().length);
                return elements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.resolution.setInput((Object)this.client);
        this.priority.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                JiraClient client = (JiraClient)inputElement;
                Object[] elements = new Object[client.getCache().getPriorities().length + 1];
                elements[0] = JiraFilterDefinitionPage.this.ANY_PRIORITY;
                System.arraycopy(client.getCache().getPriorities(), 0, elements, 1, client.getCache().getPriorities().length);
                return elements;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.priority.setInput((Object)this.client);
    }

    private void initializePage() {
        this.updateAttributesFromRepository(false);
        if (this.inSearchContainer()) {
            this.restoreWidgetValues();
        }
        if (this.titleText != null) {
            if (this.getQuery() != null) {
                this.titleText.setText(this.getQuery().getSummary());
            } else if (this.title != null) {
                this.titleText.setText(this.title);
            }
        }
        this.loadFromWorkingCopy();
    }

    private void loadDefaults() {
        this.searchSummary.setSelection(true);
        this.searchDescription.setSelection(true);
    }

    private void loadFromWorkingCopy() {
        DateRangeFilter range;
        ArrayList<Placeholder> versions;
        if (this.workingCopy.getProjectFilter() != null) {
            this.project.setSelection((ISelection)new StructuredSelection((Object[])this.workingCopy.getProjectFilter().getProjects()), true);
        } else {
            this.project.setSelection((ISelection)new StructuredSelection((Object)this.ALL_PROJECTS), true);
        }
        if (this.workingCopy.getFixForVersionFilter() != null) {
            versions = new ArrayList<Placeholder>();
            if (this.workingCopy.getFixForVersionFilter().hasNoVersion()) {
                versions.add(this.NO_FIX_VERSION);
            }
            if (this.workingCopy.getFixForVersionFilter().isReleasedVersions()) {
                versions.add(this.RELEASED_VERSION);
            }
            if (this.workingCopy.getFixForVersionFilter().isUnreleasedVersions()) {
                versions.add(this.UNRELEASED_VERSION);
            }
            if (this.workingCopy.getFixForVersionFilter().getVersions() != null) {
                versions.addAll(Arrays.asList(this.workingCopy.getFixForVersionFilter().getVersions()));
            }
            this.fixFor.setSelection((ISelection)new StructuredSelection(versions), true);
        } else {
            this.fixFor.setSelection((ISelection)new StructuredSelection((Object)this.ANY_FIX_VERSION), true);
        }
        if (this.workingCopy.getReportedInVersionFilter() != null) {
            versions = new ArrayList();
            if (this.workingCopy.getReportedInVersionFilter().hasNoVersion()) {
                versions.add(this.NO_REPORTED_VERSION);
            }
            if (this.workingCopy.getReportedInVersionFilter().isReleasedVersions()) {
                versions.add(this.RELEASED_VERSION);
            }
            if (this.workingCopy.getReportedInVersionFilter().isUnreleasedVersions()) {
                versions.add(this.UNRELEASED_VERSION);
            }
            if (this.workingCopy.getReportedInVersionFilter().getVersions() != null) {
                versions.addAll(Arrays.asList(this.workingCopy.getReportedInVersionFilter().getVersions()));
            }
            this.reportedIn.setSelection((ISelection)new StructuredSelection(versions), true);
        } else {
            this.reportedIn.setSelection((ISelection)new StructuredSelection((Object)this.ANY_REPORTED_VERSION), true);
        }
        if (this.workingCopy.getContentFilter() != null) {
            this.queryString.setText(this.workingCopy.getContentFilter().getQueryString());
            this.searchComments.setSelection(this.workingCopy.getContentFilter().isSearchingComments());
            this.searchDescription.setSelection(this.workingCopy.getContentFilter().isSearchingDescription());
            this.searchEnvironment.setSelection(this.workingCopy.getContentFilter().isSearchingEnvironment());
            this.searchSummary.setSelection(this.workingCopy.getContentFilter().isSearchingSummary());
        }
        if (this.workingCopy.getComponentFilter() != null) {
            ArrayList<Placeholder> components = new ArrayList<Placeholder>();
            if (this.workingCopy.getComponentFilter().hasNoComponent()) {
                components.add(this.NO_COMPONENT);
            }
            if (this.workingCopy.getComponentFilter().getComponents() != null) {
                components.addAll(Arrays.asList(this.workingCopy.getComponentFilter().getComponents()));
            }
            this.components.setSelection((ISelection)new StructuredSelection(components), true);
        } else {
            this.components.setSelection((ISelection)new StructuredSelection((Object)this.ANY_COMPONENT), true);
        }
        if (this.workingCopy.getIssueTypeFilter() != null) {
            this.issueType.setSelection((ISelection)new StructuredSelection((Object[])this.workingCopy.getIssueTypeFilter().getIsueTypes()), true);
        } else {
            this.issueType.setSelection((ISelection)new StructuredSelection((Object)this.ANY_ISSUE_TYPE), true);
        }
        if (this.workingCopy.getReportedByFilter() != null) {
            UserFilter reportedByFilter = this.workingCopy.getReportedByFilter();
            if (reportedByFilter instanceof NobodyFilter) {
                this.reporterType.setSelection((ISelection)new StructuredSelection((Object)this.NO_REPORTER));
            } else if (reportedByFilter instanceof CurrentUserFilter) {
                this.reporterType.setSelection((ISelection)new StructuredSelection((Object)this.CURRENT_USER_REPORTER));
            } else if (reportedByFilter instanceof SpecificUserFilter) {
                this.reporterType.setSelection((ISelection)new StructuredSelection((Object)this.SPECIFIC_USER_REPORTER));
                this.reporter.setText(((SpecificUserFilter)reportedByFilter).getUser());
            } else if (reportedByFilter instanceof UserInGroupFilter) {
                this.reporterType.setSelection((ISelection)new StructuredSelection((Object)this.SPECIFIC_GROUP_REPORTER));
                this.reporter.setText(((UserInGroupFilter)reportedByFilter).getGroup());
            }
        } else {
            this.reporterType.setSelection((ISelection)new StructuredSelection((Object)this.ANY_REPORTER));
        }
        if (this.workingCopy.getAssignedToFilter() != null) {
            UserFilter assignedToFilter = this.workingCopy.getAssignedToFilter();
            if (assignedToFilter instanceof NobodyFilter) {
                this.assigneeType.setSelection((ISelection)new StructuredSelection((Object)this.UNASSIGNED));
            } else if (assignedToFilter instanceof CurrentUserFilter) {
                this.assigneeType.setSelection((ISelection)new StructuredSelection((Object)this.CURRENT_USER_ASSIGNEE));
            } else if (assignedToFilter instanceof SpecificUserFilter) {
                this.assigneeType.setSelection((ISelection)new StructuredSelection((Object)this.SPECIFIC_USER_ASSIGNEE));
                this.assignee.setText(((SpecificUserFilter)assignedToFilter).getUser());
            } else if (assignedToFilter instanceof UserInGroupFilter) {
                this.assigneeType.setSelection((ISelection)new StructuredSelection((Object)this.SPECIFIC_GROUP_ASSIGNEE));
                this.assignee.setText(((UserInGroupFilter)assignedToFilter).getGroup());
            }
        } else {
            this.assigneeType.setSelection((ISelection)new StructuredSelection((Object)this.ANY_ASSIGNEE));
        }
        if (this.workingCopy.getStatusFilter() != null) {
            this.status.setSelection((ISelection)new StructuredSelection((Object[])this.workingCopy.getStatusFilter().getStatuses()), true);
        } else {
            this.status.setSelection((ISelection)new StructuredSelection((Object)this.ANY_STATUS), true);
        }
        if (this.workingCopy.getResolutionFilter() != null) {
            Object[] resolutions = this.workingCopy.getResolutionFilter().getResolutions();
            if (resolutions.length == 0) {
                this.resolution.setSelection((ISelection)new StructuredSelection((Object)this.UNRESOLVED), true);
            } else {
                this.resolution.setSelection((ISelection)new StructuredSelection(resolutions), true);
            }
        } else {
            this.resolution.setSelection((ISelection)new StructuredSelection((Object)this.ANY_RESOLUTION), true);
        }
        if (this.workingCopy.getPriorityFilter() != null) {
            this.priority.setSelection((ISelection)new StructuredSelection((Object[])this.workingCopy.getPriorityFilter().getPriorities()), true);
        } else {
            this.priority.setSelection((ISelection)new StructuredSelection((Object)this.ANY_PRIORITY), true);
        }
        this.setDateRange(this.workingCopy.getCreatedDateFilter(), this.createdStartDatePicker, this.createdEndDatePicker);
        if (this.workingCopy.getCreatedDateFilter() != null && this.workingCopy.getCreatedDateFilter() instanceof DateRangeFilter) {
            range = (DateRangeFilter)this.workingCopy.getCreatedDateFilter();
            this.createdFrom.setText(range.getFrom() == null ? "" : range.getFrom());
            this.createdTo.setText(range.getTo() == null ? "" : range.getTo());
        } else {
            this.createdFrom.setText("");
            this.createdTo.setText("");
        }
        this.setDateRange(this.workingCopy.getUpdatedDateFilter(), this.updatedStartDatePicker, this.updatedEndDatePicker);
        if (this.workingCopy.getUpdatedDateFilter() != null && this.workingCopy.getUpdatedDateFilter() instanceof DateRangeFilter) {
            range = (DateRangeFilter)this.workingCopy.getUpdatedDateFilter();
            this.updatedFrom.setText(range.getFrom() == null ? "" : range.getFrom());
            this.updatedTo.setText(range.getTo() == null ? "" : range.getTo());
        } else {
            this.updatedFrom.setText("");
            this.updatedTo.setText("");
        }
        this.setDateRange(this.workingCopy.getDueDateFilter(), this.dueStartDatePicker, this.dueEndDatePicker);
        if (this.workingCopy.getDueDateFilter() != null && this.workingCopy.getDueDateFilter() instanceof DateRangeFilter) {
            range = (DateRangeFilter)this.workingCopy.getDueDateFilter();
            this.dueDateFrom.setText(range.getFrom() == null ? "" : range.getFrom());
            this.dueDateTo.setText(range.getTo() == null ? "" : range.getTo());
        } else {
            this.dueDateFrom.setText("");
            this.dueDateTo.setText("");
        }
    }

    public boolean performSearch() {
        if (this.inSearchContainer()) {
            this.saveState();
        }
        return super.performSearch();
    }

    private boolean restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        String searchUrl = settings.get("JiraSearchPage.SEARCHURL." + this.getTaskRepository().getRepositoryUrl());
        if (searchUrl == null) {
            return false;
        }
        FilterDefinitionConverter converter = new FilterDefinitionConverter(this.getTaskRepository().getCharacterEncoding(), this.client.getLocalConfiguration().getDateTimeFormat());
        this.workingCopy = converter.toFilter(this.client, searchUrl, false);
        return true;
    }

    public void saveState() {
        String repoId = "." + this.getTaskRepository().getRepositoryUrl();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SEARCH_URL_ID + repoId, this.createQuery().getUrl());
    }

    private void setDateRange(DateFilter dateFilter, DatePicker startDatePicker, DatePicker endDatePicker) {
        if (dateFilter instanceof DateRangeFilter) {
            DateRangeFilter rangeFilter = (DateRangeFilter)dateFilter;
            if (rangeFilter.getFromDate() != null) {
                Calendar c1 = Calendar.getInstance();
                c1.setTime(rangeFilter.getFromDate());
                startDatePicker.setDate(c1);
            } else {
                startDatePicker.setDate(null);
            }
            if (rangeFilter.getToDate() != null) {
                Calendar c2 = Calendar.getInstance();
                c2.setTime(rangeFilter.getToDate());
                endDatePicker.setDate(c2);
            } else {
                endDatePicker.setDate(null);
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getSearchContainer() != null) {
            this.getSearchContainer().setPerformActionEnabled(true);
        }
        if (visible && this.firstTime) {
            this.firstTime = false;
            if (!this.client.getCache().hasDetails()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (JiraFilterDefinitionPage.this.getControl() != null && !JiraFilterDefinitionPage.this.getControl().isDisposed()) {
                            JiraFilterDefinitionPage.this.initializePage();
                        }
                    }
                });
            } else {
                this.initializePage();
            }
        }
    }

    private void updateAttributesFromRepository(boolean force) {
        if (!this.client.getCache().hasDetails() || force) {
            Project[] projects = new Project[]{};
            IStructuredSelection selection = (IStructuredSelection)this.project.getSelection();
            if (selection.getFirstElement() instanceof Project) {
                projects = new Project[]{(Project)selection.getFirstElement()};
            }
            this.internalUpdate(true, projects);
        }
        this.initializeContentProviders();
    }

    private void internalUpdate(final boolean updateProjectList, final Project[] projects) {
        ICoreRunnable runnable = new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int size = projects.length;
                if (updateProjectList) {
                    ++size;
                }
                SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.JiraFilterDefinitionPage_Update_Attributes_from_Repository, (int)size);
                try {
                    JiraClient client = JiraClientFactory.getDefault().getJiraClient(JiraFilterDefinitionPage.this.getTaskRepository());
                    if (updateProjectList) {
                        client.getCache().refreshDetails((IProgressMonitor)submonitor.newChild(1, 0));
                    }
                    Project[] projectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Project project = projectArray[n2];
                        client.getCache().refreshProjectDetails(project.getId(), (IProgressMonitor)submonitor.newChild(1, 0));
                        ++n2;
                    }
                }
                catch (JiraException e) {
                    throw new CoreException(JiraCorePlugin.toStatus((TaskRepository)JiraFilterDefinitionPage.this.getTaskRepository(), (Throwable)e));
                }
            }
        };
        IWizardContainer context = this.getContainer();
        if (context == null) {
            context = this.getSearchContainer().getRunnableContext();
        }
        if (context == null) {
            context = PlatformUI.getWorkbench().getProgressService();
        }
        try {
            CommonUiUtil.run((IRunnableContext)context, (ICoreRunnable)runnable);
        }
        catch (CoreException e) {
            this.setErrorMessage(NLS.bind((String)Messages.JiraFilterDefinitionPage_Error_updating_attributes_X, (Object)e.getMessage()));
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    void updateCurrentProjects(Project[] projects) {
        ArrayList<Project> staleProjects = null;
        Project[] projectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            Project project = projectArray[n2];
            if (!project.hasDetails()) {
                if (staleProjects == null) {
                    staleProjects = new ArrayList<Project>();
                }
                staleProjects.add(project);
            }
            ++n2;
        }
        if (staleProjects != null) {
            this.internalUpdate(false, staleProjects.toArray(new Project[0]));
        }
        this.fixFor.setInput((Object)projects);
        this.components.setInput((Object)projects);
        this.reportedIn.setInput((Object)projects);
        this.issueType.setInput((Object)projects);
    }

    private void setQueryName(String queryName) {
        if (this.titleText == null) {
            this.title = queryName;
        } else {
            this.titleText.setText(queryName);
        }
    }

    public void setCreatedRecently() {
        this.workingCopy = new FilterDefinition();
        this.setQueryName(Messages.JiraNamedFilterPage_Predefined_filter_added_recently);
        this.workingCopy.setCreatedDateFilter((DateFilter)new DateRangeFilter(null, null, "-1w", ""));
        if (!this.firstTime) {
            this.loadFromWorkingCopy();
        }
    }

    public void setUpdatedRecently() {
        this.workingCopy = new FilterDefinition();
        this.setQueryName(Messages.JiraNamedFilterPage_Predefined_filter_updated_recently);
        this.workingCopy.setUpdatedDateFilter((DateFilter)new DateRangeFilter(null, null, "-1w", ""));
        if (!this.firstTime) {
            this.loadFromWorkingCopy();
        }
    }

    public void setResolvedRecently() {
        this.workingCopy = new FilterDefinition();
        this.setQueryName(Messages.JiraNamedFilterPage_Predefined_filter_resolved_recently);
        this.workingCopy.setUpdatedDateFilter((DateFilter)new DateRangeFilter(null, null, "-1w", ""));
        ArrayList<JiraStatus> statuses = new ArrayList<JiraStatus>();
        JiraStatus[] jiraStatusArray = this.client.getCache().getStatuses();
        int n = jiraStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            JiraStatus status = jiraStatusArray[n2];
            if (status.getId().equals(JIRA_STATUS_RESOLVED) || status.getId().equals(JIRA_STATUS_CLOSED)) {
                statuses.add(status);
            }
            ++n2;
        }
        this.workingCopy.setStatusFilter(new StatusFilter(statuses.toArray(new JiraStatus[statuses.size()])));
        if (!this.firstTime) {
            this.loadFromWorkingCopy();
        }
    }

    public void setAssignedToMe() {
        this.workingCopy = new FilterDefinition();
        this.setQueryName(Messages.JiraNamedFilterPage_Predefined_filter_assigned_to_me);
        this.workingCopy.setResolutionFilter(new ResolutionFilter(new Resolution[0]));
        this.workingCopy.setAssignedToFilter((UserFilter)new CurrentUserFilter());
        if (!this.firstTime) {
            this.loadFromWorkingCopy();
        }
    }

    public void setReportedByMe() {
        this.workingCopy = new FilterDefinition();
        this.setQueryName(Messages.JiraNamedFilterPage_Predefined_filter_reported_by_me);
        this.workingCopy.setReportedByFilter((UserFilter)new CurrentUserFilter());
        if (!this.firstTime) {
            this.loadFromWorkingCopy();
        }
    }

    public boolean isPageComplete() {
        return this.isPageComplete && super.isPageComplete();
    }

    private void validatePage() {
        if (!super.isPageComplete()) {
            return;
        }
        this.setErrorMessage(null);
        this.isPageComplete = true;
        if (!WdhmUtil.isValid(this.createdFrom.getText()) || !WdhmUtil.isValid(this.createdTo.getText())) {
            this.isPageComplete = false;
            this.setErrorMessage(String.valueOf(Messages.JiraIncorrectWdhmValue) + Messages.JiraFilterDefinitionPage_Created);
        } else if (!WdhmUtil.isValid(this.updatedFrom.getText()) || !WdhmUtil.isValid(this.updatedTo.getText())) {
            this.isPageComplete = false;
            this.setErrorMessage(String.valueOf(Messages.JiraIncorrectWdhmValue) + Messages.JiraFilterDefinitionPage_Updated);
        } else if (!WdhmUtil.isValid(this.dueDateFrom.getText()) || !WdhmUtil.isValid(this.dueDateTo.getText())) {
            this.isPageComplete = false;
            this.setErrorMessage(String.valueOf(Messages.JiraIncorrectWdhmValue) + Messages.JiraFilterDefinitionPage_Due_Date);
        }
        this.setPageComplete(this.isPageComplete);
    }

    static final class ComponentLabelProvider
    implements ILabelProvider {
        ComponentLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Placeholder) {
                return ((Placeholder)element).getText();
            }
            return ((Component)element).getName();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class Placeholder {
        private final String text;

        public Placeholder(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    static final class VersionLabelProvider
    implements ILabelProvider,
    IColorProvider {
        VersionLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Color getBackground(Object element) {
            if (element instanceof Placeholder) {
                return Display.getCurrent().getSystemColor(29);
            }
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Placeholder) {
                return ((Placeholder)element).getText();
            }
            return ((Version)element).getName();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

