/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.ui.editor;

import com.atlassian.connector.eclipse.internal.jira.core.JiraAttribute;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorSummaryPart;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JiraTaskEditorSummaryPart
extends TaskEditorSummaryPart {
    protected Composite createHeaderLayout(Composite parent, FormToolkit toolkit) {
        Layout layout;
        Composite composite = super.createHeaderLayout(parent, toolkit);
        TaskAttribute attribute = this.getTaskData().getRoot().getMappedAttribute(JiraAttribute.VOTES.id());
        if (attribute != null) {
            this.addAttribute(composite, toolkit, attribute, true);
            layout = composite.getLayout();
            if (layout instanceof GridLayout) {
                GridLayout gl = (GridLayout)layout;
                gl.numColumns = composite.getChildren().length;
                if (gl.numColumns == 0) {
                    gl.numColumns = 1;
                    toolkit.createLabel(composite, " ");
                }
            }
        }
        if ((layout = composite.getLayout()) instanceof GridLayout) {
            TaskAttribute assigneeAttribute;
            GridLayout gLayout = (GridLayout)layout;
            Composite secondLineComposite = new Composite(composite, 0);
            RowLayout rowLayout = new RowLayout();
            rowLayout.center = true;
            rowLayout.marginLeft = 0;
            secondLineComposite.setLayout((Layout)rowLayout);
            rowLayout.spacing = 8;
            GridDataFactory.fillDefaults().span(gLayout.numColumns, 1).applyTo((Control)secondLineComposite);
            toolkit.adapt(secondLineComposite);
            TaskAttribute reporterAttribute = this.getTaskData().getRoot().getMappedAttribute(JiraAttribute.USER_REPORTER.id());
            if (reporterAttribute != null) {
                this.addAttribute(secondLineComposite, toolkit, reporterAttribute, false);
            }
            if ((assigneeAttribute = this.getTaskData().getRoot().getMappedAttribute(JiraAttribute.USER_ASSIGNED.id())) != null) {
                this.addAttribute(secondLineComposite, toolkit, assigneeAttribute, false);
            }
        }
        return composite;
    }

    private void addAttribute(Composite composite, FormToolkit toolkit, TaskAttribute attribute, boolean shouldInitializeGridData) {
        AbstractAttributeEditor editor = this.createAttributeEditor(attribute);
        if (editor != null) {
            editor.setReadOnly(true);
            editor.setDecorationEnabled(false);
            editor.createLabelControl(composite, toolkit);
            if (shouldInitializeGridData) {
                GridDataFactory.defaultsFor((Control)editor.getLabelControl()).indent(6, 0).applyTo((Control)editor.getLabelControl());
            }
            editor.createControl(composite, toolkit);
            this.getTaskEditorPage().getAttributeEditorToolkit().adapt(editor);
        }
    }
}

