/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.policies;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.TreeContainerEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IActionState;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IInputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IOutputMapper;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.CreateActionCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.CreateAttributeMapperCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.CreateIfCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.CreatePropertyCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteActionCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteActionPropertyCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteAttributeMapperCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteIfCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.DeleteStatePropertyCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.ReorderIfCommand;
import org.springframework.ide.eclipse.webflow.ui.graph.commands.ReorderStateCommand;

public class StateTreeContainerEditPolicy
extends TreeContainerEditPolicy {
    protected Command createCreateActionCommand(IActionElement child, int index) {
        CreateActionCommand cmd = new CreateActionCommand();
        cmd.setParent((IState)((IActionState)this.getHost().getModel()));
        cmd.setChild(child);
        cmd.setMove(true);
        if (index >= 0) {
            cmd.setIndex(index);
        }
        return cmd;
    }

    protected Command createCreateAttributeMapperCommand(IAttributeMapper child, int index) {
        CreateAttributeMapperCommand cmd = new CreateAttributeMapperCommand();
        cmd.setParent((ISubflowState)this.getHost().getModel());
        return cmd;
    }

    protected Command createCreateIfCommand(IIf child, int index) {
        CreateIfCommand cmd = new CreateIfCommand();
        cmd.setParent((IDecisionState)this.getHost().getModel());
        cmd.setChild(child);
        cmd.setMove(true);
        if (index >= 0) {
            cmd.setIndex(index);
        }
        return cmd;
    }

    protected Command createCreatePropertyCommand(IAttribute child, int index) {
        CreatePropertyCommand cmd = new CreatePropertyCommand();
        cmd.setParent((IWebflowModelElement)this.getHost().getModel());
        cmd.setChild(child);
        if (index >= 0) {
            cmd.setIndex(index);
        }
        return cmd;
    }

    protected Command createDeleteActionCommand(IActionElement child) {
        DeleteActionCommand cmd = new DeleteActionCommand();
        cmd.setChild(child);
        return cmd;
    }

    protected Command createDeleteAttributeMapperCommand(IAttributeMapper child) {
        DeleteAttributeMapperCommand cmd = new DeleteAttributeMapperCommand();
        cmd.setParent((ISubflowState)child.getElementParent());
        cmd.setChild(child);
        return cmd;
    }

    protected Command createDeleteIfCommand(IIf child) {
        DeleteIfCommand cmd = new DeleteIfCommand();
        cmd.setParent((IDecisionState)child.getElementParent());
        cmd.setChild(child);
        return cmd;
    }

    protected Command createDeletePropertyCommand(IAttribute child) {
        if (child.getElementParent() instanceof IState) {
            DeleteStatePropertyCommand cmd = new DeleteStatePropertyCommand();
            cmd.setParent((IAttributeEnabled)((IState)child.getElementParent()));
            cmd.setChild(child);
            return cmd;
        }
        if (child.getElementParent() instanceof IActionElement) {
            DeleteActionPropertyCommand cmd = new DeleteActionPropertyCommand();
            cmd.setParent((IActionElement)child.getElementParent());
            cmd.setChild(child);
            return cmd;
        }
        return null;
    }

    protected Command getAddCommand(ChangeBoundsRequest request) {
        CompoundCommand command = new CompoundCommand();
        List editparts = request.getEditParts();
        int index = this.findIndexOfTreeItemAt(request.getLocation());
        int i = 0;
        while (i < editparts.size()) {
            IActionElement childModel;
            EditPart child = (EditPart)editparts.get(i);
            if (this.isAncestor(child, this.getHost())) {
                command.add((Command)UnexecutableCommand.INSTANCE);
            } else if (child.getModel() instanceof IActionElement && this.getHost().getModel() instanceof IActionState) {
                childModel = (IActionElement)child.getModel();
                command.add(this.createDeleteActionCommand(childModel));
                command.add(this.createCreateActionCommand(childModel, index));
            } else if (child.getModel() instanceof IAttributeMapper && this.getHost().getModel() instanceof ISubflowState) {
                childModel = (IAttributeMapper)child.getModel();
                command.add(this.createDeleteAttributeMapperCommand((IAttributeMapper)childModel));
                command.add(this.createCreateAttributeMapperCommand((IAttributeMapper)childModel, index));
            } else if (child.getModel() instanceof IAttribute && (this.getHost().getModel() instanceof IActionElement || this.getHost().getModel() instanceof IState)) {
                childModel = (IAttribute)child.getModel();
                command.add(this.createDeletePropertyCommand((IAttribute)childModel));
                command.add(this.createCreatePropertyCommand((IAttribute)childModel, index));
            } else if (child.getModel() instanceof IIf && this.getHost().getModel() instanceof IDecisionState) {
                childModel = (IIf)child.getModel();
                command.add(this.createDeleteIfCommand((IIf)childModel));
                command.add(this.createCreateIfCommand((IIf)childModel, index));
            } else if (child.getModel() instanceof IInputMapper || child.getModel() instanceof IOutputMapper) {
                boolean cfr_ignored_0 = this.getHost().getModel() instanceof IAttributeMapper;
            }
            ++i;
        }
        return command;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected Command getMoveChildrenCommand(ChangeBoundsRequest request) {
        CompoundCommand command = new CompoundCommand();
        List editparts = request.getEditParts();
        List children = this.getHost().getChildren();
        int newIndex = this.findIndexOfTreeItemAt(request.getLocation());
        int i = 0;
        while (i < editparts.size()) {
            EditPart child = (EditPart)editparts.get(i);
            int tempIndex = newIndex;
            int oldIndex = children.indexOf(child);
            if (oldIndex == tempIndex || oldIndex + 1 == tempIndex) {
                command.add((Command)UnexecutableCommand.INSTANCE);
                return command;
            }
            if (oldIndex < tempIndex) {
                --tempIndex;
            }
            if (child.getModel() instanceof IState && tempIndex >= 0) {
                command.add((Command)new ReorderStateCommand((IState)child.getModel(), (IWebflowState)this.getHost().getModel(), oldIndex, tempIndex));
            } else if (child.getModel() instanceof IIf && tempIndex >= 0) {
                command.add((Command)new ReorderIfCommand((IIf)child.getModel(), (IDecisionState)this.getHost().getModel(), oldIndex, tempIndex));
            }
            ++i;
        }
        return command;
    }

    protected boolean isAncestor(EditPart source, EditPart target) {
        if (source == target) {
            return true;
        }
        if (target.getParent() != null) {
            return this.isAncestor(source, target.getParent());
        }
        return false;
    }
}

