/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.parts;

import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.webflow.core.model.IActionElement;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IInlineFlowState;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.figures.CompoundStateFigure;
import org.springframework.ide.eclipse.webflow.ui.graph.figures.SubgraphFigure;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelDecorator;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelProvider;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.AbstractStatePart;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.GraphAnimation;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.StateTransitionPart;
import org.springframework.ide.eclipse.webflow.ui.graph.policies.FlowStateLayoutEditPolicy;
import org.springframework.ide.eclipse.webflow.ui.graph.policies.StateContainerEditPolicy;
import org.springframework.ide.eclipse.webflow.ui.graph.policies.StateContainerHighlightEditPolicy;
import org.springframework.ide.eclipse.webflow.ui.graph.policies.StateEditPolicy;
import org.springframework.ide.eclipse.webflow.ui.graph.policies.StateNodeEditPolicy;

public abstract class ChildrenStatePart
extends AbstractStatePart
implements NodeEditPart {
    protected static ILabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new WebflowModelLabelProvider(), (ILabelDecorator)new WebflowModelLabelDecorator());
    protected WebflowModelLabelProvider eLabelProvider = new WebflowModelLabelProvider();

    protected void applyChildrenResults(CompoundDirectedGraph graph, Map map) {
        int i = 0;
        while (i < this.getChildren().size()) {
            AbstractStatePart part = (AbstractStatePart)this.getChildren().get(i);
            part.applyGraphResults(graph, map);
            ++i;
        }
    }

    protected void applyMaxWidths() {
        AbstractStatePart part;
        int width = 0;
        int i = 0;
        while (i < this.getChildren().size()) {
            part = (AbstractStatePart)this.getChildren().get(i);
            if (part.getModel() instanceof IActionElement || part.getModel() instanceof IExceptionHandler || part.getModel() instanceof IAttributeMapper) {
                Rectangle rec = part.getFigure().getBounds();
                if (rec.width >= width) {
                    width = rec.width;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.getChildren().size()) {
            part = (AbstractStatePart)this.getChildren().get(i);
            if (part.getModel() instanceof IActionElement || part.getModel() instanceof IExceptionHandler || part.getModel() instanceof IAttributeMapper) {
                Rectangle rect = part.getFigure().getBounds();
                rect.width = width;
                part.getFigure().setBounds(rect);
            }
            ++i;
        }
    }

    protected void applyChildrenResultsToOwn(CompoundDirectedGraph graph, Map map) {
        Node n = (Node)map.get(this);
        int bottom = -1;
        int i = 0;
        while (i < this.getChildren().size()) {
            AbstractStatePart part = (AbstractStatePart)this.getChildren().get(i);
            if (part.getFigure().getBounds().bottom() > bottom) {
                bottom = part.getFigure().getBounds().getBottom().y;
            }
            ++i;
        }
        if (bottom > -1) {
            int top = this.getFigure().getBounds().getTop().y;
            int height = bottom - top + 7 + 7;
            this.getFigure().setBounds(new Rectangle(n.x, n.y, n.width, height));
        }
    }

    @Override
    protected void applyGraphResults(CompoundDirectedGraph graph, Map map) {
        this.applyOwnResults(graph, map);
        this.applyChildrenResults(graph, map);
        this.applyChildrenResultsToOwn(graph, map);
    }

    protected void applyOwnResults(CompoundDirectedGraph graph, Map map) {
        Node n = (Node)map.get(this);
        if (this.getModelChildren() != null && this.getModelChildren().size() > 0) {
            this.getFigure().setBounds(new Rectangle(n.x, n.y, n.width, n.height));
        } else {
            int height = ((CompoundStateFigure)this.getFigure()).getHeader().getPreferredSize().height;
            if (height < 20) {
                this.getFigure().setBounds(new Rectangle(n.x, n.y, n.width, 23));
            } else {
                this.getFigure().setBounds(new Rectangle(n.x, n.y, n.width, 33));
            }
        }
        int i = 0;
        while (i < this.getSourceConnections().size()) {
            StateTransitionPart trans = (StateTransitionPart)this.getSourceConnections().get(i);
            trans.applyGraphResults(graph, map);
            ++i;
        }
    }

    @Override
    public void contributeNodesToGraph(CompoundDirectedGraph graph, Subgraph s, Map map) {
        GraphAnimation.recordInitialState(this.getContentPane());
        Subgraph me = new Subgraph((Object)this, s);
        IState state = (IState)this.getModel();
        if (!(state instanceof IWebflowState)) {
            int index = -1;
            int stateCount = ((IWebflowState)state.getElementParent()).getStates().size();
            index = state instanceof IInlineFlowState ? ((IWebflowState)state.getElementParent()).getInlineFlowStates().indexOf(state) + stateCount : ((IWebflowState)state.getElementParent()).getStates().indexOf(state);
            me.setRowConstraint(index);
        }
        me.outgoingOffset = 5;
        me.incomingOffset = 5;
        IFigure fig = this.getFigure();
        if (fig instanceof SubgraphFigure) {
            me.width = fig.getPreferredSize((int)me.width, (int)me.height).width;
            me.height = fig.getPreferredSize().height;
            me.insets.top = ((CompoundStateFigure)this.getFigure()).getHeader().getPreferredSize().height + 5;
            me.insets.left = 5;
            me.insets.right = 5;
            me.insets.bottom = 15;
        }
        me.innerPadding = new Insets(0, 0, 0, 4);
        map.put(this, me);
        graph.nodes.add((Object)me);
        int i = 0;
        while (i < this.getChildren().size()) {
            AbstractStatePart activity = (AbstractStatePart)this.getChildren().get(i);
            activity.contributeNodesToGraph(graph, me, map);
            ++i;
        }
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new StateNodeEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new StateEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new StateContainerHighlightEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new StateContainerEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new FlowStateLayoutEditPolicy());
        this.installEditPolicy("DirectEditPolicy", null);
    }

    protected IFigure createFigure() {
        CompoundStateFigure figure = new CompoundStateFigure((IWebflowModelElement)this.getModel());
        ((Label)figure.getHeader()).setIcon(labelProvider.getImage(this.getModel()));
        ((Label)figure.getHeader()).setIconTextGap(5);
        ((Label)figure.getHeader()).setIconAlignment(8);
        return figure;
    }

    private boolean directEditHitTest(Point requestLoc) {
        return false;
    }

    public IFigure getContentPane() {
        if (this.getFigure() instanceof SubgraphFigure) {
            return ((SubgraphFigure)this.getFigure()).getContents();
        }
        return this.getFigure();
    }

    @Override
    public void performRequest(Request request) {
        IEditorPart editor;
        ActionRegistry actionRegistry;
        IAction action;
        if (request.getType() == "direct edit") {
            if (request instanceof DirectEditRequest && !this.directEditHitTest(((DirectEditRequest)request).getLocation().getCopy())) {
                return;
            }
            this.performDirectEdit();
        } else if (request.getType().equals("open") && (action = (actionRegistry = (ActionRegistry)(editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getAdapter(ActionRegistry.class)).getAction((Object)"Edit_propeties")) != null && action.isEnabled()) {
            action.run();
        }
    }

    protected void refreshVisuals() {
        ((Label)((SubgraphFigure)this.getFigure()).getHeader()).setText(labelProvider.getText(this.getModel()));
        ((Label)((SubgraphFigure)this.getFigure()).getHeader()).setIcon(labelProvider.getImage(this.getModel()));
        ((Label)((SubgraphFigure)this.getFigure()).getHeader()).setIconTextGap(5);
        ((Label)((SubgraphFigure)this.getFigure()).getHeader()).setToolTip((IFigure)new Label(this.eLabelProvider.getText(this.getModel(), true, true, true)));
        this.getFigure().repaint();
    }

    public void setSelected(int value) {
        super.setSelected(value);
        if (!(this.getModel() instanceof IWebflowState) || this.getModel() instanceof ISubflowState) {
            SubgraphFigure sf = (SubgraphFigure)this.getFigure();
            sf.setSelected(value != 0);
        }
    }
}

