/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.navigator.filters;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;

public class NonSpringArtefactsFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            IBeansProject project = BeansCorePlugin.getModel().getProject(folder.getProject());
            if (project != null) {
                String path = String.valueOf(folder.getProjectRelativePath().toString()) + '/';
                for (IBeansConfig config : project.getConfigs()) {
                    if (!config.getElementName().startsWith(path)) continue;
                    return true;
                }
            }
            return false;
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            IBeansProject project = BeansCorePlugin.getModel().getProject(file.getProject());
            if (project != null) {
                for (IBeansConfig config : project.getConfigs()) {
                    if (!config.getElementResource().equals((Object)file)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

