/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansProject;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIUtils;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabelDecorator;

public class AddAsBeanConfigAction
extends AbstractHandler {
    private Set<Object> selectedItems;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (Object element : this.selectedItems) {
            IProject project;
            if (element instanceof IType) {
                IType type = (IType)element;
                project = type.getJavaProject().getProject();
                String typeName = "java:" + type.getFullyQualifiedName();
                IBeansProject springProject = BeansCorePlugin.getModel().getProject(project);
                ((BeansProject)springProject).addConfig(typeName, IBeansConfig.Type.MANUAL);
                ((BeansProject)springProject).saveDescription();
                continue;
            }
            if (!(element instanceof IFile)) continue;
            IFile file = (IFile)element;
            project = file.getProject();
            IBeansProject springProject = BeansCorePlugin.getModel().getProject(project);
            ((BeansProject)springProject).addConfig(file, IBeansConfig.Type.MANUAL);
            ((BeansProject)springProject).saveDescription();
        }
        BeansModelLabelDecorator.update();
        return null;
    }

    private boolean isBeansConfig(IFile file) {
        return BeansCorePlugin.getModel().getConfig(file) != null;
    }

    private boolean isBeansConfig(IType type) {
        IBeansConfig config = null;
        IProject project = type.getJavaProject().getProject();
        IBeansProject beansProject = BeansCorePlugin.getModel().getProject(project);
        if (beansProject != null) {
            config = beansProject.getConfig("java:" + type.getFullyQualifiedName());
        }
        return config != null;
    }

    private boolean isBeansProject(IProject project) {
        return BeansCorePlugin.getModel().getProject(project) != null;
    }

    public boolean isEnabled() {
        return this.selectedItems.size() > 0;
    }

    public void setEnabled(Object evaluationContext) {
        this.selectedItems = new HashSet<Object>();
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (selection instanceof StructuredSelection) {
            Object[] objectArray = ((StructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IProject project;
                Object element = objectArray[n2];
                if (element instanceof IType) {
                    IType type = (IType)element;
                    project = type.getJavaProject().getProject();
                    if (this.isBeansProject(project) && !this.isBeansConfig(type)) {
                        IAnnotation configurationAnnotation = type.getAnnotation("Configuration");
                        IAnnotation componentAnnotation = type.getAnnotation("Component");
                        IAnnotation beanAnnotation = type.getAnnotation("Bean");
                        IAnnotation importAnnotation = type.getAnnotation("Import");
                        IAnnotation eacAnnotation = type.getAnnotation("EnableAutoConfiguration");
                        if (configurationAnnotation != null && configurationAnnotation.exists() || componentAnnotation != null && componentAnnotation.exists() || beanAnnotation != null && beanAnnotation.exists() || importAnnotation != null && importAnnotation.exists() || eacAnnotation != null && eacAnnotation.exists()) {
                            this.selectedItems.add(type);
                        }
                    }
                } else if (element instanceof IFile && this.isBeansProject(project = (file = (IFile)element).getProject()) && !this.isBeansConfig(file) && BeansUIUtils.isBeansConfigContentType(file)) {
                    this.selectedItems.add(file);
                }
                ++n2;
            }
        }
    }
}

