/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch.process;

import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IProcessFactory;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.RuntimeProcess;

public class BootProcessFactory
implements IProcessFactory {
    public static Method destroyForcibly;

    static {
        try {
            destroyForcibly = Process.class.getMethod("destroyForcibly", new Class[0]);
        }
        catch (Exception exception) {
            destroyForcibly = null;
        }
    }

    public IProcess newProcess(ILaunch launch, Process process, String label, Map<String, String> attributes) {
        if (destroyForcibly != null) {
            return new RuntimeProcess(launch, process, label, attributes){

                public void terminate() throws DebugException {
                    Process sysproc = this.getSystemProcess();
                    if (sysproc != null) {
                        try {
                            super.terminate();
                        }
                        catch (DebugException de) {
                            try {
                                destroyForcibly.invoke((Object)sysproc, new Object[0]);
                                boolean done = false;
                                while (!done) {
                                    try {
                                        sysproc.waitFor();
                                        done = true;
                                    }
                                    catch (InterruptedException interruptedException) {}
                                }
                            }
                            catch (Exception exception) {
                                throw de;
                            }
                        }
                    }
                }
            };
        }
        return new RuntimeProcess(launch, process, label, attributes);
    }
}

