/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.ui;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.core.contentassist.XmlBackedContentProposalAdapter;
import org.springframework.ide.eclipse.config.core.contentassist.XmlBackedContentProposalProvider;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.wizard.Messages;
import org.springframework.ide.eclipse.wizard.core.WizardBeanReferenceContentProposalProvider;
import org.springframework.ide.eclipse.wizard.core.WizardContentAssistConverter;
import org.springframework.ide.eclipse.wizard.ui.BeanChildDialog;
import org.springframework.ide.eclipse.wizard.ui.BeanWizard;
import org.w3c.dom.Document;

public class ConstructorArgDialog
extends BeanChildDialog {
    private static final String DEFAULT_MESSAGE = Messages.getString("ConstructorArgDialog.DEFAULT_MESSAGE");
    private String refErrorMessage;
    private String valueErrorMessage;
    private Text refText;
    private Text valueText;
    private String originalRef;
    private String originalValue;

    protected ConstructorArgDialog(Shell parentShell, BeanWizard wizard, IDOMElement constructorArg, String title, boolean isNew) {
        super(parentShell, wizard, constructorArg, title, isNew);
        if (constructorArg.hasAttribute(BeansSchemaConstants.ATTR_REF)) {
            this.originalRef = constructorArg.getAttribute(BeansSchemaConstants.ATTR_REF);
        }
        if (constructorArg.hasAttribute(BeansSchemaConstants.ATTR_VALUE)) {
            this.originalValue = constructorArg.getAttribute(BeansSchemaConstants.ATTR_VALUE);
        }
    }

    private void checkValueAndRef() {
        this.valueErrorMessage = this.valueText.getText().length() > 0 && this.refText.getText().length() > 0 ? Messages.getString("ElementDialog.VALUE_REF_OVERLAP_MESSAGE") : null;
    }

    private void createAttribute(String attributeName, Label label, Text text) {
        label.setText(String.valueOf(attributeName) + ":");
        label.setLayoutData((Object)new GridData());
        text.setEditable(true);
        text.setLayoutData((Object)new GridData(4, 4, true, false));
        WizardBeanReferenceContentProposalProvider proposalProvider = null;
        IDOMDocument originalDocument = this.wizard.getOriginalDocument();
        IFile beanFile = this.wizard.getBeanFile();
        if (attributeName.equals(BeansSchemaConstants.ATTR_REF)) {
            proposalProvider = new WizardBeanReferenceContentProposalProvider(this.element, attributeName, beanFile, (Document)originalDocument);
        }
        if (proposalProvider != null) {
            if (attributeName.equals(BeansSchemaConstants.ATTR_NAME)) {
                new XmlBackedContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (XmlBackedContentProposalProvider)proposalProvider, null);
            }
            new XmlBackedContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (XmlBackedContentProposalProvider)proposalProvider);
        }
        this.addListener(text, attributeName);
    }

    @Override
    protected void createAttributes(Composite container) {
        Label valueLabel = new Label(container, 0);
        this.valueText = new Text(container, 2048);
        if (this.originalValue != null) {
            this.valueText.setText(this.originalValue);
        }
        this.createAttribute(BeansSchemaConstants.ATTR_VALUE, valueLabel, this.valueText);
        Label refLabel = new Label(container, 0);
        this.refText = new Text(container, 2048);
        if (this.originalRef != null) {
            this.refText.setText(this.originalRef);
        }
        this.createAttribute(BeansSchemaConstants.ATTR_REF, refLabel, this.refText);
    }

    @Override
    protected boolean getCanFinish() {
        return this.valueErrorMessage == null;
    }

    @Override
    protected String getDefaultMessage() {
        return DEFAULT_MESSAGE;
    }

    @Override
    protected String getMessage() {
        if (this.valueErrorMessage != null) {
            return this.valueErrorMessage;
        }
        if (this.refErrorMessage != null) {
            return this.refErrorMessage;
        }
        return null;
    }

    @Override
    protected void resetAttributes() {
        this.resetAttribute(BeansSchemaConstants.ATTR_REF, this.originalRef);
        this.resetAttribute(BeansSchemaConstants.ATTR_VALUE, this.originalValue);
    }

    @Override
    protected void validateAttribute(String attributeName, String value, WizardContentAssistConverter contentAssistConverter) {
        Set proposals = null;
        if (attributeName.equals(BeansSchemaConstants.ATTR_REF)) {
            this.checkValueAndRef();
            this.refErrorMessage = value.length() > 0 ? ((proposals = contentAssistConverter.getReferenceableBeanDescriptions(value, true)).isEmpty() ? Messages.getString("ElementDialog.UNKNOWN_REF_MESSAGE") : null) : null;
        } else if (attributeName.equals(BeansSchemaConstants.ATTR_VALUE)) {
            this.checkValueAndRef();
        }
        this.updateMessage();
    }

    @Override
    protected void validateAttributes() {
        this.validateAttribute(BeansSchemaConstants.ATTR_REF, this.refText.getText());
    }
}

