/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.wizard.listeners.PropertiesPageShownListener;
import org.springframework.ide.eclipse.wizard.ui.BeanWizard;

public class BeanWizardDialog
extends WizardDialog {
    private final BeanWizard wizard;

    public static BeanWizardDialog createBeanWizardDialog(Shell shell) {
        return BeanWizardDialog.createBeanWizardDialog(shell, null, true);
    }

    public static BeanWizardDialog createBeanWizardDialog(Shell shell, IFile beanFile, boolean enabledFileBrowsing) {
        BeanWizard wizard = new BeanWizard(beanFile, enabledFileBrowsing);
        return BeanWizardDialog.createDialog(shell, wizard);
    }

    public static WizardDialog createBeanWizardDialog(Shell shell, IFile file, boolean enabledFileBrowsing, String qualifiedTypeName) {
        BeanWizard wizard = new BeanWizard(file, enabledFileBrowsing);
        IDOMElement newBean = wizard.getNewBean();
        newBean.setAttribute(BeansSchemaConstants.ATTR_CLASS, qualifiedTypeName);
        return BeanWizardDialog.createDialog(shell, wizard);
    }

    private static BeanWizardDialog createDialog(Shell shell, BeanWizard wizard) {
        BeanWizardDialog dialog = new BeanWizardDialog(shell, wizard);
        dialog.addPageChangedListener(new PropertiesPageShownListener(wizard));
        return dialog;
    }

    public static BeanWizardDialog createModifyBeanWizardDialog(Shell shell, IFile beanFile, IDOMElement existingNode) {
        BeanWizard wizard = new BeanWizard(existingNode, beanFile);
        return BeanWizardDialog.createDialog(shell, wizard);
    }

    private BeanWizardDialog(Shell shell, BeanWizard wizard) {
        super(shell, (IWizard)wizard);
        this.wizard = wizard;
    }

    public IDOMElement getNewBean() {
        return this.wizard.getNewBean();
    }
}

