/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.template.ProjectConfiguration;
import org.springframework.ide.eclipse.wizard.template.SpringVersion;
import org.springframework.ide.eclipse.wizard.template.TemplateInputCollector;
import org.springframework.ide.eclipse.wizard.template.TemplateProjectConfigurationDescriptor;
import org.springframework.ide.eclipse.wizard.template.infrastructure.Template;
import org.springframework.ide.eclipse.wizard.template.infrastructure.processor.Processor;
import org.springframework.ide.eclipse.wizard.template.newproject.NewProjectProcessingInfo;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

public class TemplateProjectConfiguration
extends ProjectConfiguration {
    private final Shell shell;
    private final Map<String, Object> collectedInput;
    private final Map<String, String> inputKinds;
    private final TemplateProjectConfigurationDescriptor configurationDescriptor;

    public TemplateProjectConfiguration(TemplateProjectConfigurationDescriptor configurationDescriptor, Shell shell) {
        this.configurationDescriptor = configurationDescriptor;
        this.shell = shell;
        this.collectedInput = new HashMap<String, Object>();
        this.inputKinds = new HashMap<String, String>();
    }

    public TemplateProjectConfiguration(Shell shell) {
        this(null, shell);
    }

    protected Shell getShell() {
        return this.shell;
    }

    protected void handleError(String errorMessage) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", errorMessage));
    }

    protected void handleError(String errorMessage, Exception error) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", errorMessage, (Throwable)error));
    }

    @Override
    public void configureProject(IProgressMonitor monitor) throws CoreException {
        Template template = this.configurationDescriptor.getTemplate();
        IProject project = this.getProject();
        if (template == null) {
            this.handleError("No project template selected to configure the project: " + this.getProject().getName());
            return;
        }
        if (project == null) {
            this.handleError("Failed to create a project. No project available to configure.");
            return;
        }
        IStatus status = this.collectInput();
        if (status == null || status.getSeverity() != 4) {
            if (status != null && status.getSeverity() == 2) {
                WizardPlugin.getDefault().getLog().log(status);
            }
            URI newPath = this.configurationDescriptor.getProjectLocationPath();
            String[] topLevelPackageTokens = this.configurationDescriptor.getTopLevelPackageTokens();
            String projectName = project.getName();
            try {
                NewProjectProcessingInfo processingInfo = new NewProjectProcessingInfo(template.getZippedLocation(), this.getProject().getName(), this.configurationDescriptor.getSpringVersion());
                Processor processor = new Processor(processingInfo);
                IProject processedProject = processor.process(project, newPath, topLevelPackageTokens, this.configurationDescriptor.getProjectNameToken(), this.collectedInput, this.inputKinds, this.shell, monitor);
                if (processedProject != null) {
                    processedProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    SpringCoreUtils.buildFullProject((IProject)processedProject);
                }
            }
            catch (Exception e) {
                this.handleError("Failure while processing template for project: " + projectName, e);
            }
        } else {
            throw new CoreException(status);
        }
    }

    @Override
    protected IProject create(IProgressMonitor monitor) throws CoreException {
        String projectName = this.configurationDescriptor.getActualProjectName();
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    protected IStatus collectInput() {
        List<TemplateInputCollector> inputHandlers = this.configurationDescriptor.getInputHandlers();
        IStatus status = Status.OK_STATUS;
        for (TemplateInputCollector handler : inputHandlers) {
            Map<String, Object> desCollectedInput;
            Map<String, String> desInputKinds = handler.getInputKinds();
            if (desInputKinds != null) {
                this.inputKinds.putAll(desInputKinds);
            }
            if ((desCollectedInput = handler.getCollectedInput()) == null) continue;
            this.collectedInput.putAll(desCollectedInput);
        }
        Template template = this.configurationDescriptor.getTemplate();
        String templateSpringVersion = template != null && template.getTemplateData() != null && template.getTemplateData().getDescriptor() != null ? template.getTemplateData().getDescriptor().getSpringVersion() : null;
        SpringVersion userDefinedSpringVersion = this.configurationDescriptor.getSpringVersion();
        if (this.inputKinds.containsKey(templateSpringVersion)) {
            status = new Status(2, "org.springframework.ide.eclipse.wizard", "Unable to replace Spring version: " + templateSpringVersion + " with " + userDefinedSpringVersion + " as the original Spring version token value is already used by another token definition. Check the token definitions in the template's wizard input definition file.");
        } else if (templateSpringVersion != null && userDefinedSpringVersion != null) {
            this.inputKinds.put(templateSpringVersion, "fixedtoken");
            this.collectedInput.put(templateSpringVersion, userDefinedSpringVersion.getVersion());
        }
        return status;
    }
}

