/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.springframework.ide.eclipse.wizard.template.TemplateUtils;
import org.springframework.ide.eclipse.wizard.template.infrastructure.ITemplateProjectData;
import org.springframework.ide.eclipse.wizard.template.infrastructure.RuntimeTemplateProjectData;
import org.springframework.ide.eclipse.wizard.template.infrastructure.Template;
import org.springsource.ide.eclipse.commons.content.core.ContentItem;

public class TemplateDataUIJob
implements IRunnableWithProgress {
    private final Template template;
    private final Shell shell;

    public TemplateDataUIJob(Template template, Shell shell) {
        this.template = template;
        this.shell = shell;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ContentItem selectedItem = this.template.getItem();
        if (!selectedItem.isLocal() && selectedItem.getRemoteDescriptor().getUrl() == null) {
            String message = NLS.bind((String)"In the descriptor file for ''{0}'', the URL to the project ZIP is missing.", (Object)selectedItem.getName());
            throw new InvocationTargetException(new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", message)));
        }
        try {
            try {
                monitor.beginTask("Download template " + this.template.getName(), 100);
                ITemplateProjectData data = this.template.getItem().isRuntimeDefined() ? new RuntimeTemplateProjectData(this.template.getItem().getRuntimeProject()) : TemplateUtils.importTemplate(this.template, this.shell, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                this.template.setTemplateData(data);
                if (data == null) {
                    throw new InvocationTargetException(new CoreException((IStatus)new Status(4, "org.springframework.ide.eclipse.wizard", NLS.bind((String)("Template data missing. Please check the template " + this.template.getName() + " to verify it has content."), null))));
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }
}

