/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.template;

import java.io.File;
import java.net.URI;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.core.StringUtils;
import org.springframework.ide.eclipse.ui.SpringUIUtils;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizard;
import org.springframework.ide.eclipse.wizard.template.NewSpringProjectWizardMessages;

public class NewSpringProjectCreationPage
extends NewJavaProjectWizardPageOne {
    private static final String CONFIG_PROPERTY_PREFIX = "ConfigurationPropertyPage.tabConfigFiles.";
    private static final String ENABLE_IMPORT_LABEL = "ConfigurationPropertyPage.tabConfigFiles.enableImports.label";
    private static final String IGNORE_MISSING_NAMESPACEHANDLER_LABEL = "ConfigurationPropertyPage.tabConfigFiles.ignoreMissingNamespaceHandler.label";
    private Button classpathCheckbox;
    private Button disableNamespaceCachingCheckbox;
    private Button enableImportButton;
    private Button enableProjectFacetsButton;
    private Button ignoreMissingNamespaceHandlerButton;
    private Text suffixesText;
    private SelectionButtonDialogField useProjectSettingsButton;
    private Button versionCheckbox;
    private boolean enableImports;
    private boolean enableProjectFacets;
    private String suffixes;
    private boolean ignoreMissingNamespaceHandlers;
    private boolean loadHandlerFromClasspath;
    private boolean useHighestXsdVersion;
    private boolean disableNamespaceCaching;
    private boolean useProjectSettings;

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.setTitle("Spring Configuration");
        Composite mainArea = new Composite(parent, 0);
        mainArea.setLayout((Layout)this.initGridLayout(new GridLayout(), true));
        mainArea.setLayoutData((Object)new GridData(1808));
        Dialog.applyDialogFont((Control)mainArea);
        this.createConfigFileGroup(mainArea);
        this.createNamespaceSettingsGroup(mainArea);
        this.createFacetsGroup(mainArea);
        this.createJRESection(mainArea);
        Control infoControl = this.createInfoControl(mainArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(infoControl);
        GridData data = (GridData)infoControl.getLayoutData();
        data.exclude = true;
        infoControl.setLayoutData((Object)data);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.applyParentFont(mainArea);
        this.setControl((Control)mainArea);
        this.refreshProjectValues();
        this.setPageComplete(this.validatePage());
    }

    protected void applyParentFont(Composite parent) {
        this.applyFontToChildren((Control)parent, parent.getFont());
    }

    protected void applyFontToChildren(Control control, Font font) {
        Control[] children;
        if (control instanceof Composite && (children = ((Composite)control).getChildren()) != null) {
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setFont(font);
                this.applyFontToChildren(child, font);
                ++n2;
            }
        }
    }

    protected void createJRESection(Composite parent) {
        Control jreControl = this.createJRESelectionControl(parent);
        jreControl.setLayoutData((Object)new GridData(768));
        Control infoControl = this.createInfoControl(parent);
        infoControl.setLayoutData((Object)new GridData(768));
    }

    protected void refreshProjectValues() {
        NewSpringProjectWizard wizard = (NewSpringProjectWizard)this.getWizard();
        this.setProjectName((String)wizard.getModel().projectName.getValue());
        String uriVal = (String)wizard.getModel().projectLocation.getValue();
        if (uriVal != null) {
            URI uri = new File(uriVal).toURI();
            this.setProjectLocationURI(uri);
        } else {
            this.setProjectLocationURI(null);
        }
    }

    public void performFinish() {
        this.refreshProjectValues();
    }

    public boolean enableImports() {
        return this.enableImports;
    }

    public boolean enableProjectFacets() {
        return this.enableProjectFacets;
    }

    public Set<String> getConfigSuffixes() {
        return StringUtils.commaDelimitedListToSet((String)this.suffixes);
    }

    public boolean ignoreMissingNamespaceHandlers() {
        return this.ignoreMissingNamespaceHandlers;
    }

    public boolean loadHandlerFromClasspath() {
        return this.loadHandlerFromClasspath;
    }

    public boolean disableNamespaceCaching() {
        return this.disableNamespaceCaching;
    }

    public boolean useHighestXsdVersion() {
        return this.useHighestXsdVersion;
    }

    public boolean useProjectSettings() {
        return this.useProjectSettings;
    }

    private Button createButton(Composite container, int style, int span, int indent) {
        Button button = new Button(container, style);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        gd.horizontalIndent = indent;
        button.setLayoutData((Object)gd);
        return button;
    }

    private void createConfigFileGroup(Composite container) {
        Group springGroup = new Group(container, 0);
        springGroup.setText(NewSpringProjectWizardMessages.NewProjectPage_configFileSettings);
        springGroup.setLayout((Layout)this.initGridLayout(new GridLayout(), true));
        springGroup.setLayoutData((Object)new GridData(768));
        this.enableImportButton = SpringUIUtils.createCheckBox((Composite)springGroup, (String)BeansUIPlugin.getResourceString((String)ENABLE_IMPORT_LABEL));
        this.enableImports = false;
        this.enableImportButton.setSelection(false);
        this.enableImportButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSpringProjectCreationPage.this.setPageComplete(NewSpringProjectCreationPage.this.validatePage());
                NewSpringProjectCreationPage.this.enableImports = NewSpringProjectCreationPage.this.enableImportButton.getSelection();
            }
        });
        this.ignoreMissingNamespaceHandlerButton = SpringUIUtils.createCheckBox((Composite)springGroup, (String)BeansUIPlugin.getResourceString((String)IGNORE_MISSING_NAMESPACEHANDLER_LABEL));
        this.ignoreMissingNamespaceHandlers = false;
        this.ignoreMissingNamespaceHandlerButton.setSelection(false);
        this.ignoreMissingNamespaceHandlerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSpringProjectCreationPage.this.setPageComplete(NewSpringProjectCreationPage.this.validatePage());
                NewSpringProjectCreationPage.this.ignoreMissingNamespaceHandlers = NewSpringProjectCreationPage.this.ignoreMissingNamespaceHandlerButton.getSelection();
            }
        });
        this.suffixesText = SpringUIUtils.createTextField((Composite)springGroup, (String)NewSpringProjectWizardMessages.NewProjectPage_suffixes);
        this.suffixes = "xml";
        this.suffixesText.setText("xml");
        this.suffixesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewSpringProjectCreationPage.this.setPageComplete(NewSpringProjectCreationPage.this.validatePage());
                NewSpringProjectCreationPage.this.suffixes = NewSpringProjectCreationPage.this.suffixesText.getText();
            }
        });
    }

    private void createFacetsGroup(Composite container) {
        Group facetsGroup = new Group(container, 0);
        facetsGroup.setText(NewSpringProjectWizardMessages.NewProjectPage_facetsSettings);
        facetsGroup.setLayout((Layout)this.initGridLayout(new GridLayout(), true));
        facetsGroup.setLayoutData((Object)new GridData(768));
        Label description = new Label((Composite)facetsGroup, 0);
        description.setText(NewSpringProjectWizardMessages.NewProjectPage_projectFacetsDescription);
        this.enableProjectFacetsButton = this.createButton((Composite)facetsGroup, 32, 1, 0);
        this.enableProjectFacetsButton.setText(NewSpringProjectWizardMessages.NewProjectPage_enableProjectFacets);
        this.enableProjectFacets = false;
        this.enableProjectFacetsButton.setSelection(false);
        this.enableProjectFacetsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSpringProjectCreationPage.this.enableProjectFacets = NewSpringProjectCreationPage.this.enableProjectFacetsButton.getSelection();
            }
        });
    }

    private void createNamespaceSettingsGroup(Composite container) {
        Group namespacesGroup = new Group(container, 0);
        namespacesGroup.setText(NewSpringProjectWizardMessages.NewProjectPage_namespacesSettings);
        namespacesGroup.setLayout((Layout)this.initGridLayout(new GridLayout(), true));
        namespacesGroup.setLayoutData((Object)new GridData(768));
        IDialogFieldListener listener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                NewSpringProjectCreationPage.this.enableProjectSpecificSettings(((SelectionButtonDialogField)field).isSelected());
            }
        };
        this.useProjectSettingsButton = new SelectionButtonDialogField(32);
        this.useProjectSettingsButton.setDialogFieldListener(listener);
        this.useProjectSettingsButton.setLabelText(NewSpringProjectWizardMessages.NewProjectPage_enableProjectSettings);
        this.useProjectSettingsButton.doFillIntoGrid((Composite)namespacesGroup, 1);
        LayoutUtil.setHorizontalGrabbing((Control)this.useProjectSettingsButton.getSelectionButton(null));
        LayoutUtil.setHorizontalSpan((Control)this.useProjectSettingsButton.getSelectionButton(null), (int)2);
        Label horizontalLine = new Label((Composite)namespacesGroup, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false));
        horizontalLine.setFont(namespacesGroup.getFont());
        Preferences prefs = BeansCorePlugin.getDefault().getPluginPreferences();
        this.useHighestXsdVersion = prefs.getBoolean("default.version.check.classpath");
        this.loadHandlerFromClasspath = prefs.getBoolean("loadNamespaceHandlerFromClasspath");
        this.disableNamespaceCaching = prefs.getBoolean("disableCachingForNamespaceLoadingFromClasspath");
        this.versionCheckbox = this.createButton((Composite)namespacesGroup, 32, 1, this.convertHorizontalDLUsToPixels(5));
        this.versionCheckbox.setText(NewSpringProjectWizardMessages.NewProjectPage_highestXsdVersion);
        this.versionCheckbox.setSelection(this.useHighestXsdVersion);
        this.versionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSpringProjectCreationPage.this.useHighestXsdVersion = NewSpringProjectCreationPage.this.versionCheckbox.getSelection();
            }
        });
        this.classpathCheckbox = this.createButton((Composite)namespacesGroup, 32, 1, this.convertHorizontalDLUsToPixels(5));
        this.classpathCheckbox.setText(NewSpringProjectWizardMessages.NewProjectPage_loadXsdsFromClasspath);
        this.classpathCheckbox.setSelection(this.loadHandlerFromClasspath);
        this.classpathCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSpringProjectCreationPage.this.loadHandlerFromClasspath = NewSpringProjectCreationPage.this.classpathCheckbox.getSelection();
                NewSpringProjectCreationPage.this.disableNamespaceCachingCheckbox.setEnabled(NewSpringProjectCreationPage.this.classpathCheckbox.getSelection());
            }
        });
        this.disableNamespaceCachingCheckbox = this.createButton((Composite)namespacesGroup, 32, 1, this.convertHorizontalDLUsToPixels(15));
        this.disableNamespaceCachingCheckbox.setText(NewSpringProjectWizardMessages.NewProjectPage_disableNamespaceCaching);
        this.disableNamespaceCachingCheckbox.setSelection(this.disableNamespaceCaching);
        this.disableNamespaceCachingCheckbox.setEnabled(this.loadHandlerFromClasspath);
        this.disableNamespaceCachingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewSpringProjectCreationPage.this.disableNamespaceCaching = NewSpringProjectCreationPage.this.disableNamespaceCachingCheckbox.getSelection();
            }
        });
        this.enableProjectSpecificSettings(false);
    }

    private void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        this.useProjectSettings = useProjectSpecificSettings;
        this.versionCheckbox.setEnabled(useProjectSpecificSettings);
        this.classpathCheckbox.setEnabled(useProjectSpecificSettings);
        this.disableNamespaceCachingCheckbox.setEnabled(useProjectSpecificSettings && this.classpathCheckbox.getSelection());
    }

    private GridLayout initGridLayout(GridLayout layout, boolean margins) {
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        if (margins) {
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        } else {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        return layout;
    }

    private boolean isValidSuffix(String suffix) {
        return suffix.length() != 0;
    }

    protected boolean validatePage() {
        String suffixes = this.suffixesText.getText().trim();
        if (suffixes.length() == 0) {
            this.setErrorMessage(NewSpringProjectWizardMessages.NewProjectPage_noSuffixes);
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(suffixes, ",");
        while (tokenizer.hasMoreTokens()) {
            String suffix = tokenizer.nextToken().trim();
            if (this.isValidSuffix(suffix)) continue;
            this.setErrorMessage(NewSpringProjectWizardMessages.NewProjectPage_invalidSuffixes);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

