/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.wizard.gettingstarted.content;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.springframework.ide.eclipse.wizard.WizardPlugin;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.ContentProvider;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.ContentType;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.GSContent;
import org.springframework.ide.eclipse.wizard.gettingstarted.content.TypedContentManager;
import org.springframework.ide.eclipse.wizard.gettingstarted.github.auth.AuthenticatedDownloader;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.DownloadManager;

public class ContentManager {
    private final Map<Class<?>, TypedContentManager<?>> byClass = new HashMap();
    private final List<ContentType<?>> types = new ArrayList();

    public <T extends GSContent> void register(Class<T> klass, String description, ContentProvider<T> provider) {
        try {
            Assert.isLegal((!this.byClass.containsKey(klass) ? 1 : 0) != 0, (String)("A content provider for " + klass + " is already registered"));
            ContentType<T> ctype = new ContentType<T>(klass, description);
            this.types.add(ctype);
            DownloadManager downloader = this.downloadManagerFor(klass);
            this.byClass.put(klass, new TypedContentManager<T>(downloader, provider));
        }
        catch (Throwable e) {
            WizardPlugin.log(e);
        }
    }

    public DownloadManager downloadManagerFor(Class<?> contentType) throws IllegalStateException, IOException {
        return new DownloadManager((DownloadManager.DownloadService)new AuthenticatedDownloader(), new File(WizardPlugin.getDefault().getStateLocation().toFile(), contentType.getSimpleName())).clearCache();
    }

    public <T> T[] get(Class<T> type) {
        TypedContentManager<?> man = this.byClass.get(type);
        if (man != null) {
            return man.getAll();
        }
        return null;
    }

    public ContentType<?>[] getTypes() {
        return this.types.toArray(new ContentType[this.types.size()]);
    }

    public Object[] get(ContentType<?> ct) {
        if (ct != null) {
            return this.get(ct.getKlass());
        }
        return null;
    }

    public static <T extends GSContent> ContentManager singleton(final Class<T> type, String description, final T item) {
        ContentManager cm = new ContentManager();
        cm.register(type, description, new ContentProvider<T>(){

            @Override
            public T[] fetch(DownloadManager downloader) {
                GSContent[] array = (GSContent[])Array.newInstance(type, 1);
                item.setDownloader(downloader);
                array[0] = item;
                return array;
            }
        });
        return cm;
    }
}

