/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.processors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.config.core.schemas.BeansSchemaConstants;
import org.springframework.ide.eclipse.quickfix.processors.BeanQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.proposals.RenameToSimilarNameQuickFixProposal;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConstructorArgNameQuickAssistProcessor
extends BeanQuickAssistProcessor {
    private final IJavaProject javaProject;
    private final String className;
    private final int numArguments;
    private final Set<String> constructorArgNames;

    public ConstructorArgNameQuickAssistProcessor(int offset, int length, String text, String className, IProject project, boolean missingEndQuote, int numArguments, IDOMNode constructorArgNode) {
        super(offset, length, text, missingEndQuote);
        this.className = className;
        this.numArguments = numArguments;
        this.javaProject = JavaCore.create((IProject)project);
        this.constructorArgNames = new HashSet<String>();
        NodeList siblingNodes = constructorArgNode.getParentNode().getChildNodes();
        int i = 0;
        while (i < siblingNodes.getLength()) {
            Node nameAttr;
            String localName;
            Node siblingNode = siblingNodes.item(i);
            if (siblingNode != constructorArgNode && (localName = siblingNode.getLocalName()) != null && localName.equals(BeansSchemaConstants.ELEM_CONSTRUCTOR_ARG) && (nameAttr = siblingNode.getAttributes().getNamedItem(BeansSchemaConstants.ATTR_NAME)) != null) {
                this.constructorArgNames.add(nameAttr.getNodeValue());
            }
            ++i;
        }
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        try {
            IType type = this.javaProject.findType(this.className);
            if (type != null) {
                IMethod[] methods;
                IMethod[] iMethodArray = methods = type.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    if (method.isConstructor()) {
                        proposals.addAll(this.createProposalForConstructor(method));
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            StatusHandler.log((IStatus)e.getStatus());
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private List<ICompletionProposal> createProposalForConstructor(IMethod method) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (method.getNumberOfParameters() == this.numArguments) {
            try {
                String[] paramNames;
                String[] stringArray = paramNames = method.getParameterNames();
                int n = paramNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String paramName = stringArray[n2];
                    if (!this.constructorArgNames.contains(paramName)) {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("'");
                        buffer.append(paramName);
                        buffer.append("'");
                        buffer.append(" in ");
                        JavaElementLabels.getMethodLabel((IMethod)method, (long)3L, (StringBuffer)buffer);
                        proposals.add(new RenameToSimilarNameQuickFixProposal(paramName, this.offset, this.length, this.missingEndQuote, buffer.toString()));
                    }
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return proposals;
    }
}

