/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor.scanner;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class WhitespaceRule
implements IRule {
    private IToken token;
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s");

    public WhitespaceRule(IToken token) {
        this.token = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        boolean atLeastOneMatch = false;
        while (c != -1) {
            String character = "" + (char)c;
            Matcher m = WHITESPACE_PATTERN.matcher(character);
            if (!m.matches()) {
                scanner.unread();
                break;
            }
            atLeastOneMatch = true;
            c = scanner.read();
        }
        if (atLeastOneMatch) {
            return this.token;
        }
        return Token.UNDEFINED;
    }
}

