/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor;

import java.net.URL;
import org.dadacoalition.yedit.Activator;
import org.dadacoalition.yedit.YEditLog;
import org.dadacoalition.yedit.editor.ColorManager;
import org.dadacoalition.yedit.editor.YAMLOutlineElement;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.osgi.framework.Bundle;

public class YEditStyledLabelProvider
extends StyledCellLabelProvider {
    private final StyledString.Styler TAG_STYLER;
    private final StyledString.Styler TEXT_STYLER;
    private static final IPath ICONS_PATH = new Path("/icons");
    private static ImageRegistry imageRegistry;
    public static final String IMG_SEQUENCE = "outline_sequence.png";
    public static final String IMG_MAPPING = "outline_mapping.gif";
    public static final String IMG_DOCUMENT = "outline_document.gif";
    public static final String IMG_SCALAR = "outline_scalar.gif";
    public static final String IMG_MAPPINGSCALAR = "outline_mappingscalar.gif";
    private static final String[] images;

    static {
        images = new String[]{IMG_SEQUENCE, IMG_MAPPING, IMG_DOCUMENT, IMG_SCALAR, IMG_MAPPINGSCALAR};
    }

    public YEditStyledLabelProvider(ColorManager colorManager) {
        final Color c = colorManager.getColor(new RGB(149, 125, 71));
        this.TAG_STYLER = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = c;
            }
        };
        this.TEXT_STYLER = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
            }
        };
    }

    public void update(ViewerCell cell) {
        Object e = cell.getElement();
        if (e instanceof YAMLOutlineElement) {
            YAMLOutlineElement element = (YAMLOutlineElement)e;
            StyledString styledString = new StyledString(this.elementLabel(element), this.TEXT_STYLER);
            boolean showTags = Activator.getDefault().getPreferenceStore().getBoolean("outlineShowTags");
            if (showTags) {
                styledString.append(" " + element.node.getTag(), this.TAG_STYLER);
            }
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.getImage(element));
        }
        super.update(cell);
    }

    private String elementLabel(YAMLOutlineElement element) {
        if (element.children.size() == 0) {
            int maxLength = Activator.getDefault().getPreferenceStore().getInt("outlineScalarMaxLength");
            String elemString = element.toString();
            if (maxLength != 0 && elemString.length() > maxLength) {
                elemString = elemString.substring(0, maxLength);
                elemString = String.valueOf(elemString) + " ...";
            }
            return elemString;
        }
        return element.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof YAMLOutlineElement) {
            YAMLOutlineElement segment = (YAMLOutlineElement)element;
            if (segment.type == 3) {
                return YEditStyledLabelProvider.get(IMG_DOCUMENT);
            }
            if (segment.type == 1) {
                if (segment.children.size() == 0) {
                    return YEditStyledLabelProvider.get(IMG_MAPPINGSCALAR);
                }
                return YEditStyledLabelProvider.get(IMG_MAPPING);
            }
            if (segment.type == 2) {
                if (segment.children.size() == 0) {
                    return YEditStyledLabelProvider.get(IMG_SCALAR);
                }
                return YEditStyledLabelProvider.get(IMG_SEQUENCE);
            }
        }
        return null;
    }

    private static Image get(String imageName) {
        return YEditStyledLabelProvider.getImageRegistry().get(imageName);
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
            String[] stringArray = images;
            int n = images.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                imageRegistry.put(s, YEditStyledLabelProvider.create(s));
                ++n2;
            }
        }
        return imageRegistry;
    }

    private static ImageDescriptor create(String name) {
        IPath path = ICONS_PATH.append(name);
        return YEditStyledLabelProvider.createImageDescriptor(Activator.getDefault().getBundle(), path);
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        YEditLog.logger.fine("Attempting to load image " + url);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        YEditLog.logger.warning("Could not load image " + path);
        return null;
    }
}

