/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.namespaces.bean;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.IReferenceableElementsLocator;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeansReferenceableElementsLocator
implements IReferenceableElementsLocator {
    public static final String BEAN_NAME_DELIMITERS = ",; ";

    @Override
    public Map<String, Set<Node>> getReferenceableElements(Document document, IFile file) {
        HashMap<String, Set<Node>> nodes = new HashMap<String, Set<Node>>();
        NodeList childNodes = document.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if ("bean".equals(node.getNodeName())) {
                if (BeansEditorUtils.hasAttribute(node, "id")) {
                    BeansReferenceableElementsLocator.addNodeToMap(BeansEditorUtils.getAttribute(node, "id"), node, nodes);
                }
                if (BeansEditorUtils.hasAttribute(node, "name")) {
                    String[] nameArr;
                    String aliasesString = BeansEditorUtils.getAttribute(node, "name");
                    String[] stringArray = nameArr = StringUtils.tokenizeToStringArray((String)aliasesString, (String)BEAN_NAME_DELIMITERS);
                    int n = nameArr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        BeansReferenceableElementsLocator.addNodeToMap(name, node, nodes);
                        ++n2;
                    }
                }
            }
            ++i;
        }
        return nodes;
    }

    private static void addNodeToMap(String name, Node node, Map<String, Set<Node>> nodes) {
        Set<Node> matchedNodes = nodes.get(name);
        if (matchedNodes == null) {
            matchedNodes = new HashSet<Node>();
            nodes.put(name, matchedNodes);
        }
        matchedNodes.add(node);
    }
}

