/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.hyperlink;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.springframework.ide.eclipse.beans.ui.editor.hyperlink.HyperlinkUtils;
import org.springframework.ide.eclipse.beans.ui.editor.namespaces.INamespaceHyperlinkDetector;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public abstract class AbstractHyperlinkDetector
implements IHyperlinkDetector,
INamespaceHyperlinkDetector {
    @Override
    public void init() {
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        Node currentNode = BeansEditorUtils.getNodeByOffset(document, region.getOffset());
        if (currentNode != null) {
            switch (currentNode.getNodeType()) {
                case 1: {
                    IHyperlink[] hyperlinks;
                    Attr currentAttr = BeansEditorUtils.getAttrByOffset(currentNode, region.getOffset());
                    IDOMAttr attr = (IDOMAttr)currentAttr;
                    if (currentAttr == null || region.getOffset() < attr.getValueRegionStartOffset() || !this.isLinkableAttr(currentAttr)) break;
                    IRegion hyperlinkRegion = HyperlinkUtils.getHyperlinkRegion(currentAttr);
                    if (canShowMultipleHyperlinks && (hyperlinks = this.createHyperlinks(currentAttr.getName(), currentAttr.getNodeValue(), currentNode, currentNode.getParentNode(), document, textViewer, hyperlinkRegion, region)) != null && hyperlinks.length > 0) {
                        return hyperlinks;
                    }
                    IHyperlink hyperLink = this.createHyperlink(currentAttr.getName(), currentAttr.getNodeValue(), currentNode, currentNode.getParentNode(), document, textViewer, hyperlinkRegion, region);
                    if (hyperLink == null) break;
                    return new IHyperlink[]{hyperLink};
                }
                case 3: {
                    IHyperlink[] hyperlinks;
                    IRegion hyperlinkRegion = HyperlinkUtils.getHyperlinkRegion(currentNode);
                    Node parentNode = currentNode.getParentNode();
                    if (parentNode == null) break;
                    if (canShowMultipleHyperlinks && (hyperlinks = this.createHyperlinks(parentNode.getNodeName(), currentNode.getNodeValue(), currentNode, parentNode, document, textViewer, hyperlinkRegion, region)) != null && hyperlinks.length > 0) {
                        return hyperlinks;
                    }
                    IHyperlink hyperLink = this.createHyperlink(parentNode.getNodeName(), currentNode.getNodeValue(), currentNode, parentNode, document, textViewer, hyperlinkRegion, region);
                    if (hyperLink == null) break;
                    return new IHyperlink[]{hyperLink};
                }
            }
        }
        return null;
    }

    @Override
    public IHyperlink[] createHyperlinks(String name, String target, Node node, Node parentNode, IDocument document, ITextViewer textViewer, IRegion hyperlinkRegion, IRegion cursor) {
        return null;
    }
}

