/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelImages;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class ConstructorArgNameSearchRequestor {
    public static final int CONSTRUCTOR_RELEVANCE = 10;
    protected JavaElementImageProvider imageProvider;
    protected Set<String> argNames;
    protected ContentAssistRequest request;
    private String prefix;
    private boolean attrAtLocationHasValue;
    private String namespacePrefix = "";

    public ConstructorArgNameSearchRequestor(ContentAssistRequest request, String prefix, boolean attrAtLocationHasValue, String nameSpacePrefix) {
        this.request = request;
        this.argNames = new HashSet<String>();
        this.imageProvider = new JavaElementImageProvider();
        this.prefix = prefix;
        this.attrAtLocationHasValue = attrAtLocationHasValue;
        if (this.namespacePrefix != null) {
            this.namespacePrefix = String.valueOf(nameSpacePrefix) + ":";
        }
    }

    public void acceptSearchMatch(IMethod constructor) throws CoreException {
        if (Flags.isPublic((int)constructor.getFlags()) && ((IType)constructor.getParent()).isClass() && constructor.isConstructor() && constructor.exists()) {
            this.createConstructorArgProposal(constructor);
        }
    }

    protected void createConstructorArgProposal(IMethod constructor) {
        try {
            String[] parameterNames = constructor.getParameterNames();
            String[] parameterTypes = JdtUtils.getParameterTypesString((IMethod)constructor);
            String[] stringArray = parameterNames;
            int n = parameterNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (!this.argNames.contains(name)) {
                    String replaceText = String.valueOf(this.namespacePrefix) + this.prefix + name;
                    StringBuffer buf = new StringBuffer();
                    buf.append(" - ");
                    buf.append(constructor.getElementName());
                    buf.append('(');
                    if (parameterTypes != null && parameterNames != null && parameterTypes.length > 0 && parameterNames.length > 0) {
                        buf.append(parameterTypes[0]);
                        buf.append(' ');
                        buf.append(parameterNames[0]);
                        if (parameterTypes.length > 1 && parameterTypes.length > 1) {
                            int i = 1;
                            while (i < parameterTypes.length) {
                                buf.append(", ");
                                buf.append(parameterTypes[i]);
                                buf.append(' ');
                                buf.append(parameterNames[i]);
                                ++i;
                            }
                        }
                    }
                    buf.append(')');
                    String displayText = buf.toString();
                    Image image = this.imageProvider.getImageLabel((Object)constructor, constructor.getFlags() | 2);
                    int cursor = replaceText.length();
                    String refReplaceText = String.valueOf(replaceText) + "-ref";
                    if (!this.attrAtLocationHasValue) {
                        replaceText = String.valueOf(replaceText) + "=\"\"";
                        cursor = replaceText.length() - 1;
                    } else {
                        cursor = replaceText.length() + 2;
                    }
                    CustomCompletionProposal proposal1 = new CustomCompletionProposal(replaceText, this.request.getReplacementBeginPosition(), this.request.getReplacementLength(), cursor, image, String.valueOf(this.namespacePrefix) + name + displayText, null, null, 10);
                    if (!this.attrAtLocationHasValue) {
                        refReplaceText = String.valueOf(refReplaceText) + "=\"\"";
                        cursor = refReplaceText.length() - 1;
                    } else {
                        cursor = refReplaceText.length() + 2;
                    }
                    image = BeansModelImages.getDecoratedImage((Image)image, (int)8);
                    CustomCompletionProposal proposal2 = new CustomCompletionProposal(refReplaceText, this.request.getReplacementBeginPosition(), this.request.getReplacementLength(), cursor, image, String.valueOf(this.namespacePrefix) + name + "-ref" + displayText, null, null, 10);
                    this.request.addProposal((ICompletionProposal)proposal1);
                    this.request.addProposal((ICompletionProposal)proposal2);
                    this.argNames.add(name);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
    }
}

