/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist.bean;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public class ConstructorArgNameContentAssistCalculator
implements IContentAssistCalculator {
    public static final int CONSTRUCTOR_RELEVANCE = 10;
    private JavaElementImageProvider imageProvider = new JavaElementImageProvider();

    @Override
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        if (context.getParentNode() != null && "bean".equals(context.getParentNode().getLocalName())) {
            IType type;
            IFile file = context.getFile();
            String className = BeansEditorUtils.getClassNameForBean(file, context.getDocument(), context.getParentNode());
            if (file != null && file.exists() && (type = JdtUtils.getJavaType((IProject)file.getProject(), (String)className)) != null) {
                try {
                    Set constructors = Introspector.getAllConstructors((IType)type);
                    for (IMethod constructor : constructors) {
                        String[] paramNames;
                        String[] stringArray = paramNames = constructor.getParameterNames();
                        int n = paramNames.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String paramName = stringArray[n2];
                            this.createMethodProposal(recorder, constructor, paramName);
                            ++n2;
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    protected void createMethodProposal(IContentAssistProposalRecorder recorder, IMethod method, String paramName) {
        try {
            String[] parameterNames = method.getParameterNames();
            String[] parameterTypes = JdtUtils.getParameterTypesString((IMethod)method);
            String replaceText = paramName;
            StringBuilder buf = new StringBuilder();
            buf.append(paramName);
            buf.append(" - ");
            buf.append(method.getElementName());
            buf.append('(');
            if (parameterTypes != null && parameterNames != null && parameterTypes.length > 0 && parameterNames.length > 0) {
                buf.append(parameterTypes[0]);
                buf.append(' ');
                buf.append(parameterNames[0]);
            }
            buf.append(')');
            String displayText = buf.toString();
            Image image = this.imageProvider.getImageLabel((Object)method, method.getFlags() | 2);
            recorder.recordProposal(image, 10, displayText, replaceText, method);
        }
        catch (JavaModelException javaModelException) {}
    }
}

