/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.actions;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.editor.Activator;
import org.springframework.ide.eclipse.beans.ui.editor.outline.OutlineSorter;

public class LexicalSortingAction
extends Action {
    private static final String PREFIX = "Outline.SortAction.";
    private TreeViewer viewer;

    public LexicalSortingAction(TreeViewer viewer) {
        this.viewer = viewer;
        this.setText(Activator.getResourceString("Outline.SortAction.label"));
        BeansUIImages.setLocalImageDescriptors((IAction)this, (String)"alphab_sort_co.gif");
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        boolean checked = prefs.getBoolean("org.springframework.ide.eclipse.beans.ui.editor.outline.sort");
        this.update(checked, false);
    }

    public void run() {
        this.update(this.isChecked(), true);
    }

    public void update(boolean value, boolean doStore) {
        this.setChecked(value);
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        boolean spring = prefs.getBoolean("org.springframework.ide.eclipse.beans.ui.editor.outline.spring");
        if (spring) {
            this.viewer.setSorter((ViewerSorter)(value ? new OutlineSorter() : null));
        }
        this.setToolTipText(value ? Activator.getResourceString("Outline.SortAction.tooltip.checked") : Activator.getResourceString("Outline.SortAction.tooltip.unchecked"));
        this.setDescription(value ? Activator.getResourceString("Outline.SortAction.description.checked") : Activator.getResourceString("Outline.SortAction.description.unchecked"));
        if (doStore) {
            prefs.setValue("org.springframework.ide.eclipse.beans.ui.editor.outline.sort", value);
            Activator.getDefault().savePluginPreferences();
            this.viewer.refresh(true);
        }
    }
}

