/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import org.testng.eclipse.ui.OpenEditorAction;
import org.testng.eclipse.ui.TestRunnerViewPart;

public class OpenEditorAtLineAction
extends OpenEditorAction {
    private int fLineNumber;
    private String fCUName;

    public OpenEditorAtLineAction(TestRunnerViewPart testRunner, String cuName, String className, int line) {
        super(testRunner, className);
        this.fLineNumber = line;
        this.fCUName = cuName;
    }

    @Override
    protected void reveal(ITextEditor textEditor) {
        if (this.fLineNumber >= 0) {
            try {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                textEditor.selectAndReveal(document.getLineOffset(this.fLineNumber - 1), document.getLineLength(this.fLineNumber - 1));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    @Override
    protected IJavaElement findElement(IJavaProject project, String className) throws CoreException {
        IType element = project.findType(className);
        if (element == null) {
            SearchPattern pattern = SearchPattern.createPattern((String)className, (int)0, (int)0, (int)24);
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}, (boolean)false);
            NonPublicClassInCUCollector requestor = new NonPublicClassInCUCollector();
            SearchEngine searchEngine = new SearchEngine();
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
            element = requestor.fFound;
        }
        return element;
    }

    public boolean isEnabled() {
        try {
            return this.getLaunchedProject().findType(this.getClassName()) != null;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private class NonPublicClassInCUCollector
    extends SearchRequestor {
        private IJavaElement fFound;

        private NonPublicClassInCUCollector() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            IJavaElement enclosingElement = (IJavaElement)match.getElement();
            String resourceName = match.getResource().getName();
            if (enclosingElement instanceof IType && resourceName.equals(OpenEditorAtLineAction.this.fCUName)) {
                this.fFound = enclosingElement;
            }
        }
    }
}

