/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IWeavingAdaptor;
import org.eclipse.equinox.weaving.adaptors.WeavingAdaptor;
import org.eclipse.equinox.weaving.adaptors.WeavingAdaptorFactory;
import org.eclipse.equinox.weaving.hooks.AbstractWeavingHook;
import org.eclipse.equinox.weaving.hooks.BaseWeavingBundleFile;
import org.eclipse.equinox.weaving.hooks.BundleAdaptorProvider;
import org.eclipse.equinox.weaving.hooks.SupplementBundleListener;
import org.eclipse.equinox.weaving.hooks.WeavingBundleEntry;
import org.eclipse.equinox.weaving.hooks.WeavingBundleFile;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class WeavingHook
extends AbstractWeavingHook {
    private final WeavingAdaptorFactory adaptorFactory;
    private final Map<Long, IWeavingAdaptor> adaptors;
    private BundleContext bundleContext;

    public WeavingHook() {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- WeavingHook.<init>()");
        }
        this.adaptorFactory = new WeavingAdaptorFactory();
        this.adaptors = new HashMap<Long, IWeavingAdaptor>();
    }

    public void classLoaderCreated(ModuleClassLoader moduleClassLoader) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> WeavingHook.initializedClassLoader() bundle=" + moduleClassLoader.getBundle().getSymbolicName() + ", loader=" + moduleClassLoader + ", bundleFile=" + moduleClassLoader.getClasspathManager().getGeneration().getBundleFile());
        }
        IWeavingAdaptor iWeavingAdaptor = this.createWeavingAdaptor(moduleClassLoader.getClasspathManager().getGeneration(), moduleClassLoader);
        this.adaptors.put(moduleClassLoader.getBundle().getBundleId(), iWeavingAdaptor);
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< WeavingHook.initializedClassLoader() adaptor=" + iWeavingAdaptor);
        }
    }

    private IWeavingAdaptor createWeavingAdaptor(BundleInfo.Generation generation, ModuleClassLoader moduleClassLoader) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> WeavingHook.createAspectJAdaptor() location=" + generation.getRevision().getRevisions().getModule().getLocation());
        }
        WeavingAdaptor weavingAdaptor = null;
        if (this.adaptorFactory != null) {
            weavingAdaptor = new WeavingAdaptor(generation, this.adaptorFactory, null, null, moduleClassLoader);
        } else if (Debug.DEBUG_GENERAL) {
            Debug.println("- WeavingHook.createAspectJAdaptor() factory=" + this.adaptorFactory);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< WeavingHook.createAspectJAdaptor() adaptor=" + weavingAdaptor);
        }
        return weavingAdaptor;
    }

    @Override
    public IWeavingAdaptor getAdaptor(long l) {
        return this.adaptors.get(l);
    }

    @Override
    public IWeavingAdaptor getHostBundleAdaptor(long l) {
        Bundle bundle;
        Bundle bundle2 = this.bundleContext.getBundle(l);
        if (bundle2 != null && (bundle = this.adaptorFactory.getHost(bundle2)) != null) {
            long l2 = bundle.getBundleId();
            return this.adaptors.get(l2);
        }
        return null;
    }

    private void initialize(BundleContext bundleContext) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> WeavingHook.initialize() context=" + bundleContext);
        }
        this.bundleContext = bundleContext;
        ISupplementerRegistry iSupplementerRegistry = this.getSupplementerRegistry();
        this.adaptorFactory.initialize(bundleContext, iSupplementerRegistry);
        ServiceReference serviceReference = bundleContext.getServiceReference(PackageAdmin.class);
        PackageAdmin packageAdmin = (PackageAdmin)bundleContext.getService(serviceReference);
        iSupplementerRegistry.setBundleContext(bundleContext);
        iSupplementerRegistry.setPackageAdmin(packageAdmin);
        bundleContext.addBundleListener((BundleListener)new SupplementBundleListener(iSupplementerRegistry));
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = 0;
        while (n < bundleArray.length) {
            iSupplementerRegistry.addSupplementer(bundleArray[n], false);
            ++n;
        }
        n = 0;
        while (n < bundleArray.length) {
            iSupplementerRegistry.addSupplementedBundle(bundleArray[n]);
            ++n;
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< WeavingHook.initialize() adaptorFactory=" + this.adaptorFactory);
        }
    }

    public byte[] processClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        WeavingBundleEntry weavingBundleEntry;
        byte[] byArray2 = null;
        if (bundleEntry instanceof WeavingBundleEntry && !(weavingBundleEntry = (WeavingBundleEntry)bundleEntry).dontWeave()) {
            IWeavingAdaptor iWeavingAdaptor = weavingBundleEntry.getAdaptor();
            byArray2 = iWeavingAdaptor.weaveClass(string, byArray);
        }
        return byArray2;
    }

    public void recordClassDefine(String string, Class<?> clazz, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        WeavingBundleEntry weavingBundleEntry;
        if (clazz == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println("Error in defining class: " + string);
            }
            return;
        }
        if (bundleEntry instanceof WeavingBundleEntry && !(weavingBundleEntry = (WeavingBundleEntry)bundleEntry).dontWeave()) {
            IWeavingAdaptor iWeavingAdaptor = weavingBundleEntry.getAdaptor();
            URL uRL = weavingBundleEntry.getBundleFileURL();
            iWeavingAdaptor.storeClass(string, uRL, clazz, byArray);
        }
    }

    @Override
    public void resetAdaptor(long l) {
        this.adaptors.remove(l);
    }

    public void start(BundleContext bundleContext) throws BundleException {
        this.initialize(bundleContext);
    }

    public void stop(BundleContext bundleContext) throws BundleException {
        this.adaptorFactory.dispose(bundleContext);
    }

    public BundleFileWrapper wrapBundleFile(BundleFile bundleFile, BundleInfo.Generation generation, boolean bl) {
        WeavingBundleFile weavingBundleFile = null;
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("> WeavingHook.wrapBundleFile() bundle=" + (generation.getRevision() != null ? generation.getRevision().getSymbolicName() : Long.valueOf(generation.getBundleInfo().getBundleId())) + " bundleFile=" + bundleFile + ", generation=" + generation + ", base=" + bl + ", baseFile=" + bundleFile.getBaseFile());
        }
        weavingBundleFile = bl ? new BaseWeavingBundleFile(new BundleAdaptorProvider(generation, this), bundleFile) : new WeavingBundleFile(new BundleAdaptorProvider(generation, this), bundleFile);
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("< WeavingHook.wrapBundleFile() wrapped=" + (Object)((Object)weavingBundleFile));
        }
        return weavingBundleFile;
    }
}

