/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.rules;

import java.util.Collection;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.impl.PreferenceUIStore;
import net.sourceforge.pmd.eclipse.ui.ModifyListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.PMDPreferencePage2;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelectionListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleTableManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueResetHandler;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.RulePropertyManager;
import net.sourceforge.pmd.eclipse.util.Util;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.ViewPart;

public class RuleEditorView
extends ViewPart
implements RuleSelectionListener,
ModifyListener,
ValueChangeListener,
ValueResetHandler {
    private TabFolder tabFolder;
    private RulePropertyManager[] rulePropertyManagers;
    private RuleTableManager tableManager;
    private IPreferences preferences = PMDPlugin.getDefault().loadPreferences();
    protected static PMDPlugin plugin = PMDPlugin.getDefault();
    private static final RuleColumnDescriptor[] availableColumns = PMDPreferencePage2.availableColumns;
    private static final Object[][] groupingChoices = PMDPreferencePage2.groupingChoices;

    protected String descriptionId() {
        return "preference.ruleset.title";
    }

    public void createPartControl(Composite parent) {
        this.tableManager = new RuleTableManager("rules", availableColumns, PMDPlugin.getDefault().loadPreferences(), this);
        this.tableManager.modifyListener(this);
        this.tableManager.selectionListener(this);
        this.populateRuleset();
        Composite composite = new Composite(parent, 0);
        this.layoutControls(composite);
        this.tableManager.populateRuleTable();
        int i = PreferenceUIStore.instance.selectedPropertyTab();
        this.tabFolder.setSelection(i);
    }

    private Composite createRuleSection(Composite parent) {
        Composite ruleSection = new Composite(parent, 0);
        Composite groupCombo = this.tableManager.buildGroupCombo(ruleSection, "preference.ruleset.label.rules_grouped_by", groupingChoices);
        Tree ruleTree = this.tableManager.buildRuleTreeViewer(ruleSection);
        this.tableManager.groupBy(null);
        Composite ruleTableButtons = this.tableManager.buildRuleTableButtons(ruleSection);
        Composite rulePropertiesTableButtons = PMDPreferencePage2.buildRulePropertiesTableButtons(ruleSection);
        GridLayout gridLayout = new GridLayout(3, false);
        ruleSection.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        groupCombo.setLayoutData((Object)data);
        data = new GridData();
        data.heightHint = 200;
        data.widthHint = 350;
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        ruleTree.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        ruleTableButtons.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        rulePropertiesTableButtons.setLayoutData((Object)data);
        return ruleSection;
    }

    private TabFolder buildTabFolder(Composite parent) {
        this.tabFolder = new TabFolder(parent, 128);
        this.rulePropertyManagers = PMDPreferencePage2.buildPropertyManagersOn(this.tabFolder, this);
        this.tabFolder.pack();
        return this.tabFolder;
    }

    @Override
    public void changed(PropertySource source, PropertyDescriptor<?> desc, Object newValue) {
        this.setModified();
        this.tableManager.updated(source);
    }

    @Override
    public void changed(RuleSelection selection, PropertyDescriptor<?> desc, Object newValue) {
        for (Rule rule : selection.allRules()) {
            if (newValue != null) {
                this.tableManager.changed(selection, desc, newValue);
                continue;
            }
            this.tableManager.changed((PropertySource)rule, desc, newValue);
        }
        RulePropertyManager[] rulePropertyManagerArray = this.rulePropertyManagers;
        int n = this.rulePropertyManagers.length;
        int n2 = 0;
        while (n2 < n) {
            RulePropertyManager manager = rulePropertyManagerArray[n2];
            manager.validate();
            ++n2;
        }
        this.setModified();
    }

    private void layoutControls(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        int ruleTableFraction = 55;
        final Sash sash = new Sash(parent, 256);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(ruleTableFraction, 0);
        sash.setLayoutData((Object)data);
        sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((FormData)sash.getLayoutData()).top = new FormAttachment(0, event.y);
                sash.getParent().layout();
            }
        });
        Composite ruleSection = this.createRuleSection(parent);
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)sash, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        ruleSection.setLayoutData((Object)data);
        TabFolder propertySection = this.buildTabFolder(parent);
        data = new FormData();
        data.top = new FormAttachment((Control)sash, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        propertySection.setLayoutData((Object)data);
    }

    public void performOk() {
        this.saveUIState();
    }

    protected void performDefaults() {
        this.tableManager.populateRuleTable();
    }

    private void populateRuleset() {
        RuleSet defaultRuleSet = plugin.getPreferencesManager().getRuleSet();
        RuleSet ruleSet = new RuleSet();
        ruleSet.addRuleSet(defaultRuleSet);
        ruleSet.setName(defaultRuleSet.getName());
        ruleSet.setDescription(Util.asCleanString(defaultRuleSet.getDescription()));
        ruleSet.addExcludePatterns((Collection)defaultRuleSet.getExcludePatterns());
        ruleSet.addIncludePatterns((Collection)defaultRuleSet.getIncludePatterns());
        this.tableManager.useRuleSet(ruleSet);
    }

    @Override
    public void selection(RuleSelection selection) {
        if (this.rulePropertyManagers == null) {
            return;
        }
        RulePropertyManager[] rulePropertyManagerArray = this.rulePropertyManagers;
        int n = this.rulePropertyManagers.length;
        int n2 = 0;
        while (n2 < n) {
            RulePropertyManager manager = rulePropertyManagerArray[n2];
            manager.manage(selection);
            manager.validate();
            ++n2;
        }
    }

    private void rebuildProjects() {
    }

    private void saveUIState() {
        this.tableManager.saveUIState();
        int i = this.tabFolder.getSelectionIndex();
        PreferenceUIStore.instance.selectedPropertyTab(i);
        PreferenceUIStore.instance.save();
    }

    private void updateRuleSet() {
    }

    protected String getMessage(String key) {
        return PMDPlugin.getDefault().getStringTable().getString(key);
    }

    @Override
    public void setModified() {
    }

    public void setFocus() {
    }

    @Override
    public void resetValuesIn(RuleSelection rules) {
    }
}

