/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.RefreshableTablePage;
import net.sourceforge.pmd.eclipse.util.Util;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class ViolationOutlineContentProvider
implements IStructuredContentProvider,
IResourceChangeListener {
    private RefreshableTablePage tablePage;
    private TableViewer tableViewer;
    private FileRecord resource;

    public ViolationOutlineContentProvider(RefreshableTablePage page) {
        this.tablePage = page;
        this.tableViewer = page.tableViewer();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof FileRecord) {
            return ((FileRecord)inputElement).findMarkers();
        }
        return Util.EMPTY_ARRAY;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.resource != null) {
            this.resource.getResource().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        this.resource = (FileRecord)newInput;
        if (this.resource != null) {
            this.resource.getResource().getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        this.tableViewer = (TableViewer)viewer;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.resource == null || !this.resource.getResource().exists()) {
            return;
        }
        List<IMarkerDelta> markerDeltas = MarkerUtil.markerDeltasIn(event);
        if (markerDeltas.isEmpty()) {
            return;
        }
        final ArrayList<IMarker> additions = new ArrayList<IMarker>();
        final ArrayList<IMarker> removals = new ArrayList<IMarker>();
        final ArrayList<IMarker> changes = new ArrayList<IMarker>();
        for (IMarkerDelta delta : markerDeltas) {
            if (!delta.getResource().equals((Object)this.resource.getResource())) continue;
            IMarker marker = delta.getMarker();
            switch (delta.getKind()) {
                case 1: {
                    additions.add(marker);
                    break;
                }
                case 2: {
                    removals.add(marker);
                    break;
                }
                case 4: {
                    changes.add(marker);
                }
            }
        }
        this.tableViewer.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ViolationOutlineContentProvider.this.updateViewer(additions, removals, changes);
            }
        });
    }

    protected void updateViewer(List<IMarker> additions, List<IMarker> removals, List<IMarker> changes) {
        if (removals.size() > 0) {
            this.tableViewer.cancelEditing();
            this.tableViewer.remove(removals.toArray());
        }
        if (additions.size() > 0) {
            this.tableViewer.add(additions.toArray());
        }
        if (changes.size() > 0) {
            this.tableViewer.update(changes.toArray(), null);
        }
        this.tablePage.refresh();
    }
}

