/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.util.NumericConstants;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ViewMemento {
    private final IPath path;
    private final File file;
    private XMLMemento memento;
    protected static final String XML_PREFIX = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    protected static final String LIST_SEPARATOR = ":";
    protected static final String MEMENTO_PREFIX = "memento";
    protected static final String ATTRIBUTE_PREFIX = "attribute";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_VALUE = "value";

    /*
     * Unable to fully structure code
     */
    public ViewMemento(String type) {
        block19: {
            super();
            this.path = PMDPlugin.getDefault().getStateLocation();
            this.file = new File(this.path.toString(), type);
            if (!this.file.exists() || !this.checkForXMLFile(this.file)) {
                this.createNewFile(this.file);
            }
            reader = null;
            try {
                reader = new FileReader(this.file);
                this.memento = XMLMemento.createReadRoot((Reader)reader);
            }
            catch (WorkbenchException wbe) {
                PMDPlugin.getDefault().logError("message.error.view_exception" + this.toString(), wbe);
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException v0) {}
                }
                break block19;
            }
            catch (FileNotFoundException fnfe) {
                try {
                    PMDPlugin.getDefault().logError("message.error.file_not_found" + this.path.toString() + "/" + type + " in " + this.toString(), fnfe);
                    ** if (reader == null) goto lbl-1000
                }
                catch (Throwable var4_5) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException v2) {}
                    }
                    throw var4_5;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        reader.close();
                    }
                    catch (IOException v1) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block19;
                }
            }
            if (reader == null) break block19;
            try {
                reader.close();
            }
            catch (IOException v3) {}
        }
        if (this.memento == null) {
            throw new IllegalStateException("Memento has not been built correctly. Check error log for details");
        }
    }

    protected final void createNewFile(File file) {
        block14: {
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(file);
                    writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<memento/>");
                }
                catch (IOException ioe) {
                    PMDPlugin.getDefault().logError("message.error.io_exception" + this.toString(), ioe);
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean checkForXMLFile(File file) {
        boolean isXmlFile = false;
        BufferedReader contentReader = null;
        try {
            contentReader = new BufferedReader(new FileReader(file));
            while (contentReader.ready()) {
                String line = contentReader.readLine();
                if (line == null || line.length() == 0) continue;
                isXmlFile = XML_PREFIX.equalsIgnoreCase(line);
                break;
            }
        }
        catch (FileNotFoundException fnfe) {
            PMDPlugin.getDefault().logError("message.error.file_not_found" + file.toString() + " in " + this.toString(), fnfe);
            if (contentReader == null) return isXmlFile;
            try {
                contentReader.close();
                return isXmlFile;
            }
            catch (IOException iOException) {}
            return isXmlFile;
        }
        catch (IOException ioe) {
            try {
                PMDPlugin.getDefault().logError("message.error.io_exception" + this.toString(), ioe);
                if (contentReader == null) return isXmlFile;
            }
            catch (Throwable throwable) {
                if (contentReader == null) throw throwable;
                try {
                    contentReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                contentReader.close();
                return isXmlFile;
            }
            catch (IOException iOException) {}
            return isXmlFile;
        }
        if (contentReader == null) return isXmlFile;
        try {
            contentReader.close();
            return isXmlFile;
        }
        catch (IOException iOException) {}
        return isXmlFile;
    }

    public void save() {
        block15: {
            if (this.memento != null) {
                FileWriter writer = null;
                try {
                    try {
                        writer = new FileWriter(this.file);
                        this.memento.save((Writer)writer);
                    }
                    catch (IOException ioe) {
                        PMDPlugin.getDefault().logError("message.error.io_exception" + this.toString(), ioe);
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private IMemento getAttribute(String name) {
        IMemento[] mementos = this.memento.getChildren(ATTRIBUTE_PREFIX);
        IMemento mem = null;
        IMemento[] iMementoArray = mementos;
        int n = mementos.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento2 = iMementoArray[n2];
            String attrName = memento2.getString(ATTR_NAME);
            if (name.equalsIgnoreCase(attrName)) {
                mem = memento2;
            }
            ++n2;
        }
        if (mem == null) {
            mem = this.memento.createChild(ATTRIBUTE_PREFIX);
            mem.putString(ATTR_NAME, name);
        }
        return mem;
    }

    public void putString(String key, String value) {
        IMemento mem = this.getAttribute(key);
        mem.putString(ATTR_VALUE, value);
    }

    public void putInteger(String key, int value) {
        IMemento mem = this.getAttribute(key);
        mem.putInteger(ATTR_VALUE, value);
    }

    public void putFloat(String key, float value) {
        IMemento mem = this.getAttribute(key);
        mem.putFloat(ATTR_VALUE, value);
    }

    public <T> void putList(String key, List<T> valueList) {
        if (valueList.isEmpty()) {
            this.putString(key, "");
            return;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(valueList.get(0)));
        int k = 1;
        while (k < valueList.size()) {
            sb.append(LIST_SEPARATOR).append(valueList.get(k));
            ++k;
        }
        this.putString(key, sb.toString());
    }

    public String getString(String key) {
        IMemento mem = this.getAttribute(key);
        return mem.getString(ATTR_VALUE);
    }

    public Integer getInteger(String key) {
        IMemento mem = this.getAttribute(key);
        return mem.getInteger(ATTR_VALUE);
    }

    public Float getFloat(String key) {
        IMemento mem = this.getAttribute(key);
        return mem.getFloat(ATTR_VALUE);
    }

    public List<Integer> getIntegerList(String key) {
        ArrayList<Integer> valuelist = new ArrayList<Integer>();
        String valueString = this.getString(key);
        if (valueString != null) {
            String[] objects;
            String[] stringArray = objects = valueString.split(LIST_SEPARATOR);
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                String object = stringArray[n2];
                if (StringUtil.isEmpty((String)object) || "null".equals(object)) {
                    valuelist.add(NumericConstants.ZERO);
                } else {
                    valuelist.add(Integer.valueOf(object));
                }
                ++n2;
            }
        }
        return valuelist;
    }

    public List<String> getStringList(String key) {
        List<String> valuelist = Collections.emptyList();
        String valueString = this.getString(key);
        if (valueString != null) {
            valuelist = new ArrayList<String>(Arrays.asList(valueString.split(LIST_SEPARATOR)));
        }
        return valuelist;
    }
}

