/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ProjectFilter
extends ViewerFilter {
    private List<AbstractPMDRecord> projectFilterList = new ArrayList<AbstractPMDRecord>();

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        boolean select = true;
        AbstractPMDRecord projectRec = null;
        if (element instanceof PackageRecord) {
            projectRec = ((PackageRecord)element).getParent();
        } else if (element instanceof FileRecord) {
            projectRec = ((FileRecord)element).getParent().getParent();
        } else if (element instanceof MarkerRecord) {
            projectRec = ((MarkerRecord)element).getParent().getParent().getParent();
        }
        if (this.projectFilterList.contains(projectRec)) {
            select = false;
        }
        return select;
    }

    public void setProjectFilterList(List<AbstractPMDRecord> newList) {
        this.projectFilterList = newList;
    }

    public List<AbstractPMDRecord> getProjectFilterList() {
        return this.projectFilterList;
    }

    public void addProjectToList(AbstractPMDRecord project) {
        this.projectFilterList.add(project);
    }

    public void removeProjectFromList(AbstractPMDRecord project) {
        this.projectFilterList.remove(project);
    }
}

