/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferences;
import net.sourceforge.pmd.eclipse.runtime.preferences.impl.PreferenceUIStore;
import net.sourceforge.pmd.eclipse.runtime.writer.IRuleSetWriter;
import net.sourceforge.pmd.eclipse.runtime.writer.WriterException;
import net.sourceforge.pmd.eclipse.ui.ColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleDupeChecker;
import net.sourceforge.pmd.eclipse.ui.preferences.RuleSetSelectionDialog;
import net.sourceforge.pmd.eclipse.ui.preferences.br.AbstractTreeTableManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.BasicRuleFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleFieldAccessor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleGroup;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleLabelProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelectionListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSetTreeItemProvider;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleTableColumns;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SimpleColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueResetHandler;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.CreateRuleWizard;
import net.sourceforge.pmd.eclipse.util.IOUtil;
import net.sourceforge.pmd.eclipse.util.ResourceManager;
import net.sourceforge.pmd.eclipse.util.Util;
import net.sourceforge.pmd.util.FileUtil;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.designer.Designer;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class RuleTableManager
extends AbstractTreeTableManager<Rule>
implements ValueChangeListener,
RuleDupeChecker {
    private RuleSet ruleSet;
    private RuleColumnDescriptor groupingColumn;
    protected String groupColumnLabel;
    private RuleFieldAccessor checkedColumnAccessor;
    private RuleSelection ruleSelection;
    private MenuItem useDefaultsItem;
    private Button addRuleButton;
    private Button removeRuleButton;
    private Button exportRuleSetButton;
    private RuleSelectionListener ruleSelectionListener;
    private ValueResetHandler resetHandler;

    public RuleTableManager(String theWidgetId, RuleColumnDescriptor[] theColumns, IPreferences thePreferences, ValueResetHandler aResetHandler) {
        super(theWidgetId, thePreferences, theColumns);
        this.columnSorter = RuleFieldAccessor.name;
        this.checkedColumnAccessor = this.createCheckedItemAccessor();
        this.resetHandler = aResetHandler;
    }

    @Override
    protected boolean isQualifiedItem(Object item) {
        return item instanceof Rule;
    }

    public List<Rule> activeRules() {
        Object[] checkedItems = this.treeViewer.getCheckedElements();
        ArrayList<Rule> activeOnes = new ArrayList<Rule>(checkedItems.length);
        Object[] objectArray = checkedItems;
        int n = checkedItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (this.isQualifiedItem(item)) {
                activeOnes.add((Rule)item);
            }
            ++n2;
        }
        return activeOnes;
    }

    @Override
    protected String nameFor(Object treeItemData) {
        return ((Rule)treeItemData).getName();
    }

    public void selectionListener(RuleSelectionListener theListener) {
        this.ruleSelectionListener = theListener;
    }

    private RuleFieldAccessor createCheckedItemAccessor() {
        return new BasicRuleFieldAccessor(){

            public Comparable<Boolean> valueFor(Rule rule) {
                return RuleTableManager.this.isActive(rule.getName());
            }
        };
    }

    @Override
    protected void addTableSelectionOptions(Menu menu) {
        this.useDefaultsItem = new MenuItem(menu, 8);
        this.useDefaultsItem.setText("Use defaults");
        this.useDefaultsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RuleTableManager.this.resetHandler.resetValuesIn(RuleTableManager.this.ruleSelection);
            }
        });
    }

    @Override
    protected void adjustTableMenuOptions() {
        boolean hasDefaults = this.ruleSelection.haveDefaultValues();
        this.useDefaultsItem.setEnabled(!hasDefaults);
    }

    public Button buildAddRuleButton(final Composite parent) {
        Button button = this.newImageButton(parent, "icons/add.gif", "preference.ruleset.button.addrule");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RuleTableManager.this.createRule(parent.getShell());
            }
        });
        return button;
    }

    private void createRule(Shell shell) {
        try {
            CreateRuleWizard wiz = new CreateRuleWizard();
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wiz);
            wiz.dialog(dialog);
            int result = dialog.open();
            if (result != 0) {
                return;
            }
            Rule addedRule = wiz.rule();
            this.ruleSet.addRule(addedRule);
            this.added(addedRule);
            this.setModified();
            try {
                this.refresh();
                this.treeViewer.reveal((Object)addedRule);
            }
            catch (Throwable t) {
                plugin.logError("Exception when refreshing the rule table", t);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Button buildRemoveRuleButton(Composite parent) {
        Button button = this.newImageButton(parent, "icons/delete.gif", "preference.ruleset.button.removerule");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RuleTableManager.this.removeSelectedItems();
            }
        });
        return button;
    }

    @Override
    protected void removeSelectedItems() {
        if (this.ruleSelection == null) {
            return;
        }
        int removeCount = this.ruleSelection.removeAllFrom(this.ruleSet);
        if (removeCount == 0) {
            return;
        }
        List<Rule> removedRules = this.ruleSelection.allRules();
        for (Rule r : removedRules) {
            this.preferences.isActive(r.getName(), false);
        }
        this.removed(removedRules);
        this.setModified();
        try {
            this.refresh();
        }
        catch (Throwable throwable) {
            this.treeViewer.setSelection(null);
        }
        this.updateCheckControls();
    }

    private Button buildExportRuleSetButton(Composite parent) {
        Button button = this.newImageButton(parent, "icons/export.gif", "preference.ruleset.button.exportruleset");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RuleTableManager.this.exportSelectedRules();
            }
        });
        return button;
    }

    private void exportSelectedRules() {
        Shell shell = this.treeViewer.getTree().getShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setText("Export " + this.ruleSelection.allRules().size() + " rules");
        String fileName = dialog.open();
        if (StringUtil.isNotEmpty((String)fileName)) {
            try {
                this.exportTo(fileName, shell);
            }
            catch (Exception e) {
                plugin.showError(this.getMessage("message.error.exporting_ruleset"), e);
            }
        }
    }

    private RuleSet ruleSelectionAsRuleSet() {
        RuleSet rs = new RuleSet();
        rs.setName(this.ruleSet.getName());
        rs.setDescription(this.ruleSet.getDescription());
        rs.setFileName(this.ruleSet.getFileName());
        rs.addExcludePatterns((Collection)this.ruleSet.getExcludePatterns());
        rs.addIncludePatterns((Collection)this.ruleSet.getIncludePatterns());
        for (Rule rule : this.ruleSelection.allRules()) {
            rs.addRule(rule);
        }
        return rs;
    }

    private void exportTo(String fileName, Shell shell) throws FileNotFoundException, WriterException, IOException {
        File file = new File(fileName);
        boolean flContinue = true;
        if (file.exists()) {
            flContinue = MessageDialog.openConfirm((Shell)shell, (String)this.getMessage("message.confirm.title"), (String)this.getMessage("message.confirm.ruleset_exists"));
        }
        InputDialog input = null;
        RuleSet ruleSet = null;
        if (flContinue) {
            ruleSet = this.ruleSelectionAsRuleSet();
            input = new InputDialog(shell, this.getMessage("preference.ruleset.dialog.title"), this.getMessage("preference.ruleset.dialog.ruleset_description"), ruleSet.getDescription() == null ? "" : ruleSet.getDescription().trim(), null);
            boolean bl = flContinue = input.open() == 0;
        }
        if (flContinue) {
            FileOutputStream out = null;
            try {
                ruleSet.setName(FileUtil.getFileNameWithoutExtension((String)file.getName()));
                ruleSet.setDescription(input.getValue());
                out = new FileOutputStream(fileName);
                IRuleSetWriter writer = plugin.getRuleSetWriter();
                writer.write(out, ruleSet);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(out);
                throw throwable;
            }
            IOUtil.closeQuietly(out);
            MessageDialog.openInformation((Shell)shell, (String)this.getMessage("message.information.title"), (String)this.getMessage("message.information.ruleset_exported"));
        }
    }

    private RuleColumnDescriptor newDupeIndicatorColumn() {
        return new SimpleColumnDescriptor("a", "", 0x1000000, 35, null, false, null){

            @Override
            public String stringValueFor(Rule rule) {
                return RuleTableManager.this.isDuplicate(rule) ? "X" : "";
            }

            @Override
            public Image imageFor(Rule rule) {
                return null;
            }
        };
    }

    private RuleColumnDescriptor[] ruleImportColumns() {
        return new RuleColumnDescriptor[]{this.newDupeIndicatorColumn(), new SimpleColumnDescriptor("a", RuleTableColumns.name.label(), 16384, 210, RuleTableColumns.name.accessor(), true, null), new SimpleColumnDescriptor("a", RuleTableColumns.language.label(), 16384, 40, RuleTableColumns.language.accessor(), true, null)};
    }

    private Button buildImportRuleSetButton(final Composite parent) {
        Button button = this.newImageButton(parent, "icons/import.gif", "preference.ruleset.button.importruleset");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RuleColumnDescriptor[] rcd = RuleTableManager.this.ruleImportColumns();
                RuleSetSelectionDialog dialog = new RuleSetSelectionDialog(parent.getShell(), "Import rules", rcd, RuleTableManager.this);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    RuleTableManager.this.doImport(dialog.checkedRules(), dialog.isImportByReference());
                }
            }
        });
        return button;
    }

    public static boolean areSemanticEquals(Rule a, Rule b) {
        return a.getName().equals(b.getName()) && a.getLanguage().equals(b.getLanguage());
    }

    @Override
    public boolean isDuplicate(Rule otherRule) {
        for (Rule rule : this.ruleSet.getRules()) {
            if (!RuleTableManager.areSemanticEquals(rule, otherRule)) continue;
            return true;
        }
        return false;
    }

    private void add(RuleSet incomingRuleSet) {
        for (Rule rule : incomingRuleSet.getRules()) {
            this.ruleSet.addRule(rule);
            rule.setRuleSetName(this.ruleSet.getName());
            this.added(rule);
        }
        this.ruleSet.addIncludePatterns((Collection)incomingRuleSet.getIncludePatterns());
        this.ruleSet.addExcludePatterns((Collection)incomingRuleSet.getExcludePatterns());
    }

    private void doImport(RuleSet selectedRuleSet, boolean doByReference) {
        try {
            if (doByReference) {
                RuleSet filteredRS = new RuleSet();
                filteredRS.setFileName(selectedRuleSet.getFileName());
                for (Rule rule : selectedRuleSet.getRules()) {
                    filteredRS.addRule(rule);
                }
                this.ruleSet.addRuleSetByReference(filteredRS, false);
                this.ruleSet.addIncludePatterns((Collection)selectedRuleSet.getIncludePatterns());
                this.ruleSet.addExcludePatterns((Collection)selectedRuleSet.getExcludePatterns());
            } else {
                this.add(selectedRuleSet);
            }
            this.setModified();
            try {
                this.refresh();
            }
            catch (Throwable t) {
                plugin.logError("Exception when refreshing the rule table", t);
            }
        }
        catch (RuntimeException e) {
            plugin.showError(this.getMessage("message.error.importing_ruleset"), e);
        }
        this.updateCheckControls();
    }

    public Composite buildGroupCombo(Composite parent, String comboLabelKey, final Object[][] groupingChoices) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(6, false);
        panel.setLayout((Layout)layout);
        this.buildCheckButtons(panel);
        Label label = new Label(panel, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 16384;
        data.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)data);
        label.setText(SWTUtil.stringFor(comboLabelKey));
        final Combo combo = new Combo(panel, 8);
        combo.setItems(SWTUtil.i18lLabelsIn(groupingChoices, 1));
        combo.select(groupingChoices.length - 1);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIdx = combo.getSelectionIndex();
                Object[] choice = groupingChoices[selectionIdx];
                RuleTableManager.this.groupingColumn = (RuleColumnDescriptor)choice[0];
                RuleTableManager.this.redrawTable();
            }
        });
        this.buildActiveCountWidgets(panel);
        return panel;
    }

    private Button buildRuleDesignerButton(Composite parent) {
        Button button = this.newImageButton(parent, "icons/editTool.png", "preference.ruleset.button.ruledesigner");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Designer.main((String[])new String[]{"-noexitonclose"});
                    }
                }).start();
            }
        });
        return button;
    }

    public Composite buildRuleTableButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 3;
        composite.setLayout((Layout)gridLayout);
        this.addRuleButton = this.buildAddRuleButton(composite);
        this.removeRuleButton = this.buildRemoveRuleButton(composite);
        Button importRuleSetButton = this.buildImportRuleSetButton(composite);
        this.exportRuleSetButton = this.buildExportRuleSetButton(composite);
        Button ruleDesignerButton = this.buildRuleDesignerButton(composite);
        GridData data = new GridData();
        this.addRuleButton.setLayoutData((Object)data);
        data = new GridData();
        importRuleSetButton.setLayoutData((Object)data);
        data = new GridData();
        this.exportRuleSetButton.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 3;
        ruleDesignerButton.setLayoutData((Object)data);
        return composite;
    }

    protected boolean hasIssue(TreeItem item) {
        Object data = item.getData();
        return data instanceof Rule && ((Rule)data).dysfunctionReason() != null;
    }

    protected void addIssueStyler(Tree tree) {
        Display display = tree.getDisplay();
        display.getSystemColor(7);
        tree.addListener(40, new Listener(){

            public void handleEvent(Event event) {
            }
        });
    }

    public Tree buildRuleTreeViewer(Composite parent) {
        this.buildTreeViewer(parent);
        Tree ruleTree = this.treeViewer.getTree();
        this.addIssueStyler(this.treeViewer.getTree());
        this.treeViewer.setCheckStateProvider(this.createCheckStateProvider());
        return ruleTree;
    }

    @Override
    public void changed(PropertySource source, PropertyDescriptor<?> desc, Object newValue) {
        this.treeViewer.update((Object)source, null);
        this.setModified();
    }

    @Override
    public void changed(RuleSelection selection, PropertyDescriptor<?> desc, Object newValue) {
        for (Rule rule : selection.allRules()) {
            if (newValue != null) {
                this.treeViewer.getTree().redraw();
                continue;
            }
            this.treeViewer.update((Object)rule, null);
        }
        this.setModified();
    }

    private void checkSelections() {
    }

    private ICheckStateProvider createCheckStateProvider() {
        return new ICheckStateProvider(){

            public boolean isChecked(Object item) {
                if (item instanceof Rule) {
                    return RuleTableManager.this.isActive(((Rule)item).getName());
                }
                if (item instanceof RuleGroup) {
                    SelectionStats stats = RuleTableManager.this.selectionRatioIn(((RuleGroup)item).rules());
                    return stats.selectedCount > 0 && stats.allSelected();
                }
                return false;
            }

            public boolean isGrayed(Object item) {
                if (item instanceof Rule) {
                    return false;
                }
                if (item instanceof RuleGroup) {
                    SelectionStats stats = RuleTableManager.this.selectionRatioIn(((RuleGroup)item).rules());
                    return stats.selectedCount > 0 && !stats.allSelected();
                }
                return false;
            }
        };
    }

    public void groupBy(RuleColumnDescriptor chosenColumn) {
        this.groupColumnLabel = chosenColumn == null ? null : chosenColumn.label();
        ArrayList<ColumnDescriptor> visibleColumns = new ArrayList<ColumnDescriptor>(this.availableColumns.length);
        ColumnDescriptor[] columnDescriptorArray = this.availableColumns;
        int n = this.availableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDescriptor desc = columnDescriptorArray[n2];
            if (desc != chosenColumn && !this.isHidden(desc)) {
                visibleColumns.add(desc);
            }
            ++n2;
        }
        this.setupTreeColumns(visibleColumns.toArray(new RuleColumnDescriptor[visibleColumns.size()]), chosenColumn == null ? null : chosenColumn.accessor());
        this.selectedItems(new Object[0]);
    }

    private String labelFor(TreeColumn tc) {
        return this.groupColumnLabel == null ? tc.getText() : String.valueOf(this.groupColumnLabel) + " / " + tc.getText();
    }

    public void populateRuleTable() {
        this.treeViewer.setInput((Object)this.ruleSet);
        this.checkSelections();
        this.restoreSavedRuleSelections();
        this.updateCheckControls();
    }

    @Override
    protected void redrawTable(String sortColumnLabel, int sortDir) {
        this.groupBy(this.groupingColumn);
        this.treeViewer.expandAll();
        this.treeViewer.collapseAll();
        super.redrawTable(sortColumnLabel, sortDir);
    }

    private void restoreSavedRuleSelections() {
        Set<String> names = PreferenceUIStore.instance.selectedRuleNames();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (String name : names) {
            rules.add(this.ruleSet.getRuleByName(name));
        }
        StructuredSelection selection = new StructuredSelection(rules);
        this.treeViewer.setSelection((ISelection)selection);
    }

    public RuleSet ruleSet() {
        return this.ruleSet;
    }

    @Override
    protected void saveItemSelections() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        ArrayList<String> ruleNames = new ArrayList<String>();
        for (Object item : selection.toList()) {
            if (!(item instanceof Rule)) continue;
            ruleNames.add(((Rule)item).getName());
        }
        PreferenceUIStore.instance.selectedRuleNames(ruleNames);
    }

    @Override
    protected void selectedItems(Object[] items) {
        boolean hasSelections;
        this.ruleSelection = new RuleSelection(items);
        if (this.ruleSelectionListener != null) {
            this.ruleSelectionListener.selection(this.ruleSelection);
        }
        boolean bl = hasSelections = items.length > 0;
        if (this.removeRuleButton != null) {
            this.removeRuleButton.setEnabled(hasSelections);
        }
        if (this.exportRuleSetButton != null) {
            this.exportRuleSetButton.setEnabled(hasSelections);
        }
    }

    private SelectionStats selectionRatioIn(Rule[] rules) {
        int selectedCount = 0;
        int dysfunctionCount = 0;
        Rule[] ruleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            if (this.isActive(rule.getName())) {
                ++selectedCount;
                if (StringUtil.isNotEmpty((String)rule.dysfunctionReason())) {
                    ++dysfunctionCount;
                }
            }
            ++n2;
        }
        return new SelectionStats(selectedCount, rules.length, dysfunctionCount);
    }

    @Override
    protected void setAllItemsActive() {
        Collection rules = this.ruleSet.getRules();
        Object[] rulesArray = rules.toArray(new Rule[rules.size()]);
        HashSet<String> activeRules = new HashSet<String>();
        int i = 0;
        while (i < rulesArray.length) {
            activeRules.add(rulesArray[i].getName());
            ++i;
        }
        this.preferences.setActiveRuleNames(activeRules);
        this.treeViewer().setCheckedElements(rulesArray);
        this.updateCheckControls();
        this.setModified();
    }

    private void setupTreeColumns(RuleColumnDescriptor[] columnDescs, RuleFieldAccessor groupingField) {
        TreeColumn[] columns;
        Tree ruleTree = this.cleanupRuleTree();
        this.createCheckBoxColumn(ruleTree);
        int i = 0;
        while (i < columnDescs.length) {
            TreeColumn tc = columnDescs[i].newTreeColumnFor(ruleTree, i + 1, this, this.paintListeners());
            if (i == 0 && this.groupingColumn != null) {
                tc.setText(this.labelFor(tc));
            }
            ++i;
        }
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new RuleLabelProvider(columnDescs));
        this.treeViewer.setContentProvider((IContentProvider)new RuleSetTreeItemProvider(groupingField, "??", Util.comparatorFrom(this.columnSorter(), this.sortDescending)));
        this.treeViewer.setInput((Object)this.ruleSet);
        this.checkSelections();
        TreeColumn[] treeColumnArray = columns = ruleTree.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
    }

    private RuleFieldAccessor columnSorter() {
        return (RuleFieldAccessor)this.columnSorter;
    }

    @Override
    protected void sortByCheckedItems() {
        this.sortBy(this.checkedColumnAccessor, this.treeViewer.getTree().getColumn(0));
    }

    public void useRuleSet(RuleSet theSet) {
        this.ruleSet = theSet;
    }

    private boolean activeRulesHaveIssues(Rule[] rules) {
        Rule[] ruleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule = ruleArray[n2];
            if (this.isActive(rule.getName()) && StringUtil.isNotEmpty((String)rule.dysfunctionReason())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void updateCheckControls() {
        Rule[] rules = new Rule[this.ruleSet.size()];
        rules = this.ruleSet.getRules().toArray(rules);
        SelectionStats stats = this.selectionRatioIn(rules);
        boolean hasIssues = stats.dysfunctionCount > 0;
        this.updateButtonsFor(stats.selectedCount, stats.totalCount);
        String label = SWTUtil.stringFor("preference.ruleset.label.active_rule_count");
        this.activeCountDetails(String.valueOf(label) + " " + this.activeItemCount() + " / " + this.ruleSet.size(), hasIssues ? ResourceManager.imageFor("icons/warn.gif") : null);
    }

    @Override
    protected void updateTooltipFor(TreeItem item, int columnIndex) {
        RuleLabelProvider provider = (RuleLabelProvider)this.treeViewer.getLabelProvider();
        String txt = provider.getDetailText(item.getData(), columnIndex);
        this.treeViewer.getTree().setToolTipText(txt);
    }

    private class SelectionStats {
        public int selectedCount;
        public int totalCount;
        public int dysfunctionCount;

        public SelectionStats(int theSelectedCount, int theTotalCount, int theDysfunctionCount) {
            this.selectedCount = theSelectedCount;
            this.totalCount = theTotalCount;
            this.dysfunctionCount = theDysfunctionCount;
        }

        public boolean allSelected() {
            return this.selectedCount == this.totalCount;
        }
    }
}

