/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ImplementationType;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleCollection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleGroup;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleVisitor;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.Configuration;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.lang.rule.properties.StringProperty;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;

public class RuleSelection
implements RuleCollection {
    private Object[] ruleItems;

    public RuleSelection(Rule soleRule) {
        this(new Object[]{soleRule});
    }

    @Override
    public boolean isEmpty() {
        return this.ruleItems == null || this.ruleItems.length == 0;
    }

    public RuleSelection(Object[] theRuleItems) {
        this.ruleItems = theRuleItems;
    }

    public void soleRule(Rule theRule) {
        this.ruleItems = new Object[]{theRule};
    }

    @Override
    public boolean rulesDo(RuleVisitor visitor) {
        Object[] objectArray = this.ruleItems;
        int n = this.ruleItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof Rule ? !visitor.accept((Rule)item) : item instanceof RuleGroup && !((RuleGroup)item).rulesDo(visitor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public ImplementationType implementationType() {
        if (this.ruleItems == null || this.ruleItems.length == 0) {
            return ImplementationType.Mixed;
        }
        final HashSet types = new HashSet();
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                types.add(RuleSelection.implementationType(rule));
                return types.size() < 2;
            }
        };
        this.rulesDo(visitor);
        return types.size() > 1 ? ImplementationType.Mixed : (ImplementationType)((Object)types.iterator().next());
    }

    public static final boolean valuesAreTransitivelyEqual(Object[] thisArray, Object[] thatArray) {
        if (thisArray == thatArray) {
            return true;
        }
        if (thisArray == null || thatArray == null) {
            return false;
        }
        if (thisArray.length != thatArray.length) {
            return false;
        }
        int i = 0;
        while (i < thisArray.length) {
            if (!CollectionUtil.areEqual((Object)thisArray[i], (Object)thatArray[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean haveDefaultValues() {
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                return rule.usesDefaultValues();
            }
        };
        return this.rulesDo(visitor);
    }

    public boolean hasOneRule() {
        if (this.ruleItems == null || this.ruleItems.length > 1) {
            return false;
        }
        return this.allRules().size() == 1;
    }

    public boolean hasMultipleRules() {
        return this.ruleItems != null && this.allRules().size() > 1;
    }

    @Override
    public Rule soleRule() {
        if (this.ruleItems == null || this.ruleItems.length != 1) {
            return null;
        }
        if (this.ruleItems[0] instanceof Rule) {
            return (Rule)this.ruleItems[0];
        }
        if (this.ruleItems[0] instanceof RuleGroup) {
            return ((RuleGroup)this.ruleItems[0]).soleRule();
        }
        return null;
    }

    public Collection<String> ruleGroupNames() {
        if (this.ruleItems == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        Object[] objectArray = this.ruleItems;
        int n = this.ruleItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof RuleGroup) {
                names.add(((RuleGroup)item).label());
            }
            ++n2;
        }
        return names;
    }

    private static void useDefaultValues(Rule rule) {
        for (Map.Entry<PropertyDescriptor<?>, Object> entry : Configuration.filteredPropertiesOf((PropertySource)rule).entrySet()) {
            rule.useDefaultValueFor(entry.getKey());
        }
    }

    public void useDefaultValues() {
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                RuleSelection.useDefaultValues(rule);
                return true;
            }
        };
        this.rulesDo(visitor);
    }

    public static ImplementationType implementationType(Rule rule) {
        if (rule instanceof RuleReference) {
            return ((RuleReference)rule).getRule() instanceof XPathRule ? ImplementationType.XPath : ImplementationType.Java;
        }
        return rule instanceof XPathRule ? ImplementationType.XPath : ImplementationType.Java;
    }

    public static String commonStringValueFor(Object item, StringProperty desc) {
        return item instanceof Rule ? (String)((Rule)item).getProperty((PropertyDescriptor)desc) : ((RuleGroup)item).commonStringProperty(desc);
    }

    public void setLanguage(final Language language) {
        if (this.ruleItems == null) {
            return;
        }
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                rule.setLanguage(language);
                return true;
            }
        };
        this.rulesDo(visitor);
    }

    public void setMinLanguageVersion(final LanguageVersion version) {
        if (this.ruleItems == null) {
            return;
        }
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                rule.setMinimumLanguageVersion(version);
                return true;
            }
        };
        this.rulesDo(visitor);
    }

    public void setMaxLanguageVersion(final LanguageVersion version) {
        if (this.ruleItems == null) {
            return;
        }
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                rule.setMaximumLanguageVersion(version);
                return true;
            }
        };
        this.rulesDo(visitor);
    }

    public void setPriority(final RulePriority priority) {
        if (this.ruleItems == null) {
            return;
        }
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                rule.setPriority(priority);
                return true;
            }
        };
        this.rulesDo(visitor);
    }

    public int removeAllFrom(RuleSet ruleSet) {
        List<Rule> rules = this.allRules();
        if (rules.isEmpty()) {
            return 0;
        }
        HashSet<Rule> rulesAsSet = new HashSet<Rule>();
        rulesAsSet.addAll(rules);
        Iterator currentRuleIter = ruleSet.getRules().iterator();
        int removed = 0;
        while (currentRuleIter.hasNext()) {
            Rule curRule = (Rule)currentRuleIter.next();
            if (!rulesAsSet.contains(curRule)) continue;
            currentRuleIter.remove();
            ++removed;
        }
        return removed;
    }

    public List<Rule> allRules() {
        if (this.ruleItems == null || this.ruleItems.length == 0) {
            return Collections.emptyList();
        }
        final ArrayList<Rule> rules = new ArrayList<Rule>(this.ruleItems.length);
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                rules.add(rule);
                return true;
            }
        };
        this.rulesDo(visitor);
        return rules;
    }

    public String commonStringValue(StringProperty desc) {
        if (this.ruleItems == null || this.ruleItems.length == 0 || desc == null) {
            return null;
        }
        String value = RuleSelection.commonStringValueFor(this.ruleItems[0], desc);
        if (value == null) {
            return null;
        }
        int i = 1;
        while (i < this.ruleItems.length) {
            if (StringUtil.areSemanticEquals((String)value, (String)RuleSelection.commonStringValueFor(this.ruleItems[i], desc))) {
                return null;
            }
            ++i;
        }
        return value;
    }

    public void setValue(final StringProperty desc, final String value) {
        if (this.ruleItems == null || this.ruleItems.length == 0) {
            return;
        }
        RuleVisitor visitor = new RuleVisitor(){

            @Override
            public boolean accept(Rule rule) {
                rule.setProperty((PropertyDescriptor)desc, (Object)value);
                return true;
            }
        };
        this.rulesDo(visitor);
    }

    public String toString() {
        List<Rule> rulz;
        StringBuilder sb = new StringBuilder();
        Collection<String> rgNames = this.ruleGroupNames();
        if (!rgNames.isEmpty()) {
            sb.append("groups: ").append(rgNames.size());
        }
        if (!(rulz = this.allRules()).isEmpty()) {
            sb.append(" rules: ").append(rulz.size());
        }
        return sb.toString();
    }
}

