/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.br;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleCollection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleVisitor;
import net.sourceforge.pmd.lang.rule.properties.StringProperty;
import net.sourceforge.pmd.util.StringUtil;

public class RuleGroup
implements RuleCollection,
Comparable<RuleGroup> {
    private Comparable id;
    private String label;
    private String description;
    private List<Rule> rules = new ArrayList<Rule>();

    public RuleGroup(Comparable<?> theId, String theLabel, String theDescription) {
        this.id = theId;
        this.label = theLabel;
        this.description = theDescription;
    }

    @Override
    public boolean isEmpty() {
        return this.rules == null || this.rules.isEmpty();
    }

    @Override
    public Rule soleRule() {
        return this.rules.size() == 1 ? this.rules.get(0) : null;
    }

    @Override
    public boolean rulesDo(RuleVisitor visitor) {
        for (Rule rule : this.rules) {
            if (visitor.accept(rule)) continue;
            return false;
        }
        return true;
    }

    public Comparable<?> id() {
        return this.id;
    }

    public String description() {
        return this.description;
    }

    public String label() {
        if (this.label != null) {
            return this.label;
        }
        return this.id == null ? "" : this.id.toString();
    }

    public void sortBy(Comparator ruleComparator) {
        if (!this.hasRules()) {
            return;
        }
        Object[] sortedRules = this.rules.toArray();
        Arrays.sort(sortedRules, ruleComparator);
        this.rules.clear();
        Object[] objectArray = sortedRules;
        int n = sortedRules.length;
        int n2 = 0;
        while (n2 < n) {
            Object rule = objectArray[n2];
            this.rules.add((Rule)rule);
            ++n2;
        }
    }

    public int ruleCount() {
        return this.rules.size();
    }

    public void add(Rule ref) {
        this.rules.add(ref);
    }

    public Rule[] rules() {
        return this.rules.toArray(new Rule[this.rules.size()]);
    }

    public String commonStringProperty(StringProperty desc) {
        if (this.rules.isEmpty()) {
            return null;
        }
        String value = (String)this.rules.get(0).getProperty((PropertyDescriptor)desc);
        int i = 1;
        while (i < this.rules.size()) {
            if (!StringUtil.areSemanticEquals((String)((String)this.rules.get(i).getProperty((PropertyDescriptor)desc)), (String)value)) {
                return null;
            }
            ++i;
        }
        return value;
    }

    public boolean hasRules() {
        return !this.rules.isEmpty();
    }

    public String toString() {
        return String.valueOf(this.label()) + " rules: " + this.ruleCount();
    }

    @Override
    public int compareTo(RuleGroup otherGroup) {
        if (this.id == null) {
            return -1;
        }
        if (otherGroup.id() == null) {
            return -1;
        }
        return this.id.compareTo(otherGroup.id());
    }
}

