/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.runtime.preferences.IPreferencesManager;
import net.sourceforge.pmd.eclipse.ui.BasicTableLabelProvider;
import net.sourceforge.pmd.eclipse.ui.filters.FilterColumnUI;
import net.sourceforge.pmd.eclipse.ui.filters.FilterHolder;
import net.sourceforge.pmd.eclipse.ui.preferences.br.AbstractPMDPreferencePage;
import net.sourceforge.pmd.eclipse.ui.preferences.br.BasicTableManager;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.util.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FilterPreferencesPage
extends AbstractPMDPreferencePage
implements ValueChangeListener,
SizeChangeListener {
    private TableViewer tableViewer;
    private Button addButton;
    private Button removeButton;
    private Button excludeButt;
    private Button includeButt;
    private Text patternField;
    private BasicTableManager<FilterHolder> reportTableMgr;
    private Collection<Control> editorWidgets = new ArrayList<Control>();
    private static Image IncludeIcon = plugin.getImage("include", "icons/ok.gif");
    private static Image ExcludeIcon = plugin.getImage("exclude", "icons/forbidden.png");
    private static final String NewFilterPattern = "<finish this>";

    public static Image typeIconFor(FilterHolder holder) {
        return holder.isInclude ? IncludeIcon : ExcludeIcon;
    }

    private static Label createLabel(Composite panel, String text) {
        Label label = new Label(panel, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(text);
        return label;
    }

    private static Button createButton(Composite panel, int type, Image image, String tooltip) {
        Button butt = new Button(panel, type);
        butt.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        butt.setImage(image);
        butt.setToolTipText(tooltip);
        return butt;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        Composite filterGroup = this.buildFilterGroup(composite);
        Composite buttonPanel = this.buildTableButtons(composite);
        filterGroup.setLayoutData((Object)new GridData(1808));
        buttonPanel.setLayoutData((Object)new GridData());
        this.buildFilterEditor(parent);
        this.updateControls();
        return composite;
    }

    private FilterHolder[] currentFilters() {
        ArrayList<FilterHolder> holders = new ArrayList<FilterHolder>();
        RuleSet ruleSet = plugin.getPreferencesManager().getRuleSet();
        for (String pattern : ruleSet.getExcludePatterns()) {
            holders.add(new FilterHolder(pattern, true, false, false));
        }
        for (String pattern : ruleSet.getIncludePatterns()) {
            holders.add(new FilterHolder(pattern, true, false, true));
        }
        return holders.toArray(new FilterHolder[holders.size()]);
    }

    private void enableEditor(boolean flag) {
        for (Control control : this.editorWidgets) {
            control.setEnabled(flag);
        }
    }

    private List<String> tableFilters(boolean isInclude) {
        ArrayList<String> filters = new ArrayList<String>();
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            FilterHolder fh = (FilterHolder)ti.getData();
            if (fh.isInclude == isInclude) {
                filters.add(fh.pattern);
            }
            ++n2;
        }
        return filters;
    }

    private Composite buildFilterGroup(Composite parent) {
        TableColumn[] columns;
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return (FilterHolder[])inputElement;
            }
        };
        BasicTableLabelProvider labelProvider = new BasicTableLabelProvider(FilterColumnUI.VisibleColumns);
        this.reportTableMgr = new BasicTableManager("renderers", null, FilterColumnUI.VisibleColumns);
        this.tableViewer = this.reportTableMgr.buildTableViewer(parent, 68386);
        this.reportTableMgr.setupColumns(FilterColumnUI.VisibleColumns);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)contentProvider);
        table.setHeaderVisible(true);
        this.tableViewer.setInput((Object)this.currentFilters());
        this.selectCheckedFilters();
        TableColumn[] tableColumnArray = columns = table.getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FilterPreferencesPage.this.patternsSelected();
            }
        });
        this.tableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    FilterPreferencesPage.this.checked(event.item);
                }
            }
        });
        return parent;
    }

    private void patternsSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        this.selectedPatterns(FilterPreferencesPage.filtersIn(selection.toList()));
        this.updateControls();
    }

    private void selectedPatterns(Collection<FilterHolder> holders) {
        FilterPreferencesPage.setState(holders, this.excludeButt, FilterHolder.ExcludeAccessor);
        FilterPreferencesPage.setState(holders, this.includeButt, FilterHolder.IncludeAccessor);
        FilterPreferencesPage.setValue(holders, this.patternField, FilterHolder.PatternAccessor);
    }

    private static void setState(Collection<FilterHolder> holders, Button button, FilterHolder.Accessor accessor) {
        Boolean state = FilterHolder.boolValueOf(holders, accessor);
        if (state == null) {
            button.setGrayed(true);
            return;
        }
        button.setSelection(state.booleanValue());
    }

    private static void setValue(Collection<FilterHolder> holders, Text field, FilterHolder.Accessor accessor) {
        String text = FilterHolder.textValueOf(holders, accessor);
        field.setText(text);
    }

    private void setAllInclude(boolean state) {
        for (FilterHolder fh : this.selectedFilters()) {
            fh.isInclude = state;
        }
    }

    private void setAllPatterns(String pattern) {
        for (FilterHolder fh : this.selectedFilters()) {
            fh.pattern = pattern;
        }
    }

    private void buildFilterEditor(Composite parent) {
        Composite editorPanel = new Composite(parent, 0);
        editorPanel.setLayoutData((Object)new GridData(4, 4, false, true));
        editorPanel.setLayout((Layout)new GridLayout(3, false));
        Label typeLabel = new Label(editorPanel, 0);
        typeLabel.setLayoutData((Object)new GridData());
        typeLabel.setText("Type:");
        this.editorWidgets.add((Control)typeLabel);
        this.excludeButt = FilterPreferencesPage.createButton(editorPanel, 16, ExcludeIcon, "Exclude");
        this.excludeButt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FilterPreferencesPage.this.setAllInclude(!FilterPreferencesPage.this.includeButt.getSelection());
                FilterPreferencesPage.this.tableViewer.refresh();
            }
        });
        this.includeButt = FilterPreferencesPage.createButton(editorPanel, 16, IncludeIcon, "Include");
        this.includeButt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                FilterPreferencesPage.this.setAllInclude(FilterPreferencesPage.this.includeButt.getSelection());
                FilterPreferencesPage.this.tableViewer.refresh();
            }
        });
        this.editorWidgets.add((Control)this.excludeButt);
        this.editorWidgets.add((Control)this.includeButt);
        Label patternLabel = FilterPreferencesPage.createLabel(editorPanel, "Pattern:");
        this.editorWidgets.add((Control)patternLabel);
        this.patternField = new Text(editorPanel, 2048);
        this.patternField.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        this.patternField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                FilterPreferencesPage.this.setAllPatterns(FilterPreferencesPage.this.patternField.getText());
                FilterPreferencesPage.this.tableViewer.refresh();
            }
        });
        this.editorWidgets.add((Control)this.patternField);
        FilterPreferencesPage.createLabel(editorPanel, "");
        Label description = new Label(editorPanel, 0);
        description.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        description.setText("name or path pattern (* = any string, ? = any character)");
        this.editorWidgets.add((Control)description);
    }

    public Composite buildTableButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 3;
        composite.setLayout((Layout)gridLayout);
        this.addButton = this.buildAddButton(composite);
        this.removeButton = this.buildRemoveButton(composite);
        GridData data = new GridData();
        this.addButton.setLayoutData((Object)data);
        return composite;
    }

    private void selectCheckedFilters() {
        Set<String> activeOnes = this.preferences.activeExclusionPatterns();
        activeOnes.addAll(this.preferences.activeInclusionPatterns());
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            FilterHolder holder = (FilterHolder)item.getData();
            item.setChecked(activeOnes.contains(holder.pattern));
            ++n2;
        }
    }

    private Set<FilterHolder> currentCheckedFilters() {
        HashSet<FilterHolder> holders = new HashSet<FilterHolder>();
        for (Object holder : FilterPreferencesPage.checkedItems(this.tableViewer.getTable())) {
            holders.add((FilterHolder)holder);
        }
        return holders;
    }

    private Set<FilterHolder> selectedFilters() {
        HashSet<FilterHolder> holders = new HashSet<FilterHolder>();
        TableItem[] tableItemArray = this.tableViewer.getTable().getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tItem = tableItemArray[n2];
            holders.add((FilterHolder)tItem.getData());
            ++n2;
        }
        return holders;
    }

    private static Collection<FilterHolder> filtersIn(List<?> tableItems) {
        HashSet<FilterHolder> holders = new HashSet<FilterHolder>();
        for (Object tItem : tableItems) {
            holders.add((FilterHolder)tItem);
        }
        return holders;
    }

    private static Set<Object> checkedItems(Table table) {
        HashSet<Object> checkedItems = new HashSet<Object>();
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            if (ti.getChecked()) {
                checkedItems.add(ti.getData());
            }
            ++n2;
        }
        return checkedItems;
    }

    private void checked(Object item) {
        boolean matches = this.currentCheckedFilters().equals(this.preferences.activeExclusionPatterns());
        this.setModified(!matches);
    }

    protected void performDefaults() {
    }

    public boolean performCancel() {
        this.selectCheckedFilters();
        return true;
    }

    private static Set<String> patternsIn(Collection<FilterHolder> holders, boolean getInclusions) {
        if (holders.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> patterns = new HashSet<String>();
        for (FilterHolder holder : holders) {
            if (holder.isInclude != getInclusions) continue;
            patterns.add(holder.pattern);
        }
        return patterns;
    }

    protected Button newImageButton(Composite parent, String imageId, String toolTipId) {
        Button button = new Button(parent, 16392);
        button.setImage(ResourceManager.imageFor(imageId));
        button.setToolTipText(this.getMessage(toolTipId));
        button.setEnabled(true);
        return button;
    }

    public Button buildAddButton(Composite parent) {
        Button button = this.newImageButton(parent, "icons/add.gif", "preference.ruleset.button.addfilter");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FilterPreferencesPage.this.addNewFilter();
            }
        });
        return button;
    }

    private FilterHolder[] tableFiltersWith(FilterHolder anotherOne) {
        FilterHolder[] holders = new FilterHolder[this.tableViewer.getTable().getItemCount() + (anotherOne == null ? 0 : 1)];
        TableItem[] items = this.tableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            holders[i] = (FilterHolder)items[i].getData();
            ++i;
        }
        if (anotherOne != null) {
            holders[holders.length - 1] = anotherOne;
        }
        return holders;
    }

    private void addNewFilter() {
        FilterHolder newHolder = new FilterHolder(NewFilterPattern, true, false, false);
        FilterHolder[] holders = this.tableFiltersWith(newHolder);
        this.tableViewer.setInput((Object)holders);
        this.tableViewer.getTable().setSelection(holders.length - 1);
        this.patternsSelected();
        this.patternField.selectAll();
        this.patternField.forceFocus();
    }

    public Button buildRemoveButton(Composite parent) {
        Button button = this.newImageButton(parent, "icons/delete.gif", "preference.ruleset.button.removefilter");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FilterPreferencesPage.this.deleteSelected();
            }
        });
        return button;
    }

    private void deleteSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        if (sel.isEmpty()) {
            return;
        }
        Object[] selections = sel.toArray();
        this.tableViewer.remove(selections);
    }

    @Override
    public boolean performOk() {
        IPreferencesManager ipMgr = plugin.getPreferencesManager();
        RuleSet ruleSet = ipMgr.getRuleSet();
        ruleSet.setExcludePatterns(this.tableFilters(false));
        ruleSet.setIncludePatterns(this.tableFilters(true));
        ipMgr.setRuleSet(ruleSet);
        Set<FilterHolder> filters = this.currentCheckedFilters();
        this.preferences.activeExclusionPatterns(FilterPreferencesPage.patternsIn(filters, false));
        this.preferences.activeInclusionPatterns(FilterPreferencesPage.patternsIn(filters, true));
        this.preferences.sync();
        if (this.isModified()) {
            this.rebuildProjects();
        }
        return super.performOk();
    }

    @Override
    protected String descriptionId() {
        return "???";
    }

    @Override
    public void changed(PropertySource source, PropertyDescriptor<?> desc, Object newValue) {
    }

    private void updateControls() {
        boolean hasSelections = !this.selectedFilters().isEmpty();
        this.removeButton.setEnabled(hasSelections);
        this.enableEditor(hasSelections);
    }

    @Override
    public void addedRows(int newRowCount) {
    }

    @Override
    public void changed(RuleSelection rule, PropertyDescriptor<?> desc, Object newValue) {
    }
}

