/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import net.sourceforge.pmd.eclipse.runtime.builder.MarkerUtil;
import net.sourceforge.pmd.eclipse.ui.actions.AbstractUIAction;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class PMDRemoveMarkersAction
extends AbstractUIAction
implements IViewActionDelegate {
    private static final String VIEW_ACTION = "net.sourceforge.pmd.eclipse.ui.pmdRemoveAllMarkersAction";
    private static final String OBJECT_ACTION = "net.sourceforge.pmd.eclipse.ui.pmdRemoveMarkersAction";
    private static final Logger log = Logger.getLogger(PMDRemoveMarkersAction.class);

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        log.info((Object)"Remove Markers action requested");
        try {
            if (action.getId().equals(VIEW_ACTION)) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                MarkerUtil.deleteAllMarkersIn((IResource)root);
                log.debug((Object)"Remove markers over the whole workspace");
            } else if (action.getId().equals(OBJECT_ACTION)) {
                this.processResource();
            } else {
                log.warn((Object)"Cannot remove markers, action ID is not supported");
            }
        }
        catch (CoreException e) {
            this.showErrorById("message.error.core_exception", e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void processResource() {
        log.debug((Object)"Processing a resource");
        try {
            if (this.isViewPart()) {
                ISelection sel = this.targetSelection();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection structuredSel = (IStructuredSelection)sel;
                    for (Object element : structuredSel) {
                        this.processElement(element);
                    }
                } else {
                    log.warn((Object)"The view part selection is not a structured selection !");
                }
            } else if (this.isEditorPart()) {
                IEditorInput editorInput = ((IEditorPart)this.targetPart()).getEditorInput();
                if (editorInput instanceof IFileEditorInput) {
                    MarkerUtil.deleteAllMarkersIn((IResource)((IFileEditorInput)editorInput).getFile());
                    log.debug((Object)("Remove markers on currently edited file " + ((IFileEditorInput)editorInput).getFile().getName()));
                } else {
                    log.debug((Object)("The kind of editor input is not supported. The editor input type: " + editorInput.getClass().getName()));
                }
            } else {
                log.debug((Object)("This action is not supported on that part. This part type is: " + this.targetPartClassName()));
            }
        }
        catch (CoreException e) {
            this.showErrorById("message.error.core_exception", e);
        }
    }

    private void processElement(Object element) throws CoreException {
        if (element instanceof AbstractPMDRecord) {
            AbstractPMDRecord record = (AbstractPMDRecord)element;
            IResource resource = record.getResource();
            if (this.isViolationOverview()) {
                ((ViolationOverview)this.targetPart()).deleteMarkers(record);
            }
            log.debug((Object)("Remove markers on resource " + resource.getName()));
        } else if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource == null) {
                log.warn((Object)"The selected object cannot adapt to a resource");
                log.debug((Object)("   -> selected object : " + element));
            } else {
                MarkerUtil.deleteAllMarkersIn(resource);
                log.debug((Object)("Remove markers on resrouce " + resource.getName()));
            }
        } else {
            log.warn((Object)"The selected object is not adaptable");
            log.debug((Object)("   -> selected object : " + element));
        }
    }
}

