/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.util.List;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.RenderReportsCmd;
import net.sourceforge.pmd.eclipse.ui.actions.AbstractUIAction;
import net.sourceforge.pmd.eclipse.ui.reports.ReportManager;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class GenerateReportAction
extends AbstractUIAction {
    private static final Logger log = Logger.getLogger(GenerateReportAction.class);
    private static final String DefaultReportName = "pmd-report";

    private void registerRenderers(RenderReportsCmd cmd) {
        ReportManager.loadReportProperties();
        for (Renderer renderer : ReportManager.instance.activeRenderers()) {
            cmd.registerRenderer(renderer, "pmd-report." + renderer.defaultFileExtension());
        }
    }

    private boolean checkRenderers() {
        List<Renderer> renderers = ReportManager.instance.activeRenderers();
        if (renderers.isEmpty()) {
            PMDPlugin.getDefault().showUserError("No report renderers selected");
            return false;
        }
        StringBuilder errors = new StringBuilder();
        for (Renderer renderer : renderers) {
            String issue = renderer.dysfunctionReason();
            if (!StringUtil.isNotEmpty((String)issue)) continue;
            errors.append(renderer.getName()).append(": ");
            errors.append(issue).append("\n");
        }
        if (errors.length() == 0) {
            return true;
        }
        PMDPlugin.getDefault().showUserError(errors.toString());
        return false;
    }

    public final void run(IAction action) {
        log.info((Object)"Generation Report action requested");
        ISelection sel = this.targetSelection();
        if (sel instanceof IStructuredSelection) {
            try {
                IProject project = GenerateReportAction.getProject((IStructuredSelection)sel);
                if (project != null) {
                    if (!this.checkRenderers()) {
                        return;
                    }
                    RenderReportsCmd cmd = new RenderReportsCmd();
                    cmd.setProject(project);
                    cmd.setUserInitiated(true);
                    this.registerRenderers(cmd);
                    cmd.performExecute();
                }
            }
            catch (CommandException e) {
                this.showErrorById("message.error.pmd_exception", e);
            }
        }
    }

    public final void selectionChanged(IAction action, ISelection selection) {
    }

    private static IProject getProject(IStructuredSelection selection) {
        IResource resource;
        Object object = selection.getFirstElement();
        if (object != null && object instanceof IAdaptable && (resource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) != null) {
            return resource.getProject();
        }
        return null;
    }
}

