/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import name.herlin.command.AbstractProcessableCommand;
import name.herlin.command.CommandException;
import name.herlin.command.CommandProcessor;
import name.herlin.command.Timer;
import name.herlin.command.UnsetInputPropertiesException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class JobCommandProcessor
implements CommandProcessor {
    private static final Logger log = Logger.getLogger(JobCommandProcessor.class);
    private final Map<AbstractProcessableCommand, Job> jobs = Collections.synchronizedMap(new HashMap());
    private static ConcurrentLinkedQueue<Job> outstanding = new ConcurrentLinkedQueue();
    private static AtomicInteger count = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processCommand(final AbstractProcessableCommand aCommand) throws CommandException {
        log.debug((Object)("Begining job command " + aCommand.getName()));
        if (!aCommand.isReadyToExecute()) {
            throw new UnsetInputPropertiesException();
        }
        Job job = new Job(aCommand.getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (aCommand instanceof AbstractDefaultCommand) {
                        ((AbstractDefaultCommand)aCommand).setMonitor(monitor);
                    }
                    Timer timer = new Timer();
                    aCommand.execute();
                    timer.stop();
                    PMDPlugin.getDefault().logInformation("Command " + aCommand.getName() + " excecuted in " + timer.getDuration() + "ms");
                }
                catch (CommandException e) {
                    PMDPlugin.getDefault().logError("Error executing command " + aCommand.getName(), e);
                }
                ConcurrentLinkedQueue concurrentLinkedQueue = outstanding;
                synchronized (concurrentLinkedQueue) {
                    count.decrementAndGet();
                    Job job = (Job)outstanding.poll();
                    if (job != null) {
                        job.schedule();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        if (aCommand instanceof AbstractDefaultCommand) {
            job.setUser(((AbstractDefaultCommand)aCommand).isUserInitiated());
        }
        ConcurrentLinkedQueue<Job> concurrentLinkedQueue = outstanding;
        synchronized (concurrentLinkedQueue) {
            if (count.incrementAndGet() > 10) {
                outstanding.add(job);
            } else {
                job.schedule();
            }
        }
        this.addJob(aCommand, job);
        log.debug((Object)("Ending job command " + aCommand.getName()));
    }

    @Override
    public void waitCommandToFinish(AbstractProcessableCommand aCommand) throws CommandException {
        Job job = this.jobs.get(aCommand);
        if (job != null) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                throw new CommandException(e);
            }
        }
    }

    private void addJob(AbstractProcessableCommand command, Job job) {
        this.jobs.put(command, job);
        for (AbstractProcessableCommand aCommand : this.jobs.keySet()) {
            Job aJob = this.jobs.get(aCommand);
            if (aJob != null && aJob.getResult() == null) continue;
            this.jobs.remove(aCommand);
        }
    }
}

