/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.cpd.CPD;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractProjectCommand;
import net.sourceforge.pmd.eclipse.runtime.cmd.CPDVisitor;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.util.IOUtil;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;

public class DetectCutAndPasteCmd
extends AbstractProjectCommand {
    private Language language;
    private int minTileSize;
    private Renderer renderer;
    private String reportName;
    private boolean createReport;
    private List<IPropertyListener> listeners;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(DetectCutAndPasteCmd.class);

    public DetectCutAndPasteCmd() {
        super("DetectCutAndPaste", "Detect Cut & paste for a project");
        this.setOutputProperties(true);
        this.setReadOnly(false);
        this.setTerminated(false);
        this.listeners = new ArrayList<IPropertyListener>();
    }

    private void notifyListeners(final CPD cpd) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (IPropertyListener listener : DetectCutAndPasteCmd.this.listeners) {
                    listener.propertyChanged((Object)cpd.getMatches(), 1111);
                }
            }
        });
    }

    @Override
    public void execute() throws CommandException {
        try {
            try {
                List<File> files = this.findCandidateFiles();
                if (files.isEmpty()) {
                    DetectCutAndPasteCmd.logInfo("No files found for specified language.");
                } else {
                    DetectCutAndPasteCmd.logInfo("Found " + files.size() + " files for the specified language. Performing CPD.");
                }
                this.setStepCount(files.size());
                this.beginTask("Finding suspect Cut And Paste", this.getStepCount() * 2);
                if (!this.isCanceled()) {
                    CPD cpd = this.detectCutAndPaste(files);
                    if (!this.isCanceled()) {
                        if (this.createReport) {
                            this.renderReport(cpd.getMatches());
                        }
                        this.notifyListeners(cpd);
                    }
                }
            }
            catch (CoreException e) {
                log.debug((Object)("Core Exception: " + e.getMessage()), (Throwable)e);
                throw new CommandException(e);
            }
            catch (PropertiesException e) {
                log.debug((Object)("Properties Exception: " + e.getMessage()), (Throwable)e);
                throw new CommandException(e);
            }
        }
        finally {
            this.setTerminated(true);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setTerminated(false);
        this.setReportName(null);
        this.setRenderer(null);
        this.setLanguage("java");
        this.setMinTileSize(PMDPlugin.getDefault().loadPreferences().getMinTileSize());
        this.setCreateReport(false);
        this.addPropertyListener(null);
        this.listeners = new ArrayList<IPropertyListener>();
    }

    public void setLanguage(String theLanguage) {
        this.language = LanguageFactory.createLanguage((String)theLanguage);
    }

    public void setMinTileSize(int tilesize) {
        this.minTileSize = tilesize;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public void setCreateReport(boolean render) {
        this.createReport = render;
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.listeners.add(listener);
    }

    private boolean canRenderReport() {
        return this.renderer != null && StringUtil.isNotEmpty((String)this.reportName);
    }

    @Override
    public boolean isReadyToExecute() {
        return super.isReadyToExecute() && this.language != null && (!this.createReport || this.canRenderReport());
    }

    private List<File> findCandidateFiles() throws PropertiesException, CoreException {
        IProjectProperties properties = this.projectProperties();
        CPDVisitor visitor = new CPDVisitor();
        visitor.setWorkingSet(properties.getProjectWorkingSet());
        visitor.setIncludeDerivedFiles(properties.isIncludeDerivedFiles());
        visitor.setLanguage(this.language);
        visitor.setFiles(new ArrayList<File>());
        this.visitProjectResourcesWith(visitor);
        return visitor.getFiles();
    }

    private CPD detectCutAndPaste(List<File> files) {
        log.debug((Object)"Searching for project files");
        CPD cpd = this.newCPD();
        this.subTask("Collecting files for CPD");
        Iterator<File> fileIterator = files.iterator();
        while (fileIterator.hasNext() && !this.isCanceled()) {
            File file = fileIterator.next();
            try {
                cpd.add(file);
                this.worked(1);
            }
            catch (IOException e) {
                log.warn((Object)("IOException when adding file " + file.getName() + " to CPD. Continuing."), (Throwable)e);
            }
        }
        if (!this.isCanceled()) {
            this.subTask("Performing CPD");
            log.debug((Object)"Performing CPD");
            cpd.go();
            this.worked(this.getStepCount());
        }
        return cpd;
    }

    private CPD newCPD() {
        CPDConfiguration config = new CPDConfiguration();
        config.setMinimumTileSize(this.minTileSize);
        config.setLanguage(this.language);
        config.setEncoding(System.getProperty("file.encoding"));
        return new CPD(config);
    }

    private void renderReport(Iterator<Match> matches) throws CommandException {
        ByteArrayInputStream contentsStream = null;
        try {
            try {
                log.debug((Object)"Rendering CPD report");
                this.subTask("Rendering CPD report");
                String reportString = this.renderer.render(matches);
                log.debug((Object)"Create the report folder");
                IFolder folder = this.getProjectFolder("reports");
                if (!folder.exists()) {
                    folder.create(true, true, this.getMonitor());
                }
                log.debug((Object)"Create the report file");
                IFile reportFile = folder.getFile(this.reportName);
                contentsStream = new ByteArrayInputStream(reportString.getBytes());
                if (reportFile.exists()) {
                    log.debug((Object)"   Overwriting report file");
                    reportFile.setContents((InputStream)contentsStream, true, false, this.getMonitor());
                } else {
                    log.debug((Object)"   Creating report file");
                    reportFile.create((InputStream)contentsStream, true, this.getMonitor());
                }
                reportFile.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException e) {
                log.debug((Object)("Core Exception: " + e.getMessage()), (Throwable)e);
                throw new CommandException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(contentsStream);
            throw throwable;
        }
        IOUtil.closeQuietly(contentsStream);
    }
}

