/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.core.internal.container;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.m2e.model.edit.pom.Dependency;
import org.eclipse.m2e.model.edit.pom.PomFactory;
import org.eclipse.m2e.model.edit.pom.Profile;
import org.jboss.forge.arquillian.container.Container;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;

public class ProfileGenerator {
    private static Map<String, Profile> profiles = new HashMap<String, Profile>();

    public static Profile getProfile(Container container) {
        if (container == null) {
            return null;
        }
        String id = container.getId();
        Profile profile = profiles.get(id);
        if (profile == null) {
            profile = PomFactory.eINSTANCE.createProfile();
            profile.setId(id);
            Dependency dependency = PomFactory.eINSTANCE.createDependency();
            dependency.setArtifactId(container.getArtifact_id());
            dependency.setGroupId(container.getGroup_id());
            ProfileGenerator.resolveVersion(dependency);
            profile.getDependencies().add((Object)dependency);
            List<org.jboss.forge.arquillian.container.Dependency> dependencies = container.getDependencies();
            if (dependencies != null) {
                for (org.jboss.forge.arquillian.container.Dependency fd : dependencies) {
                    Dependency dep = PomFactory.eINSTANCE.createDependency();
                    dep.setArtifactId(fd.getArtifact_id());
                    dep.setGroupId(fd.getGroup_id());
                    ProfileGenerator.resolveVersion(dep);
                    profile.getDependencies().add((Object)dep);
                }
            }
            profiles.put(id, profile);
        }
        return profile;
    }

    private static Map<String, Profile> getProfiles() {
        return profiles;
    }

    private static void resolveVersion(Dependency dep) {
        String coords = String.valueOf(dep.getGroupId()) + ":" + dep.getArtifactId() + ":[0,)";
        String version = ArquillianUtility.getHighestVersion(coords);
        dep.setVersion(version);
    }

    public static void clearProfiles() {
        profiles.clear();
    }
}

