/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.maven.configurator;

import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.jboss.tools.arquillian.core.internal.util.ArquillianUtility;
import org.jboss.tools.maven.ui.Activator;

public class ArquillianProjectConfigurator
extends AbstractProjectConfigurator {
    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        MavenProject mavenProject = request.getMavenProject();
        IProject project = request.getProject();
        this.configureInternal(mavenProject, project, monitor);
    }

    private void configureInternal(MavenProject mavenProject, IProject project, IProgressMonitor monitor) throws CoreException {
        if (!this.isArquilianConfigurable(mavenProject) || project.hasNature("org.jboss.tools.arquillian.core.arquillianNature")) {
            return;
        }
        if (project.hasNature("org.eclipse.jdt.core.javanature") && this.isArquillianProject(mavenProject)) {
            ArquillianUtility.addArquillianNature((IProject)project);
        }
    }

    private boolean isArquilianConfigurable(MavenProject mavenProject) {
        boolean configureArquillian;
        String arquillianActivation = mavenProject.getProperties().getProperty("m2e.arquillian.activation");
        if (arquillianActivation == null) {
            IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
            configureArquillian = prefs.getBoolean("configureArquillian");
        } else {
            configureArquillian = Boolean.valueOf(arquillianActivation);
        }
        return configureArquillian;
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = event.getMavenProject();
        if (facade != null) {
            IProject project = facade.getProject();
            MavenProject mavenProject = facade.getMavenProject(monitor);
            this.configureInternal(mavenProject, project, monitor);
        }
    }

    private boolean isArquillianProject(MavenProject mavenProject) {
        String version = ArquillianUtility.getArquillianVersion((MavenProject)mavenProject);
        return version != null;
    }
}

